/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.ConfigScreen;
import dlovin.inventoryhud.gui.widgets.CustomButton;
import dlovin.inventoryhud.gui.widgets.NumericTextField;
import dlovin.inventoryhud.gui.widgets.TextWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;
import net.minecraft.util.text.TextFormatting;

public class InventoryConfigScreen
extends ConfigScreen {
    private CustomButton ToggleBtn;
    private CustomButton MiniModeBtn;
    private CustomButton VerticalModeBtn;
    private CustomButton AnimatedBtn;
    private CustomButton HideBGBtn;
    private NumericTextField AlphaField;

    public InventoryConfigScreen(boolean inGame) {
        super(0, inGame);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        String toggle = (Boolean)InventoryHUD.getConfig().getClient().byDefault.get() != false ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.ToggleBtn = new CustomButton(this.field_230708_k_ / 2 + 20, 0, 40, 20, toggle, null, false);
        this.OptionList.addWidget(this.ToggleBtn, 0);
        this.ToggleBtn.addListener(this::ToggleSwitch);
        this.MiniModeBtn = new CustomButton(this.field_230708_k_ / 2 + 20, 0, 40, 20, ((Boolean)InventoryHUD.getConfig().getClient().invMini.get()).toString(), null, false);
        this.OptionList.addWidget(this.MiniModeBtn, 2);
        this.MiniModeBtn.addListener(this::MiniModeSwitch);
        this.VerticalModeBtn = new CustomButton(this.field_230708_k_ / 2 + 20, 0, 40, 20, ((Boolean)InventoryHUD.getConfig().getClient().invVert.get()).toString(), null, false);
        this.OptionList.addWidget(this.VerticalModeBtn, 1);
        this.VerticalModeBtn.addListener(this::VerticalModeSwitch);
        this.AlphaField = new NumericTextField(this.field_230712_o_, this.field_230708_k_ / 2 + 20, 0, 40, 20, 0, 100, (Integer)InventoryHUD.getConfig().getClient().invAlpha.get(), tf -> this.AlphaChanged());
        this.OptionList.addWidget(this.AlphaField, 3);
        this.AnimatedBtn = new CustomButton(this.field_230708_k_ / 2 + 20, 0, 40, 20, ((Boolean)InventoryHUD.getClient().animatedInv.get()).toString(), null, false);
        this.OptionList.addWidget(this.AnimatedBtn, 4);
        this.HideBGBtn = new CustomButton(this.field_230708_k_ / 2 + 20, 0, 40, 20, ((Boolean)InventoryHUD.getClient().hideBackground.get()).toString(), null, false);
        this.OptionList.addWidget(this.HideBGBtn, 5);
        this.AnimatedBtn.addListener(this::AnimatedChanged);
        this.HideBGBtn.addListener(this::HideBGChanged);
        this.AlphaField.setMaxStringLength(5);
        this.OptionList.addWidget(new TextWidget(this.field_230708_k_ / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_HIDEBG.getString(), this.field_230712_o_, (w, m, x, y) -> this.func_238652_a_(m, Translation.INV_HIDEBG_TT, x, y)), 5);
        this.OptionList.addWidget(new TextWidget(this.field_230708_k_ / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_ANIMATED.getString(), this.field_230712_o_, (w, m, x, y) -> this.func_238652_a_(m, Translation.INV_ANIMATED_TT, x, y)), 4);
        this.OptionList.addWidget(new TextWidget(this.field_230708_k_ / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_ALPHA.getString(), this.field_230712_o_, (w, m, x, y) -> this.func_238652_a_(m, Translation.INV_ALPHA_TT, x, y)), 3);
        this.OptionList.addWidget(new TextWidget(this.field_230708_k_ / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_MINI.getString(), this.field_230712_o_, (w, m, x, y) -> this.func_238652_a_(m, Translation.INV_MINI_TT, x, y)), 2);
        this.OptionList.addWidget(new TextWidget(this.field_230708_k_ / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_VERT.getString(), this.field_230712_o_, (w, m, x, y) -> this.func_243308_b(m, Translation.INV_VERT_TT, x, y)), 1);
        this.OptionList.addWidget(new TextWidget(this.field_230708_k_ / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_TOGGLE.getString(), this.field_230712_o_, (w, m, x, y) -> this.func_238652_a_(m, Translation.INV_TOGGLE_TT, x, y)), 0);
    }

    private void AnimatedChanged() {
        Boolean mm = (Boolean)InventoryHUD.getClient().animatedInv.get() == false;
        InventoryGui.animated = mm;
        InventoryHUD.getClient().animatedInv.set((Object)mm);
        this.AnimatedBtn.setMessage(mm.toString());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void HideBGChanged() {
        Boolean mm = (Boolean)InventoryHUD.getClient().hideBackground.get() == false;
        InventoryGui.hideBackground = mm;
        InventoryHUD.getClient().hideBackground.set((Object)mm);
        this.HideBGBtn.setMessage(mm.toString());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void AlphaChanged() {
        int a;
        try {
            a = Integer.parseInt(this.AlphaField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryGui.invAlpha = (float)a / 100.0f;
        InventoryHUD.getConfig().getClient().invAlpha.set((Object)a);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void MiniModeSwitch() {
        Boolean mm = (Boolean)InventoryHUD.getConfig().getClient().invMini.get() == false;
        InventoryGui.invMini = mm;
        InventoryHUD.getConfig().getClient().invMini.set((Object)mm);
        this.MiniModeBtn.setMessage(mm.toString());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void VerticalModeSwitch() {
        Boolean vm = (Boolean)InventoryHUD.getConfig().getClient().invVert.get() == false;
        InventoryGui.invVert = vm;
        InventoryHUD.getConfig().getClient().invVert.set((Object)vm);
        this.VerticalModeBtn.setMessage(vm.toString());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void ToggleSwitch() {
        Boolean bd = (Boolean)InventoryHUD.getConfig().getClient().byDefault.get() == false;
        InventoryHUD.isActive = bd;
        InventoryHUD.getConfig().getClient().byDefault.set((Object)bd);
        String toggle = bd != false ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.ToggleBtn.setMessage(toggle);
        InventoryHUD.getConfig().clientSpec.save();
    }
}

