/*
 * Decompiled with CFR 0.152.
 */
package coffee.injected.improvedbackpacks.registry;

import coffee.injected.improvedbackpacks.item.PocketType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcoffee/injected/improvedbackpacks/registry/IBConfig;", "", "()V", "backpackRenameLevelCost", "", "getBackpackRenameLevelCost", "()I", "backpackRenameLevelCostProp", "Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "config", "Lnet/minecraftforge/common/ForgeConfigSpec;", "defaultBackpackSize", "getDefaultBackpackSize", "defaultBackpackSizeProp", "maxEnderBackpackDurability", "getMaxEnderBackpackDurability", "maxEnderBackpackDurabilityProp", "pocketMaxCountProps", "", "slotsPerPocketProps", "getMaxPocketCount", "pocket", "Lcoffee/injected/improvedbackpacks/item/PocketType;", "getSlotsPerPocket", "register", "", "ImprovedBackpacks"})
public final class IBConfig {
    private static final ForgeConfigSpec config;
    private static final ForgeConfigSpec.IntValue defaultBackpackSizeProp;
    private static final ForgeConfigSpec.IntValue maxEnderBackpackDurabilityProp;
    private static final ForgeConfigSpec.IntValue backpackRenameLevelCostProp;
    private static final List<ForgeConfigSpec.IntValue> pocketMaxCountProps;
    private static final List<ForgeConfigSpec.IntValue> slotsPerPocketProps;
    public static final IBConfig INSTANCE;

    public final int getDefaultBackpackSize() {
        Object object = defaultBackpackSizeProp.get();
        Intrinsics.checkNotNullExpressionValue(object, "defaultBackpackSizeProp.get()");
        return ((Number)object).intValue();
    }

    public final int getMaxEnderBackpackDurability() {
        Object object = maxEnderBackpackDurabilityProp.get();
        Intrinsics.checkNotNullExpressionValue(object, "maxEnderBackpackDurabilityProp.get()");
        return ((Number)object).intValue();
    }

    public final int getBackpackRenameLevelCost() {
        Object object = backpackRenameLevelCostProp.get();
        Intrinsics.checkNotNullExpressionValue(object, "backpackRenameLevelCostProp.get()");
        return ((Number)object).intValue();
    }

    public final int getMaxPocketCount(@NotNull PocketType pocket) {
        Intrinsics.checkNotNullParameter((Object)pocket, "pocket");
        Object object = pocketMaxCountProps.get(pocket.ordinal()).get();
        Intrinsics.checkNotNullExpressionValue(object, "pocketMaxCountProps[pocket.ordinal].get()");
        return ((Number)object).intValue();
    }

    public final int getSlotsPerPocket(@NotNull PocketType pocket) {
        Intrinsics.checkNotNullParameter((Object)pocket, "pocket");
        Object object = slotsPerPocketProps.get(pocket.ordinal()).get();
        Intrinsics.checkNotNullExpressionValue(object, "slotsPerPocketProps[pocket.ordinal].get()");
        return ((Number)object).intValue();
    }

    public final void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, config);
    }

    private IBConfig() {
    }

    static {
        IBConfig iBConfig;
        INSTANCE = iBConfig = new IBConfig();
        boolean bl = false;
        pocketMaxCountProps = new ArrayList();
        bl = false;
        slotsPerPocketProps = new ArrayList();
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.IntValue intValue = builder.comment("Number of slots in new crafted backpack").defineInRange("defaultBackpackSize", 18, 1, 63);
        Intrinsics.checkNotNullExpressionValue(intValue, "builder.comment(\"Number \u2026ckData.MAX_BACKPACK_SIZE)");
        defaultBackpackSizeProp = intValue;
        ForgeConfigSpec.IntValue intValue2 = builder.comment("Durability of Ender Backpack (-1 to make it unbreakable)").defineInRange("enderBackpackDurability", 128, -1, Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue(intValue2, "builder.comment(\"Durabil\u2026, 128, -1, Int.MAX_VALUE)");
        maxEnderBackpackDurabilityProp = intValue2;
        ForgeConfigSpec.IntValue intValue3 = builder.comment("Number of levels required to rename backpack").defineInRange("backpackRenameLevelCost", 3, 0, Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue(intValue3, "builder.comment(\"Number \u2026st\", 3, 0, Int.MAX_VALUE)");
        backpackRenameLevelCostProp = intValue3;
        builder.push("pockets");
        for (PocketType type : PocketType.values()) {
            builder.push(type.getId());
            Collection collection = pocketMaxCountProps;
            ForgeConfigSpec.IntValue intValue4 = builder.comment("Max count of this pocket per one backpack").defineInRange("maxCount", type.getDefaultMaxCount(), 0, Integer.MAX_VALUE);
            boolean bl2 = false;
            collection.add(intValue4);
            collection = slotsPerPocketProps;
            intValue4 = builder.comment("Number of slots that one pocket adds to backpack").defineInRange("addSlotsCount", type.getDefaultSlotsPerPocket(), 1, Integer.MAX_VALUE);
            bl2 = false;
            collection.add(intValue4);
            builder.pop();
        }
        builder.pop();
        ForgeConfigSpec forgeConfigSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue(forgeConfigSpec, "builder.build()");
        config = forgeConfigSpec;
    }
}

