/*
 * Decompiled with CFR 0.152.
 */
package coffee.injected.improvedbackpacks.recipe;

import coffee.injected.improvedbackpacks.backpack.data.BackpackData;
import coffee.injected.improvedbackpacks.backpack.data.UpgradeData;
import coffee.injected.improvedbackpacks.item.BackpackItem;
import coffee.injected.improvedbackpacks.item.BackpackPocketItem;
import coffee.injected.improvedbackpacks.item.BackpackPocketItemKt;
import coffee.injected.improvedbackpacks.item.PocketType;
import coffee.injected.improvedbackpacks.recipe.AbstractSewingRecipe;
import coffee.injected.improvedbackpacks.recipe.SewingRecipeDescriptor;
import coffee.injected.improvedbackpacks.registry.IBCriteriaTriggers;
import coffee.injected.improvedbackpacks.registry.IBItems;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J \u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcoffee/injected/improvedbackpacks/recipe/BackpackUpgradeRecipe;", "Lcoffee/injected/improvedbackpacks/recipe/AbstractSewingRecipe;", "id", "Lnet/minecraft/util/ResourceLocation;", "pocketType", "Lcoffee/injected/improvedbackpacks/item/PocketType;", "spoolsCount", "", "(Lnet/minecraft/util/ResourceLocation;Lcoffee/injected/improvedbackpacks/item/PocketType;I)V", "getPocketType", "()Lcoffee/injected/improvedbackpacks/item/PocketType;", "getDescriptors", "", "target", "", "Lcoffee/injected/improvedbackpacks/recipe/SewingRecipeDescriptor;", "getRecipeOutput", "Lnet/minecraft/item/ItemStack;", "getResultStack", "stack1", "stack2", "getSerializer", "Lcoffee/injected/improvedbackpacks/recipe/BackpackUpgradeRecipe$Serializer;", "matches", "", "triggerCraft", "player", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "crafted", "result", "Serializer", "ImprovedBackpacks"})
public final class BackpackUpgradeRecipe
extends AbstractSewingRecipe {
    @NotNull
    private final PocketType pocketType;

    @NotNull
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)IBItems.INSTANCE.getBACKPACKS()[0]);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack1, @NotNull ItemStack stack2) {
        Object object;
        Intrinsics.checkNotNullParameter(stack1, "stack1");
        Intrinsics.checkNotNullParameter(stack2, "stack2");
        Item item = stack2.func_77973_b();
        if (!(item instanceof BackpackPocketItem)) {
            item = null;
        }
        if ((object = (BackpackPocketItem)item) == null || (object = object.getType()) == null) {
            return false;
        }
        Object pocketType = object;
        if (pocketType != this.pocketType) {
            return false;
        }
        UpgradeData upgradeData = BackpackData.Companion.extractUpgrades(stack1);
        if (upgradeData == null) {
            return false;
        }
        UpgradeData upgrades = upgradeData;
        return upgrades.get((PocketType)((Object)pocketType)) < BackpackPocketItemKt.getMaxCount((PocketType)((Object)pocketType));
    }

    @Override
    @NotNull
    public ItemStack getResultStack(@NotNull ItemStack stack1, @NotNull ItemStack stack2) {
        Intrinsics.checkNotNullParameter(stack1, "stack1");
        Intrinsics.checkNotNullParameter(stack2, "stack2");
        BackpackData backpackData = BackpackData.Companion.extract(stack1);
        if (backpackData == null) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue(itemStack, "ItemStack.EMPTY");
            return itemStack;
        }
        BackpackData data = backpackData;
        data.addPocket(this.pocketType);
        return data.createBackpackItem();
    }

    @NotNull
    public Serializer getSerializer() {
        return Serializer.INSTANCE;
    }

    @Override
    public void getDescriptors(@NotNull List<SewingRecipeDescriptor> target) {
        Intrinsics.checkNotNullParameter(target, "target");
        BackpackItem[] $this$forEach$iv = IBItems.INSTANCE.getBACKPACKS();
        boolean $i$f$forEach = false;
        BackpackItem[] backpackItemArray = $this$forEach$iv;
        int n = backpackItemArray.length;
        for (int j = 0; j < n; ++j) {
            BackpackData data;
            BackpackItem element$iv;
            BackpackItem backpackItem = element$iv = backpackItemArray[j];
            boolean bl = false;
            Intrinsics.checkNotNull(BackpackData.Companion.extract(new ItemStack((IItemProvider)backpackItem)));
            data.addPocket(this.pocketType);
            ItemStack backpack = data.createBackpackItem();
            Collection collection = target;
            int n2 = this.getSpoolsCount();
            Ingredient ingredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)backpackItem});
            Intrinsics.checkNotNullExpressionValue(ingredient, "Ingredient.fromItems(backpackItem)");
            Ingredient ingredient2 = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)this.pocketType.getItem()});
            Intrinsics.checkNotNullExpressionValue(ingredient2, "Ingredient.fromItems(pocketType.item)");
            SewingRecipeDescriptor sewingRecipeDescriptor = new SewingRecipeDescriptor(n2, ingredient, ingredient2, backpack, 0);
            boolean bl2 = false;
            collection.add(sewingRecipeDescriptor);
        }
    }

    @Override
    public void triggerCraft(@NotNull ServerPlayerEntity player, int crafted, @NotNull ItemStack result) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(result, "result");
        IBCriteriaTriggers.INSTANCE.getBACKPACK_UPGRADE().test(player, this.pocketType);
        UpgradeData upgradeData = BackpackData.Companion.extractUpgrades(result);
        if (upgradeData == null) {
            return;
        }
        UpgradeData upgrades = upgradeData;
        if (upgrades.isMaxUpgraded()) {
            IBCriteriaTriggers.INSTANCE.getBACKPACK_MAX_UPGRADE().trigger(player);
        }
    }

    @NotNull
    public final PocketType getPocketType() {
        return this.pocketType;
    }

    public BackpackUpgradeRecipe(@NotNull ResourceLocation id, @NotNull PocketType pocketType, int spoolsCount) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter((Object)pocketType, "pocketType");
        super(id, 1, 1, spoolsCount);
        this.pocketType = pocketType;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lcoffee/injected/improvedbackpacks/recipe/BackpackUpgradeRecipe$Serializer;", "Lnet/minecraftforge/registries/ForgeRegistryEntry;", "Lnet/minecraft/item/crafting/IRecipeSerializer;", "Lcoffee/injected/improvedbackpacks/recipe/BackpackUpgradeRecipe;", "()V", "read", "recipeId", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "recipe", "ImprovedBackpacks"})
    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BackpackUpgradeRecipe> {
        public static final Serializer INSTANCE;

        public void write(@NotNull PacketBuffer buffer, @NotNull BackpackUpgradeRecipe recipe) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            Intrinsics.checkNotNullParameter(recipe, "recipe");
            buffer.func_179249_a((Enum)recipe.getPocketType());
            buffer.writeInt(recipe.getSpoolsCount());
        }

        @NotNull
        public BackpackUpgradeRecipe read(@NotNull ResourceLocation recipeId, @NotNull PacketBuffer buffer) {
            Intrinsics.checkNotNullParameter(recipeId, "recipeId");
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            Enum enum_ = buffer.func_179257_a(PocketType.class);
            Intrinsics.checkNotNullExpressionValue(enum_, "buffer.readEnumValue(PocketType::class.java)");
            return new BackpackUpgradeRecipe(recipeId, (PocketType)enum_, buffer.readInt());
        }

        @NotNull
        public BackpackUpgradeRecipe read(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String rawPocketType;
            Intrinsics.checkNotNullParameter(recipeId, "recipeId");
            Intrinsics.checkNotNullParameter(json, "json");
            int spoolsCount = JSONUtils.func_151208_a((JsonObject)json, (String)"spools_count", (int)1);
            String string = rawPocketType = JSONUtils.func_151200_h((JsonObject)json, (String)"pocket_type");
            Intrinsics.checkNotNullExpressionValue(string, "rawPocketType");
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toUpperCase();
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).toUpperCase()");
            PocketType pocketType = PocketType.valueOf(string4);
            return new BackpackUpgradeRecipe(recipeId, pocketType, spoolsCount);
        }

        private Serializer() {
        }

        static {
            Serializer serializer;
            INSTANCE = serializer = new Serializer();
        }
    }
}

