/*
 * Decompiled with CFR 0.152.
 */
package coffee.injected.improvedbackpacks.client;

import coffee.injected.improvedbackpacks.ImprovedBackpacks;
import coffee.injected.improvedbackpacks.backpack.access.EquippedBackpackExtractor;
import coffee.injected.improvedbackpacks.capability.player.BackpackUserKt;
import coffee.injected.improvedbackpacks.capability.player.ClientBackpackUser;
import coffee.injected.improvedbackpacks.client.ClientBackpackManager;
import coffee.injected.improvedbackpacks.client.registry.IBKeyBindings;
import coffee.injected.improvedbackpacks.item.BackpackItem;
import coffee.injected.improvedbackpacks.network.OpenBackpackIntentPacket;
import coffee.injected.improvedbackpacks.registry.IBNetwork;
import coffee.injected.improvedbackpacks.util.AccessUtilsKt;
import coffee.injected.improvedbackpacks.util.RegistryCollection;
import java.util.Comparator;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rH\u0007J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000eJ\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0018H\u0002R(\u0010\u0003\u001a\u001c\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcoffee/injected/improvedbackpacks/client/ClientBackpackManager;", "", "()V", "equippedExtractors", "Lcoffee/injected/improvedbackpacks/util/RegistryCollection;", "Lcoffee/injected/improvedbackpacks/backpack/access/EquippedBackpackExtractor;", "kotlin.jvm.PlatformType", "Ljava/util/PriorityQueue;", "addEquippedExtractor", "", "priority", "", "slot", "Lkotlin/Function1;", "Lnet/minecraft/client/entity/player/AbstractClientPlayerEntity;", "Ljava/util/Optional;", "Lnet/minecraft/item/ItemStack;", "clientSetup", "event", "Lnet/minecraftforge/fml/event/lifecycle/FMLClientSetupEvent;", "getEquippedBackpacks", "Lkotlin/Pair;", "player", "setupEnd", "Lnet/minecraftforge/fml/event/lifecycle/FMLLoadCompleteEvent;", "Listener", "ImprovedBackpacks"})
public final class ClientBackpackManager {
    private static final RegistryCollection<EquippedBackpackExtractor, PriorityQueue<EquippedBackpackExtractor>> equippedExtractors;
    public static final ClientBackpackManager INSTANCE;

    public final void clientSetup(@NotNull FMLClientSetupEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.addEquippedExtractor(100, clientSetup.1.INSTANCE);
        event.enqueueWork((Runnable)clientSetup.2.INSTANCE);
        FMLJavaModLoadingContext fMLJavaModLoadingContext = FMLJavaModLoadingContext.get();
        Intrinsics.checkNotNullExpressionValue(fMLJavaModLoadingContext, "FMLJavaModLoadingContext.get()");
        fMLJavaModLoadingContext.getModEventBus().addListener((Consumer)clientSetup.3.INSTANCE);
    }

    private final void setupEnd(FMLLoadCompleteEvent event) {
        equippedExtractors.closeRegistry();
    }

    @Nullable
    public final Pair<ItemStack, ItemStack> getEquippedBackpacks(@NotNull AbstractClientPlayerEntity player) {
        Intrinsics.checkNotNullParameter(player, "player");
        ItemStack foundBackpack = null;
        for (EquippedBackpackExtractor extractor : equippedExtractors.getValues()) {
            ItemStack backpack;
            if (AccessUtilsKt.orNull(extractor.getEquippedBackpack(player)) == null) {
                continue;
            }
            if (foundBackpack != null) {
                return TuplesKt.to(foundBackpack, backpack);
            }
            foundBackpack = backpack;
        }
        ItemStack itemStack = foundBackpack;
        return itemStack != null ? TuplesKt.to(itemStack, null) : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void addEquippedExtractor(int priority, @NotNull Function1<? super AbstractClientPlayerEntity, Optional<ItemStack>> slot) {
        Intrinsics.checkNotNullParameter(slot, "slot");
        equippedExtractors.register(new EquippedBackpackExtractor(priority, slot));
    }

    private ClientBackpackManager() {
    }

    static {
        ClientBackpackManager clientBackpackManager;
        INSTANCE = clientBackpackManager = new ClientBackpackManager();
        equippedExtractors = new RegistryCollection(ImprovedBackpacks.Companion.rangeTo("equipped_extractors"), new PriorityQueue(Comparator.comparingInt(equippedExtractors.1.INSTANCE)));
    }

    public static final /* synthetic */ void access$setupEnd(ClientBackpackManager $this, FMLLoadCompleteEvent event) {
        $this.setupEnd(event);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcoffee/injected/improvedbackpacks/client/ClientBackpackManager$Listener;", "", "()V", "onClientTick", "", "event", "Lnet/minecraftforge/event/TickEvent$ClientTickEvent;", "onMouseClick", "Lnet/minecraftforge/client/event/InputEvent$RawMouseEvent;", "ImprovedBackpacks"})
    public static final class Listener {
        public static final Listener INSTANCE;

        @SubscribeEvent
        public final void onMouseClick(@NotNull InputEvent.RawMouseEvent event) {
            ItemStack stack;
            Intrinsics.checkNotNullParameter(event, "event");
            if (event.getButton() != 1 || event.getAction() != 1) {
                return;
            }
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (!(screen instanceof ContainerScreen)) {
                screen = null;
            }
            ContainerScreen containerScreen = (ContainerScreen)screen;
            if (containerScreen == null) {
                return;
            }
            ContainerScreen screen2 = containerScreen;
            Slot slot = screen2.getSlotUnderMouse();
            if (slot == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue(slot, "screen.slotUnderMouse ?: return");
            Slot slot2 = slot;
            IInventory iInventory = slot2.field_75224_c;
            if (!(iInventory instanceof PlayerInventory)) {
                iInventory = null;
            }
            PlayerInventory playerInventory = (PlayerInventory)iInventory;
            if (playerInventory == null) {
                return;
            }
            PlayerInventory inventory = playerInventory;
            if (Intrinsics.areEqual(inventory.field_70458_d, Minecraft.func_71410_x().field_71439_g) ^ true) {
                return;
            }
            if (slot2.getSlotIndex() >= 36) {
                return;
            }
            ItemStack itemStack = stack = slot2.func_75211_c();
            Intrinsics.checkNotNullExpressionValue(itemStack, "stack");
            if (itemStack.func_77973_b() instanceof BackpackItem) {
                event.setCanceled(true);
                IBNetwork.INSTANCE.getChannel().sendToServer((Object)new OpenBackpackIntentPacket(slot2.getSlotIndex()));
            }
        }

        @SubscribeEvent
        public final void onClientTick(@NotNull TickEvent.ClientTickEvent event) {
            Intrinsics.checkNotNullParameter(event, "event");
            Minecraft mc = Minecraft.func_71410_x();
            if (event.phase == TickEvent.Phase.END && IBKeyBindings.INSTANCE.getOPEN_BACKPACK().func_151468_f()) {
                ClientBackpackUser clientBackpackUser = BackpackUserKt.getBackpackUser(mc.field_71439_g);
                if (clientBackpackUser != null) {
                    if (!BackpackUserKt.getHasOpenedBackpack(clientBackpackUser)) {
                        IBNetwork.INSTANCE.getChannel().sendToServer((Object)new OpenBackpackIntentPacket(-1));
                    }
                }
            }
        }

        private Listener() {
        }

        static {
            Listener listener;
            INSTANCE = listener = new Listener();
        }
    }
}

