/*
 * Decompiled with CFR 0.152.
 */
package coffee.injected.improvedbackpacks.backpack.data;

import coffee.injected.improvedbackpacks.backpack.data.MetaData;
import coffee.injected.improvedbackpacks.backpack.data.UpgradeData;
import coffee.injected.improvedbackpacks.item.BackpackItem;
import coffee.injected.improvedbackpacks.item.BackpackPocketItemKt;
import coffee.injected.improvedbackpacks.item.PocketType;
import coffee.injected.improvedbackpacks.registry.IBConfig;
import coffee.injected.improvedbackpacks.registry.IBItems;
import coffee.injected.improvedbackpacks.util.AccessUtilsKt;
import coffee.injected.improvedbackpacks.util.NBTUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 A2\u00020\u0001:\u0002ABBK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u00020\u0011J\u0006\u00104\u001a\u00020\u0011J\u0016\u00105\u001a\u0002002\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u0002002\u0006\u0010#\u001a\u00020$J\u0006\u0010;\u001a\u00020<J\u0018\u0010=\u001a\u0002002\u0006\u0010>\u001a\u00020<2\u0006\u00101\u001a\u00020?H\u0002J\u0006\u0010@\u001a\u000200R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0017\"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006C"}, d2={"Lcoffee/injected/improvedbackpacks/backpack/data/BackpackData;", "", "uuid", "Ljava/util/UUID;", "color", "Lnet/minecraft/item/DyeColor;", "name", "Lnet/minecraft/util/text/ITextComponent;", "inventory", "Lnet/minecraftforge/items/ItemStackHandler;", "upgrades", "Lcoffee/injected/improvedbackpacks/backpack/data/UpgradeData;", "metadata", "Lcoffee/injected/improvedbackpacks/backpack/data/MetaData;", "lootTable", "Lnet/minecraft/util/ResourceLocation;", "sourceStack", "Lnet/minecraft/item/ItemStack;", "(Ljava/util/UUID;Lnet/minecraft/item/DyeColor;Lnet/minecraft/util/text/ITextComponent;Lnet/minecraftforge/items/ItemStackHandler;Lcoffee/injected/improvedbackpacks/backpack/data/UpgradeData;Lcoffee/injected/improvedbackpacks/backpack/data/MetaData;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/item/ItemStack;)V", "getColor", "()Lnet/minecraft/item/DyeColor;", "displayName", "getDisplayName", "()Lnet/minecraft/util/text/ITextComponent;", "getInventory", "()Lnet/minecraftforge/items/ItemStackHandler;", "getLootTable", "()Lnet/minecraft/util/ResourceLocation;", "setLootTable", "(Lnet/minecraft/util/ResourceLocation;)V", "getMetadata", "()Lcoffee/injected/improvedbackpacks/backpack/data/MetaData;", "getName", "setName", "(Lnet/minecraft/util/text/ITextComponent;)V", "size", "", "getSize", "()I", "getSourceStack", "()Lnet/minecraft/item/ItemStack;", "getUpgrades", "()Lcoffee/injected/improvedbackpacks/backpack/data/UpgradeData;", "getUuid", "()Ljava/util/UUID;", "setUuid", "(Ljava/util/UUID;)V", "addPocket", "", "type", "Lcoffee/injected/improvedbackpacks/item/PocketType;", "createBackpackItem", "createOpenedBackpackItem", "handleOpening", "world", "Lnet/minecraft/world/server/ServerWorld;", "player", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "resize", "serializeNBT", "Lnet/minecraft/nbt/CompoundNBT;", "toNBT", "nbt", "Lcoffee/injected/improvedbackpacks/backpack/data/BackpackData$SerializationType;", "updateMetadata", "Companion", "SerializationType", "ImprovedBackpacks"})
public final class BackpackData {
    @NotNull
    private UUID uuid;
    @NotNull
    private final DyeColor color;
    @Nullable
    private ITextComponent name;
    @NotNull
    private final ItemStackHandler inventory;
    @NotNull
    private final UpgradeData upgrades;
    @NotNull
    private final MetaData metadata;
    @Nullable
    private ResourceLocation lootTable;
    @Nullable
    private final ItemStack sourceStack;
    public static final int MAX_BACKPACK_SIZE = 63;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ITextComponent getDisplayName() {
        ITextComponent iTextComponent = this.name;
        if (iTextComponent == null) {
            iTextComponent = (ITextComponent)new TranslationTextComponent(IBItems.INSTANCE.getBACKPACKS()[this.color.func_196059_a()].func_77658_a());
        }
        return iTextComponent;
    }

    public final int getSize() {
        return this.inventory.getSlots();
    }

    public final void handleOpening(@NotNull ServerWorld world, @NotNull ServerPlayerEntity player) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        ResourceLocation resourceLocation = this.lootTable;
        if (resourceLocation == null) {
            return;
        }
        ResourceLocation lootTableId = resourceLocation;
        CriteriaTriggers.field_232608_N_.func_235478_a_(player, lootTableId);
        MinecraftServer minecraftServer = world.func_73046_m();
        Intrinsics.checkNotNullExpressionValue(minecraftServer, "world.server");
        LootTable lootTable = minecraftServer.func_200249_aQ().func_186521_a(lootTableId);
        Intrinsics.checkNotNullExpressionValue(lootTable, "world.server.lootTableMa\u2026FromLocation(lootTableId)");
        LootTable lootTable2 = lootTable;
        LootContext.Builder builder = new LootContext.Builder(world);
        boolean bl = false;
        boolean bl2 = false;
        LootContext.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.func_186469_a(player.func_184817_da());
        $this$apply.func_216015_a(LootParameters.field_216281_a, (Object)player);
        $this$apply.func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()));
        LootContext.Builder contextBuilder = builder;
        try {
            LootContext context = contextBuilder.func_216022_a(LootParameterSets.field_216261_b);
            lootTable2.func_216118_a((IInventory)new RecipeWrapper((IItemHandlerModifiable)this.inventory), context);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.lootTable = null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompoundNBT serializeNBT() {
        void var2_2;
        CompoundNBT nbt$iv;
        boolean $i$f$compoundNBT = false;
        CompoundNBT $this$compoundNBT = nbt$iv = new CompoundNBT();
        boolean bl = false;
        this.toNBT($this$compoundNBT, SerializationType.FULL_DATA);
        return var2_2;
    }

    private final void toNBT(CompoundNBT nbt, SerializationType type) {
        block4: {
            ItemStack it;
            boolean bl;
            boolean bl2;
            ItemStack itemStack;
            AccessUtilsKt.set(nbt, "uuid", this.uuid);
            if (this.name != null) {
                ITextComponent iTextComponent = this.name;
                Intrinsics.checkNotNull(iTextComponent);
                NBTUtilsKt.putTextComponent(nbt, "name", iTextComponent);
            }
            AccessUtilsKt.set(nbt, "upgrades", (INBT)this.upgrades.serializeNBT());
            if (type == SerializationType.FULL_DATA) {
                AccessUtilsKt.set(nbt, "color", this.color.func_196059_a());
                ItemStack itemStack2 = this.sourceStack;
                if (itemStack2 != null) {
                    itemStack = itemStack2;
                    bl2 = false;
                    bl = false;
                    it = itemStack;
                    boolean bl3 = false;
                    NBTUtilsKt.putItemStack(nbt, "source", it);
                }
            }
            if (type == SerializationType.OPENED_BACKPACK) break block4;
            CompoundNBT compoundNBT = this.inventory.serializeNBT();
            Intrinsics.checkNotNullExpressionValue(compoundNBT, "inventory.serializeNBT()");
            AccessUtilsKt.set(nbt, "inventory", (INBT)compoundNBT);
            AccessUtilsKt.set(nbt, "metadata", (INBT)this.metadata.serializeNBT());
            ResourceLocation resourceLocation = this.lootTable;
            if (resourceLocation != null) {
                itemStack = resourceLocation;
                bl2 = false;
                bl = false;
                it = itemStack;
                boolean bl4 = false;
                String string = it.toString();
                Intrinsics.checkNotNullExpressionValue(string, "it.toString()");
                AccessUtilsKt.set(nbt, "loot_table", string);
            }
        }
    }

    @NotNull
    public final ItemStack createOpenedBackpackItem() {
        CompoundNBT nbt;
        ItemStack stack = new ItemStack((IItemProvider)IBItems.INSTANCE.getOPENED_BACKPACKS()[this.color.func_196059_a()]);
        CompoundNBT compoundNBT = nbt = stack.func_190925_c("backpack_data");
        Intrinsics.checkNotNullExpressionValue(compoundNBT, "nbt");
        this.toNBT(compoundNBT, SerializationType.OPENED_BACKPACK);
        return stack;
    }

    @NotNull
    public final ItemStack createBackpackItem() {
        CompoundNBT nbt;
        ItemStack itemStack = this.sourceStack;
        if (itemStack == null || (itemStack = itemStack.func_77946_l()) == null) {
            itemStack = new ItemStack((IItemProvider)IBItems.INSTANCE.getBACKPACKS()[this.color.func_196059_a()]);
        }
        ItemStack stack = itemStack;
        CompoundNBT compoundNBT = nbt = stack.func_190925_c("backpack_data");
        Intrinsics.checkNotNullExpressionValue(compoundNBT, "nbt");
        this.toNBT(compoundNBT, SerializationType.BACKPACK);
        return stack;
    }

    public final void updateMetadata() {
        this.metadata.updateFrom((IItemHandler)this.inventory);
    }

    /*
     * WARNING - void declaration
     */
    public final void resize(int size) {
        void $this$forEachIndexed$iv;
        int n;
        void $this$mapTo$iv$iv;
        if (size < 63) {
            boolean bl = size >= this.inventory.getSlots();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "New size can not be less than previous";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        Iterable $this$map$iv = RangesKt.until(0, this.inventory.getSlots());
        boolean $i$f$map22 = false;
        Iterable bl4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ItemStack itemStack = AccessUtilsKt.get((IItemHandler)this.inventory, (int)it);
            collection.add(itemStack);
        }
        List content = (List)destination$iv$iv;
        int fixedSize = RangesKt.coerceAtMost(size, 63);
        this.inventory.setSize(fixedSize);
        Iterable $i$f$map22 = content;
        ItemStackHandler itemStackHandler = this.inventory;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void p2;
            n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ItemStack itemStack = (ItemStack)item$iv;
            int p1 = n;
            boolean bl5 = false;
            itemStackHandler.setStackInSlot(p1, (ItemStack)p2);
        }
        this.updateMetadata();
    }

    public final void addPocket(@NotNull PocketType type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int newInventorySize = this.inventory.getSlots() + BackpackPocketItemKt.getSlotsPerPocket(type);
        this.upgrades.add(type);
        this.resize(newInventorySize);
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    public final void setUuid(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter(uUID, "<set-?>");
        this.uuid = uUID;
    }

    @NotNull
    public final DyeColor getColor() {
        return this.color;
    }

    @Nullable
    public final ITextComponent getName() {
        return this.name;
    }

    public final void setName(@Nullable ITextComponent iTextComponent) {
        this.name = iTextComponent;
    }

    @NotNull
    public final ItemStackHandler getInventory() {
        return this.inventory;
    }

    @NotNull
    public final UpgradeData getUpgrades() {
        return this.upgrades;
    }

    @NotNull
    public final MetaData getMetadata() {
        return this.metadata;
    }

    @Nullable
    public final ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public final void setLootTable(@Nullable ResourceLocation resourceLocation) {
        this.lootTable = resourceLocation;
    }

    @Nullable
    public final ItemStack getSourceStack() {
        return this.sourceStack;
    }

    public BackpackData(@NotNull UUID uuid, @NotNull DyeColor color, @Nullable ITextComponent name, @NotNull ItemStackHandler inventory, @NotNull UpgradeData upgrades, @NotNull MetaData metadata, @Nullable ResourceLocation lootTable, @Nullable ItemStack sourceStack) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        Intrinsics.checkNotNullParameter(upgrades, "upgrades");
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        this.uuid = uuid;
        this.color = color;
        this.name = name;
        this.inventory = inventory;
        this.upgrades = upgrades;
        this.metadata = metadata;
        this.lootTable = lootTable;
        this.sourceStack = sourceStack;
        if (this.getSize() > 63) {
            this.resize(63);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcoffee/injected/improvedbackpacks/backpack/data/BackpackData$SerializationType;", "", "(Ljava/lang/String;I)V", "FULL_DATA", "OPENED_BACKPACK", "BACKPACK", "ImprovedBackpacks"})
    private static final class SerializationType
    extends Enum<SerializationType> {
        public static final /* enum */ SerializationType FULL_DATA;
        public static final /* enum */ SerializationType OPENED_BACKPACK;
        public static final /* enum */ SerializationType BACKPACK;
        private static final /* synthetic */ SerializationType[] $VALUES;

        static {
            SerializationType[] serializationTypeArray = new SerializationType[3];
            SerializationType[] serializationTypeArray2 = serializationTypeArray;
            serializationTypeArray[0] = FULL_DATA = new SerializationType();
            serializationTypeArray[1] = OPENED_BACKPACK = new SerializationType();
            serializationTypeArray[2] = BACKPACK = new SerializationType();
            $VALUES = serializationTypeArray;
        }

        public static SerializationType[] values() {
            return (SerializationType[])$VALUES.clone();
        }

        public static SerializationType valueOf(String string) {
            return Enum.valueOf(SerializationType.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0004J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0014\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcoffee/injected/improvedbackpacks/backpack/data/BackpackData$Companion;", "", "()V", "MAX_BACKPACK_SIZE", "", "deserializeNBT", "Lcoffee/injected/improvedbackpacks/backpack/data/BackpackData;", "nbt", "Lnet/minecraft/nbt/CompoundNBT;", "empty", "color", "Lnet/minecraft/item/DyeColor;", "size", "extract", "stack", "Lnet/minecraft/item/ItemStack;", "extractMetadata", "Lcoffee/injected/improvedbackpacks/backpack/data/MetaData;", "extractUpgrades", "Lcoffee/injected/improvedbackpacks/backpack/data/UpgradeData;", "fromNBT", "fromStack", "getOrPutUUID", "Lkotlin/Pair;", "Ljava/util/UUID;", "getUUID", "hasLootTable", "", "setName", "name", "Lnet/minecraft/util/text/ITextComponent;", "ImprovedBackpacks"})
    public static final class Companion {
        @NotNull
        public final BackpackData empty(@NotNull DyeColor color, int size) {
            Intrinsics.checkNotNullParameter(color, "color");
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue(uUID, "UUID.randomUUID()");
            return new BackpackData(uUID, color, null, new ItemStackHandler(size), new UpgradeData(0, 0, 0, 7, null), MetaData.Companion.empty(size), null, null);
        }

        public static /* synthetic */ BackpackData empty$default(Companion companion, DyeColor dyeColor, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = IBConfig.INSTANCE.getDefaultBackpackSize();
            }
            return companion.empty(dyeColor, n);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final BackpackData fromNBT(CompoundNBT nbt, ItemStack fromStack) {
            Object object;
            ITextComponent iTextComponent;
            Object object2;
            ResourceLocation lootTable;
            MetaData metadata;
            UpgradeData upgrades;
            ItemStackHandler inventory;
            Object object3;
            block18: {
                block17: {
                    Object object4;
                    Object object5;
                    Object object6;
                    block16: {
                        block15: {
                            ResourceLocation resourceLocation;
                            boolean bl;
                            Object object7 = nbt;
                            if (object7 == null || (object7 = NBTUtilsKt.getUUIDOrNull(object7, "uuid")) == null) {
                                object7 = UUID.randomUUID();
                            }
                            object3 = object7;
                            ItemStackHandler itemStackHandler = new ItemStackHandler(IBConfig.INSTANCE.getDefaultBackpackSize());
                            boolean bl2 = false;
                            boolean bl3 = false;
                            ItemStackHandler itemStackHandler2 = itemStackHandler;
                            boolean bl4 = false;
                            if (nbt != null) {
                                itemStackHandler2.deserializeNBT(nbt.func_74775_l("inventory"));
                            }
                            inventory = itemStackHandler;
                            CompoundNBT compoundNBT = nbt;
                            upgrades = UpgradeData.Companion.deserializeNBT((CompoundNBT)(compoundNBT != null ? compoundNBT.func_74775_l("upgrades") : null));
                            CompoundNBT compoundNBT2 = nbt;
                            metadata = MetaData.Companion.deserializeNBT((CompoundNBT)(compoundNBT2 != null ? compoundNBT2.func_74775_l("metadata") : null), inventory.getSlots());
                            Object object8 = nbt;
                            if (object8 != null && (object8 = NBTUtilsKt.getStringOrNull(object8, "loot_table")) != null) {
                                Object object9 = object8;
                                boolean bl5 = false;
                                bl = false;
                                Object p1 = object9;
                                boolean bl6 = false;
                                resourceLocation = new ResourceLocation((String)p1);
                            } else {
                                resourceLocation = lootTable = null;
                            }
                            if ((object6 = nbt) == null || (object6 = NBTUtilsKt.getIntOrNull(object6, "color")) == null) break block15;
                            Object object10 = object6;
                            bl = false;
                            boolean bl7 = false;
                            int p1 = ((Number)object10).intValue();
                            boolean bl8 = false;
                            object6 = DyeColor.func_196056_a((int)p1);
                            if (object6 != null) break block16;
                        }
                        ItemStack itemStack = fromStack;
                        Object object11 = itemStack != null ? itemStack.func_77973_b() : null;
                        if (!(object11 instanceof BackpackItem)) {
                            object11 = null;
                        }
                        BackpackItem backpackItem = (BackpackItem)((Object)object11);
                        object6 = object5 = backpackItem != null ? backpackItem.getColor() : null;
                    }
                    if (object6 == null) {
                        object5 = DyeColor.WHITE;
                    }
                    object2 = object5;
                    ItemStack itemStack = fromStack;
                    if (itemStack != null && itemStack.func_82837_s()) {
                        object4 = fromStack.func_200301_q();
                    } else {
                        CompoundNBT compoundNBT = nbt;
                        object4 = iTextComponent = compoundNBT != null ? NBTUtilsKt.getTextComponent(compoundNBT, "name") : null;
                    }
                    if ((object = fromStack) == null || (object = object.func_77946_l()) == null) break block17;
                    ItemStack itemStack2 = object;
                    boolean bl = false;
                    boolean bl9 = false;
                    ItemStack $this$apply = itemStack2;
                    boolean bl10 = false;
                    $this$apply.func_135074_t();
                    CompoundNBT compoundNBT = $this$apply.func_77978_p();
                    if (compoundNBT != null) {
                        compoundNBT.func_82580_o("backpack_data");
                    }
                    if ((object = itemStack2) != null) break block18;
                }
                CompoundNBT compoundNBT = nbt;
                object = compoundNBT != null ? NBTUtilsKt.getItemStack(compoundNBT, "source") : null;
            }
            ItemStack sourceStack = object;
            Object object12 = object3;
            Intrinsics.checkNotNullExpressionValue(object12, "uuid");
            return new BackpackData((UUID)object12, (DyeColor)object2, iTextComponent, inventory, upgrades, metadata, lootTable, sourceStack);
        }

        @NotNull
        public final BackpackData deserializeNBT(@NotNull CompoundNBT nbt) {
            Intrinsics.checkNotNullParameter(nbt, "nbt");
            return this.fromNBT(nbt, null);
        }

        @Nullable
        public final BackpackData extract(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter(stack, "stack");
            if (!(stack.func_77973_b() instanceof BackpackItem)) {
                return null;
            }
            CompoundNBT nbt = stack.func_179543_a("backpack_data");
            return this.fromNBT(nbt, stack);
        }

        @Nullable
        public final MetaData extractMetadata(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter(stack, "stack");
            if (!(stack.func_77973_b() instanceof BackpackItem)) {
                return null;
            }
            CompoundNBT nbt = stack.func_179543_a("backpack_data");
            CompoundNBT compoundNBT = nbt;
            int slots = compoundNBT != null && (compoundNBT = compoundNBT.func_74775_l("inventory")) != null ? compoundNBT.func_74762_e("Size") : IBConfig.INSTANCE.getDefaultBackpackSize();
            CompoundNBT compoundNBT2 = nbt;
            return MetaData.Companion.deserializeNBT((CompoundNBT)(compoundNBT2 != null ? compoundNBT2.func_74775_l("metadata") : null), slots);
        }

        @Nullable
        public final UpgradeData extractUpgrades(@NotNull ItemStack stack) {
            CompoundNBT nbt;
            Intrinsics.checkNotNullParameter(stack, "stack");
            if (!(stack.func_77973_b() instanceof BackpackItem)) {
                return null;
            }
            CompoundNBT compoundNBT = nbt = stack.func_179543_a("backpack_data");
            return UpgradeData.Companion.deserializeNBT((CompoundNBT)(compoundNBT != null ? compoundNBT.func_74775_l("upgrades") : null));
        }

        public final boolean hasLootTable(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter(stack, "stack");
            if (!(stack.func_77973_b() instanceof BackpackItem)) {
                return false;
            }
            CompoundNBT nbt = stack.func_179543_a("backpack_data");
            return nbt != null && nbt.func_74764_b("loot_table");
        }

        @Nullable
        public final UUID getUUID(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter(stack, "stack");
            if (!(stack.func_77973_b() instanceof BackpackItem)) {
                return null;
            }
            CompoundNBT compoundNBT = stack.func_179543_a("backpack_data");
            return compoundNBT != null ? NBTUtilsKt.getUUIDOrNull(compoundNBT, "uuid") : null;
        }

        @NotNull
        public final Pair<UUID, ItemStack> getOrPutUUID(@NotNull ItemStack stack) {
            Pair<UUID, ItemStack> pair;
            UUID uuid;
            Intrinsics.checkNotNullParameter(stack, "stack");
            if (!(stack.func_77973_b() instanceof BackpackItem)) {
                throw (Throwable)new IllegalArgumentException("Stack is not a backpack");
            }
            CompoundNBT compoundNBT = stack.func_179543_a("backpack_data");
            UUID uUID = uuid = compoundNBT != null ? NBTUtilsKt.getUUIDOrNull(compoundNBT, "uuid") : null;
            if (uuid == null) {
                ItemStack newStack = stack.func_77946_l();
                UUID newUuid = UUID.randomUUID();
                newStack.func_190925_c("backpack_data").func_186854_a("uuid", newUuid);
                pair = TuplesKt.to(newUuid, newStack);
            } else {
                pair = TuplesKt.to(uuid, stack);
            }
            return pair;
        }

        @NotNull
        public final ItemStack setName(@NotNull ItemStack stack, @Nullable ITextComponent name) {
            Intrinsics.checkNotNullParameter(stack, "stack");
            if (!(stack.func_77973_b() instanceof BackpackItem)) {
                throw (Throwable)new IllegalArgumentException("Stack is not a backpack");
            }
            ItemStack itemStack = stack.func_77946_l();
            boolean bl = false;
            boolean bl2 = false;
            ItemStack $this$apply = itemStack;
            boolean bl3 = false;
            CompoundNBT compoundNBT = $this$apply.func_190925_c("backpack_data");
            Intrinsics.checkNotNullExpressionValue(compoundNBT, "getOrCreateChildTag(\"backpack_data\")");
            ITextComponent iTextComponent = name;
            Intrinsics.checkNotNull(iTextComponent);
            NBTUtilsKt.putTextComponent(compoundNBT, "name", iTextComponent);
            ItemStack itemStack2 = itemStack;
            Intrinsics.checkNotNullExpressionValue(itemStack2, "stack.copy().apply {\n   \u2026e\", name!!)\n            }");
            return itemStack2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

