/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.util;

import de.cheaterpaul.fallingleaves.FallingLeavesMod;
import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import de.cheaterpaul.fallingleaves.init.FallingLeavesConfig;
import de.cheaterpaul.fallingleaves.init.Leaves;
import de.cheaterpaul.fallingleaves.util.TextureCache;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.particles.IParticleData;
import net.minecraft.resources.IResource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class LeafUtil {
    public static void trySpawnLeafParticle(BlockState state, World world, BlockPos pos, Random random, @Nullable LeafSettingsEntry leafSettings) {
        double z;
        double y;
        double x = (double)pos.func_177958_n() + random.nextDouble();
        if (LeafUtil.shouldSpawnParticle(world, pos, x, y = (double)pos.func_177956_o() - random.nextDouble() / 3.0, z = (double)pos.func_177952_p() + random.nextDouble())) {
            IModelData modelData;
            Minecraft client = Minecraft.func_71410_x();
            IBakedModel model = client.func_175602_ab().func_184389_a(state);
            List quads = model.getQuads(state, null, random, modelData = model.getModelData((IBlockDisplayReader)world, pos, state, (IModelData)EmptyModelData.INSTANCE));
            boolean shouldColor = quads.isEmpty() || quads.stream().anyMatch(BakedQuad::func_178212_b);
            int blockColor = client.func_184125_al().func_228054_a_(state, (IBlockDisplayReader)world, pos, 0);
            ResourceLocation texture = LeafUtil.spriteToTexture(client.func_209506_al().func_174954_c().getTexture(state, world, pos));
            double[] color = LeafUtil.calculateLeafColor(texture, shouldColor, blockColor, client);
            double r = color[0];
            double g = color[1];
            double b = color[2];
            world.func_195594_a((IParticleData)(leafSettings == null || !leafSettings.isConiferBlock ? Leaves.falling_leaf : Leaves.falling_leaf_conifer), x, y, z, r, g, b);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static double[] calculateLeafColor(ResourceLocation texture, boolean shouldColor, int blockColor, Minecraft client) {
        try (IResource res = client.func_195551_G().func_199002_a(texture);){
            double[] textureColor;
            String resourcePack = res.func_199026_d();
            TextureCache.Data cache = TextureCache.INST.get(texture);
            if (cache != null && resourcePack.equals(cache.resourcePack)) {
                textureColor = cache.getColor();
            } else {
                try (InputStream is = res.func_199027_b();){
                    textureColor = LeafUtil.averageColor(ImageIO.read(is));
                    TextureCache.INST.put(texture, new TextureCache.Data(textureColor, resourcePack));
                    FallingLeavesMod.LOGGER.debug("{}: Calculated texture color {} ", (Object)texture, (Object)textureColor);
                }
            }
            if (shouldColor && blockColor != -1) {
                textureColor[0] = textureColor[0] * ((double)(blockColor >> 16 & 0xFF) / 255.0);
                textureColor[1] = textureColor[1] * ((double)(blockColor >> 8 & 0xFF) / 255.0);
                textureColor[2] = textureColor[2] * ((double)(blockColor & 0xFF) / 255.0);
            }
            double[] dArray = textureColor;
            return dArray;
        }
        catch (IOException e) {
            FallingLeavesMod.LOGGER.error("Couldn't access resource {}", (Object)texture, (Object)e);
            return new double[]{1.0, 1.0, 1.0};
        }
    }

    private static boolean shouldSpawnParticle(World world, BlockPos pos, double x, double y, double z) {
        if (LeafUtil.isLeafBlock(world.func_180495_p(pos.func_177977_b()).func_177230_c(), true)) {
            return false;
        }
        double y2 = y - (double)((Integer)FallingLeavesConfig.CONFIG.minimumFreeSpaceBelow.get()).intValue() * 0.5;
        AxisAlignedBB collisionBox = new AxisAlignedBB(x - 0.1, y, z - 0.1, x + 0.1, y2, z + 0.1);
        return !world.func_226666_b_(null, collisionBox).findAny().isPresent();
    }

    public static boolean isLeafBlock(Block block, boolean useBlockTags) {
        return block instanceof LeavesBlock || useBlockTags && block.func_203417_a((ITag)BlockTags.field_206952_E);
    }

    public static double[] averageColor(BufferedImage image) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int n = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                Color c = new Color(image.getRGB(x, y), true);
                if (c.getAlpha() != 255) continue;
                r += (double)c.getRed();
                g += (double)c.getGreen();
                b += (double)c.getBlue();
                ++n;
            }
        }
        return new double[]{r / (double)n / 255.0, g / (double)n / 255.0, b / (double)n / 255.0};
    }

    public static ResourceLocation spriteToTexture(TextureAtlasSprite sprite) {
        String texture = sprite.func_195668_m().func_110623_a();
        return new ResourceLocation(sprite.func_195668_m().func_110624_b(), "textures/" + texture + ".png");
    }
}

