/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.particle;

import de.cheaterpaul.fallingleaves.init.FallingLeavesConfig;
import de.cheaterpaul.fallingleaves.util.Wind;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FallingLeafParticle
extends SpriteTexturedParticle {
    protected static final float TAU = (float)Math.PI * 2;
    protected static final int FADE_DURATION = 16;
    protected static final double WATER_FRICTION = 0.05;
    protected final float windCoefficient;
    protected final float maxRotateSpeed;
    protected final int maxRotateTime;
    protected int rotateTime = 0;

    protected FallingLeafParticle(ClientWorld clientWorld, double x, double y, double z, double r, double g, double b, IAnimatedSprite provider) {
        super(clientWorld, x, y, z, 0.0, 0.0, 0.0);
        this.func_217568_a(provider);
        this.field_70545_g = 0.08f + this.field_187136_p.nextFloat() * 0.04f;
        this.windCoefficient = 0.6f + this.field_187136_p.nextFloat() * 0.4f;
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.field_190017_n = true;
        this.field_70547_e = (Integer)FallingLeavesConfig.CONFIG.leafLifespan.get();
        this.field_70552_h = (float)r;
        this.field_70553_i = (float)g;
        this.field_70551_j = (float)b;
        this.maxRotateTime = (3 + this.field_187136_p.nextInt(5)) * 20;
        this.maxRotateSpeed = (float)(this.field_187136_p.nextBoolean() ? -1 : 1) * (0.1f + 2.4f * this.field_187136_p.nextFloat()) * ((float)Math.PI * 2) / 20.0f;
        this.field_190014_F = this.field_190015_G = this.field_187136_p.nextFloat() * ((float)Math.PI * 2);
        this.field_70544_f = (float)((Integer)FallingLeavesConfig.CONFIG.leafSize.get()).intValue() / 50.0f;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_190015_G = this.field_190014_F;
        ++this.field_70546_d;
        if (this.field_70546_d >= this.field_70547_e + 1 - 16) {
            this.field_82339_as -= 0.0625f;
        }
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
            return;
        }
        if (this.field_187122_b.func_204610_c(new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h)).func_206884_a((ITag)FluidTags.field_206959_a)) {
            this.field_187130_j = 0.0;
            this.rotateTime = 0;
            this.field_187129_i *= 0.95;
            this.field_187131_k *= 0.95;
        } else {
            this.field_187130_j -= 0.04 * (double)this.field_70545_g;
            if (!this.field_187132_l) {
                this.rotateTime = Math.min(this.rotateTime + 1, this.maxRotateTime);
                this.field_190014_F += (float)this.rotateTime / (float)this.maxRotateTime * this.maxRotateSpeed;
            } else {
                this.rotateTime = 0;
            }
            this.field_187129_i += ((double)Wind.windX - this.field_187129_i) * (double)this.windCoefficient / 60.0;
            this.field_187131_k += ((double)Wind.windZ - this.field_187131_k) * (double)this.windCoefficient / 60.0;
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite provider;

        public DefaultFactory(IAnimatedSprite provider) {
            this.provider = provider;
        }

        public Particle createParticle(BasicParticleType parameters, ClientWorld world, double x, double y, double z, double r, double g, double b) {
            return new FallingLeafParticle(world, x, y, z, r, g, b, this.provider);
        }
    }
}

