/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.mixin;

import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import de.cheaterpaul.fallingleaves.init.FallingLeavesConfig;
import de.cheaterpaul.fallingleaves.util.LeafUtil;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LeavesBlock.class})
public abstract class LeafTickMixin {
    @Inject(at={@At(value="HEAD")}, method={"animateTick(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V"})
    private void animateTick(BlockState state, World world, BlockPos pos, Random random, CallbackInfo ci) {
        LeafSettingsEntry leafSettings = FallingLeavesConfig.LEAFSETTINGS.getLeafSetting(state.func_177230_c().getRegistryName());
        if (leafSettings == null && !(state.func_177230_c() instanceof LeavesBlock)) {
            return;
        }
        if (!((Boolean)FallingLeavesConfig.CONFIG.dropFromPlayerPlacedBlocks.get()).booleanValue() && ((Boolean)state.func_177229_b((Property)LeavesBlock.field_208495_b)).booleanValue()) {
            return;
        }
        double spawnChance = 1.0;
        double modifier = ((Integer)FallingLeavesConfig.CONFIG.leafSpawnRate.get()).intValue();
        if (leafSettings != null) {
            spawnChance = leafSettings.spawnRateFactor;
            if (leafSettings.isConiferBlock) {
                modifier = ((Integer)FallingLeavesConfig.CONFIG.coniferLeafSpawnRate.get()).intValue();
            }
        }
        modifier = modifier / 10.0 / 75.0;
        spawnChance *= modifier;
        while (spawnChance > 0.0) {
            if (random.nextDouble() < spawnChance) {
                LeafUtil.trySpawnLeafParticle(state, world, pos, random, leafSettings);
            }
            spawnChance -= 1.0;
        }
    }
}

