/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.config.cloth;

import com.google.common.collect.Lists;
import fr.raksrinana.fallingtree.forge.config.AdjacentStopMode;
import fr.raksrinana.fallingtree.forge.config.BreakMode;
import fr.raksrinana.fallingtree.forge.config.CommonConfig;
import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.config.ConfigCache;
import fr.raksrinana.fallingtree.forge.config.DetectionMode;
import fr.raksrinana.fallingtree.forge.config.ToolConfiguration;
import fr.raksrinana.fallingtree.forge.config.TreeConfiguration;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.forge.api.ConfigBuilder;
import me.shedaniel.clothconfig2.forge.api.ConfigCategory;
import me.shedaniel.clothconfig2.forge.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.StringListListEntry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;

public class ClothConfigHook {
    private static final Pattern MINECRAFT_ID_PATTERN = Pattern.compile("#?[a-z0-9_.-]+:[a-z0-9/._-]+");

    public void load() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, parent) -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((ITextComponent)new StringTextComponent("FallingTree"));
            this.fillConfigScreen(builder);
            builder.setSavingRunnable(() -> ConfigCache.getInstance().invalidate());
            return builder.build();
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigScreen(ConfigBuilder builder) {
        CommonConfig config = Config.COMMON;
        BooleanListEntry reverseSneakingEntry = builder.entryBuilder().startBooleanToggle((ITextComponent)new TranslationTextComponent(this.getFieldName(null, "reverseSneaking")), config.isReverseSneaking()).setDefaultValue(false).setTooltip(this.getTooltips(null, "reverseSneaking", 2)).setSaveConsumer(config::setReverseSneaking).build();
        BooleanListEntry breakInCreativeEntry = builder.entryBuilder().startBooleanToggle((ITextComponent)new TranslationTextComponent(this.getFieldName(null, "breakInCreative")), config.isBreakInCreative()).setDefaultValue(false).setTooltip(this.getTooltips(null, "breakInCreative", 2)).setSaveConsumer(config::setBreakInCreative).build();
        ConfigCategory general = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent("text.autoconfig.fallingtree.category.default"));
        general.addEntry((AbstractConfigListEntry)reverseSneakingEntry);
        general.addEntry((AbstractConfigListEntry)breakInCreativeEntry);
        this.fillTreesConfigScreen(builder);
        this.fillToolsConfigScreen(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void fillTreesConfigScreen(ConfigBuilder builder) {
        TreeConfiguration config = Config.COMMON.getTreesConfiguration();
        EnumListEntry breakModeEntry = builder.entryBuilder().startEnumSelector((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "breakMode")), BreakMode.class, (Enum)config.getBreakMode()).setDefaultValue((Enum)BreakMode.INSTANTANEOUS).setTooltip(this.getTooltips("trees", "breakMode", 7)).setSaveConsumer(config::setBreakMode).build();
        EnumListEntry detectionModeEntry = builder.entryBuilder().startEnumSelector((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "detectionMode")), DetectionMode.class, (Enum)config.getDetectionMode()).setDefaultValue((Enum)DetectionMode.WHOLE_TREE).setTooltip(this.getTooltips("trees", "detectionMode", 9)).setSaveConsumer(config::setDetectionMode).build();
        StringListListEntry whitelistedLogsEntry = builder.entryBuilder().startStrList((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "whitelistedLogs")), config.getWhitelistedLogsStr()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "whitelistedLogs", 5)).setSaveConsumer(config::setWhitelistedLogs).setCellErrorSupplier(ClothConfigHook.getMinecraftBlockIdCellError()).build();
        StringListListEntry blacklistedLogsEntry = builder.entryBuilder().startStrList((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "blacklistedLogs")), config.getBlacklistedLogsStr()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "blacklistedLogs", 3)).setSaveConsumer(config::setBlacklistedLogs).setCellErrorSupplier(ClothConfigHook.getMinecraftBlockIdCellError()).build();
        StringListListEntry whitelistedLeavesEntry = builder.entryBuilder().startStrList((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "whitelistedLeaves")), config.getWhitelistedLeavesStr()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "whitelistedLeaves", 5)).setSaveConsumer(config::setWhitelistedLeaves).setCellErrorSupplier(ClothConfigHook.getMinecraftBlockIdCellError()).build();
        StringListListEntry whitelistedNonDecayLeavesEntry = builder.entryBuilder().startStrList((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "whitelistedNonDecayLeaves")), config.getWhitelistedNonDecayLeavesStr()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "whitelistedNonDecayLeaves", 2)).setSaveConsumer(config::setWhitelistedNonDecayLeaves).setCellErrorSupplier(ClothConfigHook.getMinecraftBlockIdCellError()).build();
        StringListListEntry blacklistedLeavesEntry = builder.entryBuilder().startStrList((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "blacklistedLeaves")), config.getBlacklistedLeavesStr()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "blacklistedLeaves", 3)).setSaveConsumer(config::setBlacklistedLeaves).setCellErrorSupplier(ClothConfigHook.getMinecraftBlockIdCellError()).build();
        IntegerListEntry maxSizeEntry = builder.entryBuilder().startIntField((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "maxSize")), config.getMaxSize()).setDefaultValue(100).setMin(1).setTooltip(this.getTooltips("trees", "maxSize", 2)).setSaveConsumer(config::setMaxSize).build();
        BooleanListEntry treeBreakingEntry = builder.entryBuilder().startBooleanToggle((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "treeBreaking")), config.isTreeBreaking()).setDefaultValue(true).setTooltip(this.getTooltips("trees", "treeBreaking", 1)).setSaveConsumer(config::setTreeBreaking).build();
        BooleanListEntry leavesBreakingEntry = builder.entryBuilder().startBooleanToggle((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "leavesBreaking")), config.isLeavesBreaking()).setDefaultValue(true).setTooltip(this.getTooltips("trees", "leavesBreaking", 2)).setSaveConsumer(config::setLeavesBreaking).build();
        IntegerListEntry leavesBreakingForceRadiusEntry = builder.entryBuilder().startIntField((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "leavesBreakingForceRadius")), config.getLeavesBreakingForceRadius()).setDefaultValue(0).setMin(0).setMax(10).setTooltip(this.getTooltips("trees", "leavesBreakingForceRadius", 8)).setSaveConsumer(config::setLeavesBreakingForceRadius).build();
        IntegerListEntry minimumLeavesAroundRequiredEntry = builder.entryBuilder().startIntField((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "minimumLeavesAroundRequired")), config.getMinimumLeavesAroundRequired()).setDefaultValue(1).setMin(0).setMax(5).setTooltip(this.getTooltips("trees", "minimumLeavesAroundRequired", 4)).setSaveConsumer(config::setMinimumLeavesAroundRequired).build();
        BooleanListEntry allowMixedLogsEntry = builder.entryBuilder().startBooleanToggle((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "allowMixedLogs")), config.isAllowMixedLogs()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "allowMixedLogs", 4)).setSaveConsumer(config::setAllowMixedLogs).build();
        BooleanListEntry breakNetherTreeWartsEntry = builder.entryBuilder().startBooleanToggle((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "breakNetherTreeWarts")), config.isBreakNetherTreeWarts()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "breakNetherTreeWarts", 2)).setSaveConsumer(config::setBreakNetherTreeWarts).build();
        IntegerListEntry searchAreaRadiusEntry = builder.entryBuilder().startIntField((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "searchAreaRadius")), config.getSearchAreaRadius()).setDefaultValue(-1).setTooltip(this.getTooltips("trees", "searchAreaRadius", 5)).setSaveConsumer(config::setSearchAreaRadius).build();
        StringListListEntry whitelistedAdjacentBlocks = builder.entryBuilder().startStrList((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "whitelistedAdjacentBlocks")), config.getWhitelistedAdjacentBlocksStr()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "whitelistedAdjacentBlocks", 9)).setSaveConsumer(config::setWhitelistedAdjacentBlocks).setCellErrorSupplier(ClothConfigHook.getMinecraftBlockIdCellError()).build();
        EnumListEntry adjacentStopModeEntry = builder.entryBuilder().startEnumSelector((ITextComponent)new TranslationTextComponent(this.getFieldName("trees", "adjacentStopMode")), AdjacentStopMode.class, (Enum)config.getAdjacentStopMode()).setDefaultValue((Enum)AdjacentStopMode.STOP_ALL).setTooltip(this.getTooltips("trees", "adjacentStopMode", 9)).setSaveConsumer(config::setAdjacentStopMode).build();
        ConfigCategory tools = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent("text.autoconfig.fallingtree.category.trees"));
        tools.addEntry((AbstractConfigListEntry)breakModeEntry);
        tools.addEntry((AbstractConfigListEntry)detectionModeEntry);
        tools.addEntry((AbstractConfigListEntry)whitelistedLogsEntry);
        tools.addEntry((AbstractConfigListEntry)blacklistedLogsEntry);
        tools.addEntry((AbstractConfigListEntry)whitelistedLeavesEntry);
        tools.addEntry((AbstractConfigListEntry)whitelistedNonDecayLeavesEntry);
        tools.addEntry((AbstractConfigListEntry)blacklistedLeavesEntry);
        tools.addEntry((AbstractConfigListEntry)maxSizeEntry);
        tools.addEntry((AbstractConfigListEntry)treeBreakingEntry);
        tools.addEntry((AbstractConfigListEntry)leavesBreakingEntry);
        tools.addEntry((AbstractConfigListEntry)leavesBreakingForceRadiusEntry);
        tools.addEntry((AbstractConfigListEntry)minimumLeavesAroundRequiredEntry);
        tools.addEntry((AbstractConfigListEntry)allowMixedLogsEntry);
        tools.addEntry((AbstractConfigListEntry)breakNetherTreeWartsEntry);
        tools.addEntry((AbstractConfigListEntry)searchAreaRadiusEntry);
        tools.addEntry((AbstractConfigListEntry)whitelistedAdjacentBlocks);
        tools.addEntry((AbstractConfigListEntry)adjacentStopModeEntry);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void fillToolsConfigScreen(ConfigBuilder builder) {
        ToolConfiguration config = Config.COMMON.getToolsConfiguration();
        BooleanListEntry ignoreToolsEntry = builder.entryBuilder().startBooleanToggle((ITextComponent)new TranslationTextComponent(this.getFieldName("tools", "ignoreTools")), config.isIgnoreTools()).setDefaultValue(false).setTooltip(this.getTooltips("tools", "ignoreTools", 4)).setSaveConsumer(config::setIgnoreTools).build();
        StringListListEntry whitelistedEntry = builder.entryBuilder().startStrList((ITextComponent)new TranslationTextComponent(this.getFieldName("tools", "whitelisted")), config.getWhitelistedStr()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("tools", "whitelisted", 3)).setSaveConsumer(config::setWhitelisted).setCellErrorSupplier(ClothConfigHook.getMinecraftItemIdCellError()).build();
        StringListListEntry blacklistedEntry = builder.entryBuilder().startStrList((ITextComponent)new TranslationTextComponent(this.getFieldName("tools", "blacklisted")), config.getBlacklistedStr()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("tools", "blacklisted", 3)).setSaveConsumer(config::setBlacklisted).setCellErrorSupplier(ClothConfigHook.getMinecraftItemIdCellError()).build();
        IntegerListEntry damageMultiplicandEntry = builder.entryBuilder().startIntField((ITextComponent)new TranslationTextComponent(this.getFieldName("tools", "damageMultiplicand")), config.getDamageMultiplicand()).setDefaultValue(1).setMin(0).setTooltip(this.getTooltips("tools", "damageMultiplicand", 7)).setSaveConsumer(config::setDamageMultiplicand).build();
        DoubleListEntry speedMultiplicandEntry = builder.entryBuilder().startDoubleField((ITextComponent)new TranslationTextComponent(this.getFieldName("tools", "speedMultiplicand")), config.getSpeedMultiplicand()).setDefaultValue(0.0).setMin(0.0).setMax(50.0).setTooltip(this.getTooltips("tools", "speedMultiplicand", 15)).setSaveConsumer(config::setSpeedMultiplicand).build();
        BooleanListEntry preserveEntry = builder.entryBuilder().startBooleanToggle((ITextComponent)new TranslationTextComponent(this.getFieldName("tools", "preserve")), config.isPreserve()).setDefaultValue(false).setTooltip(this.getTooltips("tools", "preserve", 3)).setSaveConsumer(config::setPreserve).build();
        ConfigCategory tools = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent("text.autoconfig.fallingtree.category.tools"));
        tools.addEntry((AbstractConfigListEntry)ignoreToolsEntry);
        tools.addEntry((AbstractConfigListEntry)whitelistedEntry);
        tools.addEntry((AbstractConfigListEntry)blacklistedEntry);
        tools.addEntry((AbstractConfigListEntry)damageMultiplicandEntry);
        tools.addEntry((AbstractConfigListEntry)speedMultiplicandEntry);
        tools.addEntry((AbstractConfigListEntry)preserveEntry);
    }

    private String getFieldName(String category, String fieldName) {
        if (category == null || category.isEmpty()) {
            return "text.autoconfig.fallingtree.option." + fieldName;
        }
        return "text.autoconfig.fallingtree.option." + category + "." + fieldName;
    }

    private ITextComponent[] getTooltips(String category, String fieldName, int count) {
        String tooltipKey = this.getFieldName(category, fieldName) + ".@Tooltip";
        LinkedList<String> keys = new LinkedList<String>();
        if (count <= 1) {
            keys.add(tooltipKey);
        } else {
            for (int i = 0; i < count; ++i) {
                keys.add(tooltipKey + "[" + i + "]");
            }
        }
        return (ITextComponent[])keys.stream().map(TranslationTextComponent::new).toArray(ITextComponent[]::new);
    }

    public static Function<String, Optional<ITextComponent>> getMinecraftBlockIdCellError() {
        return value -> {
            boolean valid = false;
            if (value != null) {
                valid = MINECRAFT_ID_PATTERN.matcher((CharSequence)value).matches();
            }
            if (!valid) {
                return Optional.of(new TranslationTextComponent("text.autoconfig.fallingtree.error.invalidBlockResourceLocation"));
            }
            return Optional.empty();
        };
    }

    public static Function<String, Optional<ITextComponent>> getMinecraftItemIdCellError() {
        return value -> {
            boolean valid = false;
            if (value != null) {
                valid = MINECRAFT_ID_PATTERN.matcher((CharSequence)value).matches();
            }
            if (!valid) {
                return Optional.of(new TranslationTextComponent("text.autoconfig.fallingtree.error.invalidItemResourceLocation"));
            }
            return Optional.empty();
        };
    }
}

