/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge;

import fr.raksrinana.fallingtree.forge.FallingTreeBlockBreakEvent;
import fr.raksrinana.fallingtree.forge.config.BreakMode;
import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.config.ToolConfiguration;
import fr.raksrinana.fallingtree.forge.tree.Tree;
import fr.raksrinana.fallingtree.forge.tree.breaking.ITreeBreakingHandler;
import fr.raksrinana.fallingtree.forge.tree.breaking.InstantaneousTreeBreakingHandler;
import fr.raksrinana.fallingtree.forge.tree.breaking.ShiftDownTreeBreakingHandler;
import fr.raksrinana.fallingtree.forge.tree.builder.TreeBuilder;
import fr.raksrinana.fallingtree.forge.tree.builder.TreeTooBigException;
import fr.raksrinana.fallingtree.forge.utils.CacheSpeed;
import fr.raksrinana.fallingtree.forge.utils.FallingTreeUtils;
import fr.raksrinana.fallingtree.forge.utils.LeafBreakingSchedule;
import io.netty.util.internal.ConcurrentSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fallingtree", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    private static final Set<LeafBreakingSchedule> scheduledLeavesBreaking = new ConcurrentSet();
    private static final Map<UUID, CacheSpeed> speedCache = new HashMap<UUID, CacheSpeed>();

    @SubscribeEvent
    public static void onBreakSpeed(@Nonnull PlayerEvent.BreakSpeed event) {
        CacheSpeed cacheSpeed;
        if (Config.COMMON.getTreesConfiguration().isTreeBreaking() && !event.isCanceled() && Config.COMMON.getTreesConfiguration().getBreakMode() == BreakMode.INSTANTANEOUS && ForgeEventSubscriber.isPlayerInRightState(event.getPlayer()) && Objects.nonNull(cacheSpeed = speedCache.compute(event.getPlayer().func_110124_au(), (pos, speed) -> {
            if (Objects.isNull(speed) || !speed.isValid(event.getPos())) {
                speed = ForgeEventSubscriber.getSpeed(event);
            }
            return speed;
        }))) {
            event.setNewSpeed(cacheSpeed.getSpeed());
        }
    }

    private static boolean isPlayerInRightState(PlayerEntity player) {
        if (player.func_184812_l_() && !Config.COMMON.isBreakInCreative()) {
            return false;
        }
        if (Config.COMMON.isReverseSneaking() != player.func_213453_ef()) {
            return false;
        }
        return ForgeEventSubscriber.canPlayerBreakTree(player);
    }

    private static CacheSpeed getSpeed(PlayerEvent.BreakSpeed event) {
        double speedMultiplicand = Config.COMMON.getToolsConfiguration().getSpeedMultiplicand();
        try {
            return speedMultiplicand <= 0.0 ? null : (CacheSpeed)TreeBuilder.getTree(event.getEntity().func_130014_f_(), event.getPos()).map(tree -> new CacheSpeed(event.getPos(), event.getNewSpeed() / ((float)speedMultiplicand * (float)tree.getLogCount()))).orElse(null);
        }
        catch (TreeTooBigException e) {
            return null;
        }
    }

    public static boolean canPlayerBreakTree(@Nonnull PlayerEntity player) {
        boolean isWhitelistedTool;
        ToolConfiguration toolConfiguration = Config.COMMON.getToolsConfiguration();
        Item heldItem = player.func_184586_b(Hand.MAIN_HAND).func_77973_b();
        boolean bl = isWhitelistedTool = toolConfiguration.isIgnoreTools() || heldItem instanceof AxeItem || toolConfiguration.getWhitelisted().stream().anyMatch(tool -> tool.equals(heldItem));
        if (isWhitelistedTool) {
            boolean isBlacklistedTool = toolConfiguration.getBlacklisted().stream().anyMatch(tool -> tool.equals(heldItem));
            return !isBlacklistedTool;
        }
        return false;
    }

    @SubscribeEvent
    public static void onNeighborNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        if (Config.COMMON.getTreesConfiguration().isLeavesBreaking() && !event.getWorld().func_201670_d() && event.getWorld() instanceof ServerWorld) {
            BlockPos eventPos;
            ServerWorld world = (ServerWorld)event.getWorld();
            BlockState eventState = event.getState();
            Block eventBlock = eventState.func_177230_c();
            if (eventBlock.isAir(eventState, (IBlockReader)world, eventPos = event.getPos())) {
                for (Direction facing : event.getNotifiedSides()) {
                    BlockState neighborState;
                    BlockPos neighborPos = eventPos.func_177972_a(facing);
                    if (!world.isAreaLoaded(neighborPos, 1) || !FallingTreeUtils.isLeafBlock((neighborState = event.getWorld().func_180495_p(neighborPos)).func_177230_c())) continue;
                    scheduledLeavesBreaking.add(new LeafBreakingSchedule(world, neighborPos, 4));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(@Nonnull BlockEvent.BreakEvent event) {
        if (Config.COMMON.getTreesConfiguration().isTreeBreaking() && !event.isCanceled() && !event.getWorld().func_201670_d()) {
            if (event instanceof FallingTreeBlockBreakEvent) {
                return;
            }
            if (ForgeEventSubscriber.isPlayerInRightState(event.getPlayer()) && event.getWorld() instanceof World) {
                try {
                    TreeBuilder.getTree((World)event.getWorld(), event.getPos()).ifPresent(tree -> {
                        BreakMode breakMode = Config.COMMON.getTreesConfiguration().getBreakMode();
                        ForgeEventSubscriber.getBreakingHandler(breakMode).breakTree(event, (Tree)tree);
                    });
                }
                catch (TreeTooBigException e) {
                    event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("chat.fallingtree.tree_too_big", new Object[]{Config.COMMON.getTreesConfiguration().getMaxSize()}), Util.field_240973_b_);
                }
            }
        }
    }

    public static ITreeBreakingHandler getBreakingHandler(BreakMode breakMode) {
        if (breakMode == BreakMode.INSTANTANEOUS) {
            return InstantaneousTreeBreakingHandler.getInstance();
        }
        return ShiftDownTreeBreakingHandler.getInstance();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            Iterator<LeafBreakingSchedule> leavesBreak = scheduledLeavesBreaking.iterator();
            while (leavesBreak.hasNext()) {
                LeafBreakingSchedule leafBreakingSchedule = leavesBreak.next();
                ServerWorld world = leafBreakingSchedule.getWorld();
                if (leafBreakingSchedule.getRemainingTicks() <= 0) {
                    if (world.isAreaLoaded(leafBreakingSchedule.getBlockPos(), 1)) {
                        BlockState state = world.func_180495_p(leafBreakingSchedule.getBlockPos());
                        state.func_227033_a_(world, leafBreakingSchedule.getBlockPos(), world.func_201674_k());
                        if (state.func_204519_t()) {
                            state.func_227034_b_(world, leafBreakingSchedule.getBlockPos(), world.func_201674_k());
                        }
                    }
                    leavesBreak.remove();
                    continue;
                }
                leafBreakingSchedule.tick();
            }
        }
    }
}

