/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.tree.builder.position;

import fr.raksrinana.fallingtree.fabric.tree.builder.ToAnalyzePos;
import fr.raksrinana.fallingtree.fabric.tree.builder.position.BasicPositionFetcher;
import fr.raksrinana.fallingtree.fabric.tree.builder.position.IPositionFetcher;
import fr.raksrinana.fallingtree.fabric.utils.FallingTreeUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;

public class AbovePositionFetcher
implements IPositionFetcher {
    private static AbovePositionFetcher INSTANCE;
    private final Function<class_2338, class_2338> lowerPosProvider;
    private final Supplier<IPositionFetcher> positionFetcherSupplier;
    private static AbovePositionFetcher SECOND_STEP_INSTANCE;

    private AbovePositionFetcher(Function<class_2338, class_2338> lowerPosProvider, Supplier<IPositionFetcher> positionFetcherSupplier) {
        this.lowerPosProvider = lowerPosProvider;
        this.positionFetcherSupplier = positionFetcherSupplier;
    }

    @Override
    public Collection<ToAnalyzePos> getPositions(class_1937 world, class_2338 originPos, ToAnalyzePos parent) {
        class_2338 parentPos = parent.getCheckPos();
        class_2248 parentBlock = world.method_8320(parentPos).method_26204();
        return class_2338.method_20437((class_2338)parentPos.method_10084().method_10095().method_10078(), (class_2338)this.lowerPosProvider.apply(parentPos).method_10072().method_10067()).map(checkPos -> {
            class_2248 checkBlock = world.method_8320(checkPos).method_26204();
            return new ToAnalyzePos(this.positionFetcherSupplier.get(), parentPos, parentBlock, checkPos.method_10062(), checkBlock, FallingTreeUtils.getTreePart(checkBlock), parent.getSequence() + 1);
        }).collect(Collectors.toList());
    }

    public static AbovePositionFetcher getInstance() {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new AbovePositionFetcher(class_2338::method_10084, AbovePositionFetcher::getSecondStepInstance);
        }
        return INSTANCE;
    }

    private static AbovePositionFetcher getSecondStepInstance() {
        if (Objects.isNull(SECOND_STEP_INSTANCE)) {
            SECOND_STEP_INSTANCE = new AbovePositionFetcher(Function.identity(), BasicPositionFetcher::getInstance);
        }
        return SECOND_STEP_INSTANCE;
    }
}

