/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.enhanced_mushrooms.core.registry;

import com.google.common.collect.ImmutableList;
import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.teamaurora.enhanced_mushrooms.core.registry.EMBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.Property;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enhanced_mushrooms")
public class EMFeatures {
    private static boolean isHugeRedMushroom(ConfiguredFeature<?, ?> configuredFeature) {
        if (configuredFeature.field_222737_a == Feature.field_202318_R) {
            if (configuredFeature.field_222738_b instanceof BigMushroomFeatureConfig) {
                BigMushroomFeatureConfig config = (BigMushroomFeatureConfig)configuredFeature.field_222738_b;
                return config.field_227272_a_.func_225574_a_(new Random(), new BlockPos(0, 0, 0)).func_177230_c() == Blocks.field_150419_aX;
            }
            return false;
        }
        return false;
    }

    private static boolean isHugeBrownMushroom(ConfiguredFeature<?, ?> configuredFeature) {
        if (configuredFeature.field_222737_a == Feature.field_202319_S) {
            if (configuredFeature.field_222738_b instanceof BigMushroomFeatureConfig) {
                BigMushroomFeatureConfig config = (BigMushroomFeatureConfig)configuredFeature.field_222738_b;
                return config.field_227272_a_.func_225574_a_(new Random(), new BlockPos(0, 0, 0)).func_177230_c() == Blocks.field_150420_aW;
            }
            return false;
        }
        return false;
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        List features = event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION);
        if (event.getName() != null && DataUtil.matchesKeys((ResourceLocation)event.getName(), (RegistryKey[])new RegistryKey[]{Biomes.field_76789_p, Biomes.field_76788_q, Biomes.field_150585_R, Biomes.field_185430_ab})) {
            ArrayList<Supplier> toRemove = new ArrayList<Supplier>();
            ArrayList toAdd = new ArrayList();
            for (Supplier configuredFeatureSupplier : features) {
                boolean remove;
                IFeatureConfig config = ((ConfiguredFeature)configuredFeatureSupplier.get()).field_222738_b;
                if (!(config instanceof DecoratedFeatureConfig)) continue;
                ConfiguredFeature configuredFeature = (ConfiguredFeature)((DecoratedFeatureConfig)config).field_214689_a.get();
                if (configuredFeature.field_222738_b instanceof MultipleRandomFeatureConfig) {
                    MultipleRandomFeatureConfig mrfconfig = (MultipleRandomFeatureConfig)configuredFeature.field_222738_b;
                    remove = false;
                    if (EMFeatures.isHugeRedMushroom((ConfiguredFeature)mrfconfig.field_202452_d.get())) {
                        remove = true;
                    } else if (EMFeatures.isHugeBrownMushroom((ConfiguredFeature)mrfconfig.field_202452_d.get())) {
                        remove = true;
                    }
                    for (ConfiguredRandomFeatureList crfl : mrfconfig.field_202449_a) {
                        if (EMFeatures.isHugeRedMushroom((ConfiguredFeature)crfl.field_214842_a.get())) {
                            remove = true;
                            continue;
                        }
                        if (!EMFeatures.isHugeBrownMushroom((ConfiguredFeature)crfl.field_214842_a.get())) continue;
                        remove = true;
                    }
                    if (!remove) continue;
                    toRemove.add(configuredFeatureSupplier);
                    continue;
                }
                if (!(configuredFeature.field_222738_b instanceof TwoFeatureChoiceConfig)) continue;
                TwoFeatureChoiceConfig tfcconfig = (TwoFeatureChoiceConfig)configuredFeature.field_222738_b;
                remove = false;
                if (EMFeatures.isHugeRedMushroom((ConfiguredFeature)tfcconfig.field_227285_a_.get())) {
                    remove = true;
                } else if (EMFeatures.isHugeBrownMushroom((ConfiguredFeature)tfcconfig.field_227285_a_.get())) {
                    remove = true;
                }
                if (EMFeatures.isHugeRedMushroom((ConfiguredFeature)tfcconfig.field_227286_b_.get())) {
                    remove = true;
                } else if (EMFeatures.isHugeBrownMushroom((ConfiguredFeature)tfcconfig.field_227286_b_.get())) {
                    remove = true;
                }
                if (!remove) continue;
                toRemove.add(configuredFeatureSupplier);
            }
            toRemove.forEach(features::remove);
            if (DataUtil.matchesKeys((ResourceLocation)event.getName(), (RegistryKey[])new RegistryKey[]{Biomes.field_185430_ab})) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.DARK_FOREST_VEGETATION_RED);
            } else if (DataUtil.matchesKeys((ResourceLocation)event.getName(), (RegistryKey[])new RegistryKey[]{Biomes.field_150585_R})) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.DARK_FOREST_VEGETATION_BROWN);
            } else if (DataUtil.matchesKeys((ResourceLocation)event.getName(), (RegistryKey[])new RegistryKey[]{Biomes.field_76788_q, Biomes.field_76789_p})) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.MUSHROOM_FIELD_VEGETATION);
            }
        }
    }

    public static final class Configured {
        public static final ConfiguredFeature<?, ?> HUGE_RED_MUSHROOM = Feature.field_202318_R.func_225566_b_((IFeatureConfig)Configs.RED_MUSHROOM_CONFIG);
        public static final ConfiguredFeature<?, ?> HUGE_BROWN_MUSHROOM = Feature.field_202319_S.func_225566_b_((IFeatureConfig)Configs.BROWN_MUSHROOM_CONFIG);
        public static final ConfiguredFeature<?, ?> DARK_FOREST_VEGETATION_BROWN = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)HUGE_BROWN_MUSHROOM.func_227227_a_(0.025f), (Object)HUGE_RED_MUSHROOM.func_227227_a_(0.05f), (Object)Features.field_243863_bI.func_227227_a_(0.6666667f), (Object)Features.field_243864_bJ.func_227227_a_(0.2f), (Object)Features.field_243869_bO.func_227227_a_(0.1f)), Features.field_243862_bH)).func_227228_a_(Placement.field_215008_G.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e));
        public static final ConfiguredFeature<?, ?> DARK_FOREST_VEGETATION_RED = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)HUGE_RED_MUSHROOM.func_227227_a_(0.025f), (Object)HUGE_BROWN_MUSHROOM.func_227227_a_(0.05f), (Object)Features.field_243863_bI.func_227227_a_(0.6666667f), (Object)Features.field_243864_bJ.func_227227_a_(0.2f), (Object)Features.field_243869_bO.func_227227_a_(0.1f)), Features.field_243862_bH)).func_227228_a_(Placement.field_215008_G.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e));
        public static final ConfiguredFeature<?, ?> MUSHROOM_FIELD_VEGETATION = Feature.field_202293_am.func_225566_b_((IFeatureConfig)new TwoFeatureChoiceConfig(() -> HUGE_RED_MUSHROOM, () -> HUGE_BROWN_MUSHROOM)).func_227228_a_(Features.Placements.field_244001_l);

        private static <FC extends IFeatureConfig> void register(String name, ConfiguredFeature<FC, ?> configuredFeature) {
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("enhanced_mushrooms", name), configuredFeature);
        }

        public static void registerConfiguredFeatures() {
            Configured.register("huge_red_mushroom", HUGE_RED_MUSHROOM);
            Configured.register("huge_brown_mushroom", HUGE_BROWN_MUSHROOM);
            Configured.register("dark_forest_decoration_brown", DARK_FOREST_VEGETATION_BROWN);
            Configured.register("dark_forest_decoration_red", DARK_FOREST_VEGETATION_RED);
            Configured.register("mushroom_field_vegetation", MUSHROOM_FIELD_VEGETATION);
        }
    }

    public static final class Configs {
        public static final BigMushroomFeatureConfig RED_MUSHROOM_CONFIG = new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(BlockStates.RED_MUSHROOM_CAP), (BlockStateProvider)new SimpleBlockStateProvider(BlockStates.RED_MUSHROOM_STEM), 2);
        public static final BigMushroomFeatureConfig BROWN_MUSHROOM_CONFIG = new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(BlockStates.BROWN_MUSHROOM_CAP), (BlockStateProvider)new SimpleBlockStateProvider(BlockStates.BROWN_MUSHROOM_STEM), 3);
    }

    public static final class BlockStates {
        public static final BlockState RED_MUSHROOM_STEM = ((Block)EMBlocks.RED_MUSHROOM_STEM.get()).func_176223_P();
        public static final BlockState BROWN_MUSHROOM_STEM = ((Block)EMBlocks.BROWN_MUSHROOM_STEM.get()).func_176223_P();
        public static final BlockState RED_MUSHROOM_CAP = (BlockState)Blocks.field_150419_aX.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false));
        public static final BlockState BROWN_MUSHROOM_CAP = (BlockState)((BlockState)Blocks.field_150420_aW.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false));
    }
}

