/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.csg.commands;

import com.brandon3055.csg.DataManager;
import com.brandon3055.csg.lib.PlayerSlot;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KitsCommand {
    private static Logger LOGGER = LogManager.getLogger();

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"csg_kits").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"kit-name", (ArgumentType)StringArgumentType.string()).executes(ctx -> KitsCommand.add((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"kit-name")))))).then(Commands.func_197057_a((String)"give").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"kit-name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ISuggestionProvider.func_197005_b(DataManager.kits.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> KitsCommand.give((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"kit-name"), ((CommandSource)ctx.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> KitsCommand.give((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"kit-name"), EntityArgument.func_197089_d((CommandContext)ctx, (String)"target"))))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"kit-name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ISuggestionProvider.func_197005_b(DataManager.kits.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> KitsCommand.remove((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"kit-name")))))).then(Commands.func_197057_a((String)"list").executes(KitsCommand::list)));
    }

    private static int add(CommandContext<CommandSource> ctx, String name) throws CommandSyntaxException {
        ItemStack stack;
        int i;
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        HashMap<PlayerSlot, CompoundNBT> newKit = new HashMap<PlayerSlot, CompoundNBT>();
        for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack.func_190926_b()) continue;
            newKit.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.MAIN), stack.serializeNBT());
        }
        for (i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            stack = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (stack.func_190926_b()) continue;
            newKit.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.ARMOR), stack.serializeNBT());
        }
        for (i = 0; i < player.field_71071_by.field_184439_c.size(); ++i) {
            stack = (ItemStack)player.field_71071_by.field_184439_c.get(i);
            if (stack.func_190926_b()) continue;
            newKit.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.OFF_HAND), stack.serializeNBT());
        }
        DataManager.kits.put(name, newKit);
        try {
            DataManager.saveConfig();
        }
        catch (IOException e) {
            LOGGER.error("Something when wrong while saving inventory!");
            e.printStackTrace();
            throw new CommandException((ITextComponent)new StringTextComponent(e.getMessage() + " [See console for stacktrace]"));
        }
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Your current inventory has been saved to kit " + name).func_240699_a_(TextFormatting.GREEN), false);
        return 0;
    }

    private static int give(CommandContext<CommandSource> ctx, String name, ServerPlayerEntity player) {
        if (!DataManager.kits.containsKey(name)) {
            throw new CommandException((ITextComponent)new StringTextComponent("The specified kit does not exist!"));
        }
        DataManager.givePlayerKit((PlayerEntity)player, name);
        return 0;
    }

    private static int remove(CommandContext<CommandSource> ctx, String name) {
        if (!DataManager.kits.containsKey(name)) {
            throw new CommandException((ITextComponent)new StringTextComponent("The specified kit does not exist!"));
        }
        DataManager.kits.remove(name);
        try {
            DataManager.saveConfig();
        }
        catch (IOException e) {
            LOGGER.error("Something when wrong while saving inventory!");
            e.printStackTrace();
            throw new CommandException((ITextComponent)new StringTextComponent(e.getMessage() + " [See console for stacktrace]"));
        }
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Kit removed successfully!").func_240699_a_(TextFormatting.GREEN), false);
        return 0;
    }

    private static int list(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ((CommandSource)ctx.getSource()).func_197035_h().func_145747_a((ITextComponent)new StringTextComponent("### Kits ###").func_240699_a_(TextFormatting.GOLD), Util.field_240973_b_);
        for (String name : DataManager.kits.keySet()) {
            ((CommandSource)ctx.getSource()).func_197035_h().func_145747_a((ITextComponent)new StringTextComponent(name).func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
        }
        return 0;
    }
}

