/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.csg.commands;

import com.brandon3055.csg.DataManager;
import com.brandon3055.csg.lib.PlayerSlot;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CSGCommand {
    private static Logger LOGGER = LogManager.getLogger();

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"csg_config").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197057_a((String)"set").executes(CSGCommand::set))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"give").executes(context -> CSGCommand.give((CommandContext<CommandSource>)context, (PlayerEntity)((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CSGCommand.give((CommandContext<CommandSource>)context, (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"target")))))).then(Commands.func_197057_a((String)"item_deletion_blacklist").then(Commands.func_197056_a((String)"target", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            ArrayList suggestions = new ArrayList();
            suggestions.addAll(ForgeRegistries.ITEMS.getKeys().stream().map(ResourceLocation::toString).collect(Collectors.toList()));
            suggestions.addAll(ModList.get().getMods().stream().map(ModInfo::getModId).collect(Collectors.toList()));
            return ISuggestionProvider.func_197005_b(suggestions, (SuggestionsBuilder)builder);
        }).executes(context -> CSGCommand.blackList((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"target"))))));
    }

    private static int set(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ItemStack stack;
        int i;
        DataManager.spawnInventory = new HashMap<PlayerSlot, CompoundNBT>();
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack.func_190926_b()) continue;
            DataManager.spawnInventory.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.MAIN), stack.serializeNBT());
        }
        for (i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            stack = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (stack.func_190926_b()) continue;
            DataManager.spawnInventory.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.ARMOR), stack.serializeNBT());
        }
        for (i = 0; i < player.field_71071_by.field_184439_c.size(); ++i) {
            stack = (ItemStack)player.field_71071_by.field_184439_c.get(i);
            if (stack.func_190926_b()) continue;
            DataManager.spawnInventory.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.OFF_HAND), stack.serializeNBT());
        }
        try {
            DataManager.saveConfig();
        }
        catch (IOException e) {
            LOGGER.error("Something when wrong while saving inventory!");
            e.printStackTrace();
            throw new CommandException((ITextComponent)new StringTextComponent(e.getMessage() + " [See console for stacktrace]"));
        }
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Your current inventory has been saved and will be given to players when they login for the first time!").func_240699_a_(TextFormatting.GREEN), true);
        return 0;
    }

    private static int give(CommandContext<CommandSource> ctx, PlayerEntity player) {
        DataManager.givePlayerStartGear(player);
        return 0;
    }

    private static int blackList(CommandContext<CommandSource> ctx, String target) {
        boolean isMod;
        boolean bl = isMod = !target.contains(":");
        if (DataManager.wipeBlacklist.contains(target)) {
            DataManager.wipeBlacklist.remove(target);
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Removed " + (isMod ? "Mod" : "Item") + " " + target + " from wipe black list."), true);
            try {
                DataManager.saveConfig();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new CommandException((ITextComponent)new StringTextComponent(e.getMessage()));
            }
            return 0;
        }
        if (isMod) {
            if (!ModList.get().isLoaded(target)) {
                ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Could not find mod with id " + target));
                return 1;
            }
        } else if (!ForgeRegistries.ITEMS.containsKey(new ResourceLocation(target))) {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Could not find item with id " + target));
            return 1;
        }
        DataManager.wipeBlacklist.add(target);
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Added " + (isMod ? "Mod" : "Item") + " " + target + " to wipe black list."), true);
        try {
            DataManager.saveConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandException((ITextComponent)new StringTextComponent(e.getMessage()));
        }
        return 0;
    }
}

