/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.replacement;

import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.ITargetingRule;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.Util;

public final class ExcludingManagersAndDelegatingTargetingRule
implements ITargetingRule {
    private final ITargetingRule delegate;
    private final Collection<IRecipeManager> exclusions;

    private ExcludingManagersAndDelegatingTargetingRule(ITargetingRule delegate, Collection<IRecipeManager> exclusions) {
        this.delegate = delegate;
        this.exclusions = exclusions;
    }

    public static ExcludingManagersAndDelegatingTargetingRule of(ITargetingRule delegate, Collection<IRecipeManager> exclusions) {
        Objects.requireNonNull(delegate);
        if (exclusions.isEmpty()) {
            throw new IllegalArgumentException("Unable to create an exclusion for managers without any manager to exclude");
        }
        if (delegate instanceof ExcludingManagersAndDelegatingTargetingRule) {
            ExcludingManagersAndDelegatingTargetingRule delegatingRule = (ExcludingManagersAndDelegatingTargetingRule)delegate;
            return ExcludingManagersAndDelegatingTargetingRule.of(delegatingRule.delegate, (Collection)Util.func_200696_a(new HashSet<IRecipeManager>(exclusions), it -> it.addAll(delegatingRule.exclusions)));
        }
        return new ExcludingManagersAndDelegatingTargetingRule(delegate, exclusions);
    }

    public static ExcludingManagersAndDelegatingTargetingRule of(ITargetingRule delegate, IRecipeManager ... exclusions) {
        return ExcludingManagersAndDelegatingTargetingRule.of(delegate, new HashSet<IRecipeManager>(Arrays.asList(exclusions)));
    }

    @Override
    public boolean shouldBeReplaced(IRecipe<?> recipe, IRecipeManager manager) {
        return !this.exclusions.contains(manager) && this.delegate.shouldBeReplaced(recipe, manager);
    }

    @Override
    public String describe() {
        return String.format("%s, but excluding managers {%s}", this.delegate.describe(), this.exclusions.stream().map(IRecipeManager::getCommandString).collect(Collectors.joining(", ")));
    }
}

