/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.ingredients.transform;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.transformed.IIngredientTransformer;
import com.blamejared.crafttweaker.api.item.transformed.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.impl.ingredients.transform.serializer.TransformCustomSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class TransformCustom<T extends IIngredient>
implements IIngredientTransformer<T> {
    public static final Map<String, Function<IItemStack, IItemStack>> knownTransformers = new HashMap<String, Function<IItemStack, IItemStack>>();
    private final String uid;
    private Function<IItemStack, IItemStack> function;

    public TransformCustom(String uid, Function<IItemStack, IItemStack> function) {
        this.uid = uid;
        this.function = function;
        if (function != null) {
            knownTransformers.put(uid, function);
        }
    }

    @Override
    public IItemStack transform(IItemStack stack) {
        if (this.function == null) {
            this.function = knownTransformers.get(this.uid);
        }
        if (this.function == null) {
            throw new IllegalStateException("No transformer named '" + this.uid + "' known!");
        }
        return this.function.apply(stack).copy();
    }

    @Override
    public String getCommandString(T transformedIngredient) {
        return String.format("%s.transformCustom('%s')", transformedIngredient.getCommandString(), this.uid);
    }

    @Override
    public IIngredientTransformerSerializer getSerializer() {
        return TransformCustomSerializer.INSTANCE;
    }

    public String getUid() {
        return this.uid;
    }
}

