/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.villagers;

import com.blamejared.crafttweaker.api.villagers.ITradeRemover;
import com.blamejared.crafttweaker.impl.actions.villagers.ActionTradeBase;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.merchant.villager.VillagerTrades;

public class ActionRemoveWanderingTrade
extends ActionTradeBase {
    private final ITradeRemover tradeRemover;
    private final List<VillagerTrades.ITrade> removed;

    public ActionRemoveWanderingTrade(int level, ITradeRemover tradeRemover) {
        super(level);
        this.tradeRemover = tradeRemover;
        this.removed = new ArrayList<VillagerTrades.ITrade>();
    }

    @Override
    protected Int2ObjectMap<VillagerTrades.ITrade[]> getTrades() {
        return VillagerTrades.field_221240_b;
    }

    @Override
    public void apply() {
        List<VillagerTrades.ITrade> tradeList = this.getTradeList();
        this.apply(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void apply(List<VillagerTrades.ITrade> tradeList) {
        tradeList.forEach(iTrade -> {
            if (this.tradeRemover.shouldRemove((VillagerTrades.ITrade)iTrade)) {
                this.removed.add((VillagerTrades.ITrade)iTrade);
            }
        });
        tradeList.removeAll(this.removed);
    }

    @Override
    public String describe() {
        return String.format("Removing Wandering Trader trade for Level: '%s'", this.level);
    }

    @Override
    public void undo() {
        List<VillagerTrades.ITrade> tradeList = this.getTradeList();
        this.undo(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void undo(List<VillagerTrades.ITrade> tradeList) {
        tradeList.addAll(this.removed);
    }

    @Override
    public String describeUndo() {
        return String.format("Undoing removal of Wandering Trader trade for Level: '%s'", this.level);
    }
}

