/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient;

import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker.api.ingredient.serializer.PartialNBTIngredientSerializer;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.NBTIngredient;

public class PartialNBTIngredient
extends Ingredient {
    private final ItemStack stack;

    public PartialNBTIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.SingleItemList(stack)));
        this.stack = stack;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        CompoundNBT stack1Tag = this.stack.func_77978_p();
        CompoundNBT stack2Tag = input.func_77978_p();
        if (stack1Tag == null && stack2Tag == null) {
            return true;
        }
        MapData stack2Data = (MapData)NBTConverter.convert((INBT)stack2Tag);
        MapData stack1Data = (MapData)NBTConverter.convert((INBT)stack1Tag);
        boolean contains = stack1Data == null ? true : stack2Data != null && stack2Data.contains(stack1Data);
        return this.stack.func_77973_b() == input.func_77973_b() && this.stack.func_77952_i() == input.func_77952_i() && contains;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return PartialNBTIngredientSerializer.INSTANCE;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)NBTIngredient.Serializer.INSTANCE).toString());
        json.addProperty("item", this.stack.func_77973_b().getRegistryName().toString());
        json.addProperty("count", (Number)this.stack.func_190916_E());
        if (this.stack.func_77942_o()) {
            json.addProperty("nbt", this.stack.func_77978_p().toString());
        }
        return json;
    }
}

