/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.network.client.message;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import fuzs.configmenusforge.ConfigMenusForge;
import fuzs.configmenusforge.client.util.ModConfigSync;
import fuzs.configmenusforge.client.util.ReflectionHelper;
import fuzs.configmenusforge.lib.network.message.Message;
import fuzs.configmenusforge.network.message.S2CUpdateConfigMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public class C2SSendConfigMessage
implements Message {
    private String fileName;
    private byte[] fileData;

    public C2SSendConfigMessage() {
    }

    public C2SSendConfigMessage(String fileName, byte[] fileData) {
        this.fileName = fileName;
        this.fileData = fileData;
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_180714_a(this.fileName);
        buf.func_179250_a(this.fileData);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.fileName = buf.func_218666_n();
        this.fileData = buf.func_179251_a();
    }

    public SendConfigHandler makeHandler() {
        return new SendConfigHandler();
    }

    private static class SendConfigHandler
    extends Message.PacketHandler<C2SSendConfigMessage> {
        private SendConfigHandler() {
        }

        @Override
        public void handle(C2SSendConfigMessage packet, PlayerEntity player, Object gameInstance) {
            MinecraftServer server = (MinecraftServer)gameInstance;
            if (server.func_71262_S() && player.func_211513_k(server.func_110455_j())) {
                Optional<ModConfig> optConfig = ReflectionHelper.get(ModConfigSync.FILE_MAP_FIELD, ConfigTracker.INSTANCE).map(fileMap -> (ModConfig)fileMap.get(packet.fileName));
                if (optConfig.isPresent()) {
                    ModConfig config = optConfig.get();
                    CommentedConfig receivedConfig = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(packet.fileData));
                    config.getConfigData().putAll((UnmodifiableConfig)receivedConfig);
                    ModConfigSync.fireReloadingEvent(config);
                    ConfigMenusForge.NETWORK.sendToAllExcept(new S2CUpdateConfigMessage(packet.fileName, packet.fileData), (ServerPlayerEntity)player);
                    ConfigMenusForge.LOGGER.info("Server config has been updated by {}", (Object)player.func_145748_c_().getString());
                } else {
                    ConfigMenusForge.LOGGER.error("Failed to update server config with data received from {}", (Object)player.func_145748_c_().getString());
                }
            }
        }
    }
}

