/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.client.handler;

import fuzs.configmenusforge.client.gui.screens.SelectConfigScreen;
import fuzs.configmenusforge.client.gui.util.ScreenUtil;
import fuzs.configmenusforge.client.util.ModConfigSync;
import fuzs.configmenusforge.client.util.ReflectionHelper;
import fuzs.configmenusforge.lib.core.ModLoaderEnvironment;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.forgespi.language.IModInfo;

public class ConfigScreenFactory {
    public static Optional<Function<Screen, Screen>> createConfigScreen(String modId) {
        return ConfigScreenFactory.createConfigScreen(modId, AbstractGui.field_230663_f_);
    }

    public static Optional<Function<Screen, Screen>> createConfigScreen(String modId, ResourceLocation optionsBackground) {
        return ConfigScreenFactory.createConfigScreen(modId, ModLoaderEnvironment.getModContainer(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(ScreenUtil.formatText(modId)), optionsBackground);
    }

    public static Optional<Function<Screen, Screen>> createConfigScreen(String modId, String displayName) {
        return ConfigScreenFactory.createConfigScreen(modId, displayName, AbstractGui.field_230663_f_);
    }

    public static Optional<Function<Screen, Screen>> createConfigScreen(String modId, String displayName, ResourceLocation optionsBackground) {
        Optional<Set> configs = ReflectionHelper.get(ModConfigSync.CONFIG_SETS_FIELD, ConfigTracker.INSTANCE).map(configSets -> configSets.values().stream().flatMap(Collection::stream).filter(config -> config.getModId().equals(modId)).collect(Collectors.toSet()));
        if (configs.isPresent() && !configs.get().isEmpty()) {
            return Optional.of(lastScreen -> new SelectConfigScreen((Screen)lastScreen, (ITextComponent)new StringTextComponent(displayName), optionsBackground, (Set)configs.get()));
        }
        return Optional.empty();
    }
}

