/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.client.gui.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.configmenusforge.client.gui.widget.AnimatedIconButton;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.StringUtils;

public class ScreenUtil {
    private static final ResourceLocation TINY_JUMPER_LOCATION = new ResourceLocation("configmenusforge", "textures/gui/tiny_jumper.png");
    private static final ITextComponent INFO_1_TOOLTIP = new TranslationTextComponent("configmenusforge.gui.info.1");
    private static final ITextComponent INFO_2_TOOLTIP = new TranslationTextComponent("configmenusforge.gui.info.2", new Object[]{"Config Menus for Forge"});
    private static final ITextComponent INFO_3_TOOLTIP = new TranslationTextComponent("configmenusforge.gui.info.3");

    public static ConfirmScreen makeConfirmationScreen(ITextComponent component1, ITextComponent component2, final ResourceLocation background, BooleanConsumer booleanConsumer) {
        return new ConfirmScreen(booleanConsumer, component1, component2){

            public void func_238651_a_(MatrixStack poseStack, int vOffset) {
                ScreenUtil.renderCustomBackground((Screen)this, background, vOffset);
            }
        };
    }

    public static ConfirmScreen makeConfirmationScreen(ITextComponent component1, ITextComponent component2, ITextComponent component3, ITextComponent component4, final ResourceLocation background, BooleanConsumer booleanConsumer) {
        return new ConfirmScreen(booleanConsumer, component1, component2, component3, component4){

            public void func_238651_a_(MatrixStack poseStack, int vOffset) {
                ScreenUtil.renderCustomBackground((Screen)this, background, vOffset);
            }
        };
    }

    public static AnimatedIconButton makeModPageButton(int posX, int posY, FontRenderer font, Consumer<Style> handleComponentClicked, ITooltipRenderer renderTooltip) {
        return new AnimatedIconButton(posX, posY, 20, 20, 0, 0, TINY_JUMPER_LOCATION, button -> {
            Style style = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/config-menus-forge"));
            handleComponentClicked.accept(style);
        }, (button, poseStack, mouseX, mouseY) -> {
            List tooltip = Stream.of(INFO_1_TOOLTIP, INFO_2_TOOLTIP, INFO_3_TOOLTIP).map(line -> font.func_238425_b_((ITextProperties)line, 200)).flatMap(Collection::stream).collect(Collectors.toList());
            renderTooltip.render(poseStack, tooltip, mouseX, mouseY);
        }){

            public void func_230988_a_(SoundHandler pHandler) {
                pHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187910_gj, (float)1.0f));
            }
        }.setAnimationData(4, 3);
    }

    public static void renderCustomBackground(Screen screen, ResourceLocation background, int vOffset) {
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder builder = tesselator.func_178180_c();
        screen.getMinecraft().func_110434_K().func_110577_a(background);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float size = 32.0f;
        builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        builder.func_225582_a_(0.0, (double)screen.field_230709_l_, 0.0).func_225583_a_(0.0f, (float)screen.field_230709_l_ / size + (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        builder.func_225582_a_((double)screen.field_230708_k_, (double)screen.field_230709_l_, 0.0).func_225583_a_((float)screen.field_230708_k_ / size, (float)screen.field_230709_l_ / size + (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        builder.func_225582_a_((double)screen.field_230708_k_, 0.0, 0.0).func_225583_a_((float)screen.field_230708_k_ / size, (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        builder.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(0.0f, (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        tesselator.func_78381_a();
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent(screen, new MatrixStack()));
    }

    public static ITextComponent formatLabel(String input) {
        return new StringTextComponent(ScreenUtil.formatText(input));
    }

    public static String formatText(String input) {
        int i;
        if (input == null || input.isEmpty()) {
            return "";
        }
        String[] words = input.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        input = Strings.join((String[])words, (String)" ");
        words = input.split("_");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        return Strings.join((String[])words, (String)" ").replaceAll("\\s++", " ");
    }

    public static String getTruncatedText(FontRenderer font, String component, int maxWidth) {
        if (font.func_78256_a(component) > maxWidth) {
            return font.func_238412_a_(component, maxWidth - font.func_78256_a("...")) + "...";
        }
        return component;
    }

    public static ITextProperties getTruncatedText(FontRenderer font, ITextComponent component, int maxWidth, Style style) {
        if (font.func_238414_a_((ITextProperties)component) > maxWidth) {
            return ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{font.func_238420_b_().func_238358_a_((ITextProperties)component, maxWidth - font.func_78256_a("..."), style), ITextProperties.func_240652_a_((String)"...")});
        }
        return component;
    }

    @FunctionalInterface
    public static interface ITooltipRenderer {
        public void render(MatrixStack var1, List<? extends IReorderingProcessor> var2, int var3, int var4);
    }
}

