/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.client.gui.screens;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.blaze3d.matrix.MatrixStack;
import fuzs.configmenusforge.ConfigMenusForge;
import fuzs.configmenusforge.client.gui.components.ConfigWorldSelectionList;
import fuzs.configmenusforge.client.gui.util.ScreenUtil;
import fuzs.configmenusforge.client.gui.widget.AnimatedIconButton;
import fuzs.configmenusforge.lib.core.ModLoaderEnvironment;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FileUtils;

public class SelectConfigWorldScreen
extends Screen {
    private final Screen lastScreen;
    private final ResourceLocation background;
    private final ITextComponent displayName;
    private final ModConfig config;
    private final List<WorldSummary> levelList;
    private List<IReorderingProcessor> activeTooltip;
    private TextFieldWidget searchBox;
    private ConfigWorldSelectionList list;
    private Button openButton;
    private Button createButton;
    private Button copyButton;
    private Button fileButton;
    private AnimatedIconButton tinyJumperButton;

    public SelectConfigWorldScreen(Screen lastScreen, ITextComponent displayName, ResourceLocation optionsBackground, ModConfig config, List<WorldSummary> levelList) {
        super((ITextComponent)new TranslationTextComponent("configmenusforge.gui.select.world.title", new Object[]{displayName}));
        this.lastScreen = lastScreen;
        this.displayName = displayName;
        this.background = optionsBackground;
        this.config = config;
        if (levelList.isEmpty()) {
            throw new IllegalArgumentException("level list may not be empty, solve this beforehand");
        }
        this.levelList = levelList;
    }

    public void func_231023_e_() {
        this.searchBox.func_146178_a();
        this.tinyJumperButton.func_231023_e_();
    }

    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.searchBox = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 121, 22, 242, 20, this.searchBox, StringTextComponent.field_240750_d_){

            public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                if (this.func_146176_q() && button == 1) {
                    this.func_146180_a("");
                }
                return super.func_231044_a_(mouseX, mouseY, button);
            }
        };
        this.searchBox.func_212954_a(query -> this.list.refreshList((String)query));
        this.func_230481_d_((IGuiEventListener)this.searchBox);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240632_c_, button -> this.func_231175_as__()));
        this.openButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 154, this.field_230709_l_ - 52, 150, 20, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.select.edit"), button1 -> {
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.func_230958_g_();
            if (selected != null) {
                selected.openConfig();
            }
        }));
        this.createButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 154, this.field_230709_l_ - 52, 150, 20, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.select.world.create"), button1 -> {
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.func_230958_g_();
            if (selected != null) {
                selected.openConfig();
            }
        }));
        this.copyButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4, this.field_230709_l_ - 52, 150, 20, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.select.copy"), button -> {
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.func_230958_g_();
            if (selected != null) {
                selected.loadModConfig(this.config);
                Path destination = ModLoaderEnvironment.getGameDir().resolve(FMLConfig.defaultConfigPath()).resolve(this.config.getFileName());
                this.field_230706_i_.func_147108_a((Screen)ScreenUtil.makeConfirmationScreen((ITextComponent)new TranslationTextComponent("configmenusforge.gui.message.copy.title"), (ITextComponent)(Files.exists(destination, new LinkOption[0]) ? new TranslationTextComponent("configmenusforge.gui.message.copy.warning").func_240699_a_(TextFormatting.RED) : new TranslationTextComponent("configmenusforge.gui.message.copy.description")), this.background, result -> {
                    if (result) {
                        try {
                            if (!Files.exists(destination, new LinkOption[0])) {
                                FileUtils.getOrCreateDirectory((Path)destination.getParent(), (String)String.format("%s default config", this.config.getFileName()));
                                Files.createFile(destination, new FileAttribute[0]);
                            }
                            TomlFormat.instance().createWriter().write((UnmodifiableConfig)this.config.getConfigData(), destination, WritingMode.REPLACE);
                            ConfigMenusForge.LOGGER.info("Successfully copied {} to default config folder", (Object)this.config.getFileName());
                        }
                        catch (Exception e) {
                            ConfigMenusForge.LOGGER.error("Failed to copy {} to default config folder", (Object)this.config.getFileName(), (Object)e);
                        }
                    }
                    this.field_230706_i_.func_147108_a((Screen)this);
                }));
            }
        }));
        this.fileButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 154, this.field_230709_l_ - 28, 150, 20, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.select.open"), button -> {
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.func_230958_g_();
            if (selected != null) {
                selected.loadModConfig(this.config);
                Style style = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, this.config.getFullPath().toAbsolutePath().toString()));
                this.func_230455_a_(style);
            }
        }));
        this.updateButtonStatus(false);
        this.list = new ConfigWorldSelectionList(this, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, 50, this.field_230709_l_ - 60, 36, this.searchBox.func_146179_b(), this.levelList);
        this.func_230481_d_((IGuiEventListener)this.list);
        this.tinyJumperButton = (AnimatedIconButton)this.func_230480_a_((Widget)ScreenUtil.makeModPageButton(this.field_230708_k_ / 2 + 126, 22, this.field_230712_o_, arg_0 -> ((SelectConfigWorldScreen)this).func_230455_a_(arg_0), (arg_0, arg_1, arg_2, arg_3) -> ((SelectConfigWorldScreen)this).func_238654_b_(arg_0, arg_1, arg_2, arg_3)));
        this.func_212928_a((IGuiEventListener)this.searchBox);
    }

    public boolean func_231046_a_(int i, int j, int k) {
        return super.func_231046_a_(i, j, k) || this.searchBox.func_231046_a_(i, j, k);
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.lastScreen);
    }

    public boolean func_231042_a_(char pCodePoint, int pModifiers) {
        return this.searchBox.func_231042_a_(pCodePoint, pModifiers);
    }

    public void func_230430_a_(MatrixStack pMatrixStack, int pMouseX, int pMouseY, float pPartialTicks) {
        this.activeTooltip = null;
        this.list.func_230430_a_(pMatrixStack, pMouseX, pMouseY, pPartialTicks);
        this.searchBox.func_230430_a_(pMatrixStack, pMouseX, pMouseY, pPartialTicks);
        SelectConfigWorldScreen.func_238472_a_((MatrixStack)pMatrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)8, (int)0xFFFFFF);
        super.func_230430_a_(pMatrixStack, pMouseX, pMouseY, pPartialTicks);
        if (this.activeTooltip != null) {
            this.func_238654_b_(pMatrixStack, this.activeTooltip, pMouseX, pMouseY);
        }
    }

    public void setActiveTooltip(List<IReorderingProcessor> list) {
        this.activeTooltip = list;
    }

    public void updateButtonStatus(boolean active) {
        if (this.list != null && active) {
            boolean fileExists;
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.func_230958_g_();
            this.openButton.field_230694_p_ = fileExists = selected.fileExists();
            this.createButton.field_230694_p_ = !fileExists;
            this.openButton.field_230693_o_ = true;
            this.fileButton.field_230693_o_ = fileExists;
            this.copyButton.field_230693_o_ = fileExists;
        } else {
            this.openButton.field_230694_p_ = true;
            this.openButton.field_230693_o_ = false;
            this.createButton.field_230694_p_ = false;
            this.fileButton.field_230693_o_ = false;
            this.copyButton.field_230693_o_ = false;
        }
    }

    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    public ResourceLocation getBackground() {
        return this.background;
    }

    public ModConfig getConfig() {
        return this.config;
    }

    public void func_231164_f_() {
        if (this.list != null) {
            this.list.func_231039_at__().forEach(ConfigWorldSelectionList.ConfigWorldListEntry::close);
        }
    }
}

