/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.client.gui.components;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.configmenusforge.ConfigMenusForge;
import fuzs.configmenusforge.client.gui.components.CustomBackgroundObjectSelectionList;
import fuzs.configmenusforge.client.gui.data.IEntryData;
import fuzs.configmenusforge.client.gui.screens.ConfigScreen;
import fuzs.configmenusforge.client.gui.screens.SelectConfigWorldScreen;
import fuzs.configmenusforge.client.util.ModConfigSync;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ConfigWorldSelectionList
extends CustomBackgroundObjectSelectionList<ConfigWorldListEntry> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    private static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/world_selection.png");
    private static final ITextComponent FROM_NEWER_TOOLTIP_1 = new TranslationTextComponent("selectWorld.tooltip.fromNewerVersion1").func_240699_a_(TextFormatting.RED);
    private static final ITextComponent FROM_NEWER_TOOLTIP_2 = new TranslationTextComponent("selectWorld.tooltip.fromNewerVersion2").func_240699_a_(TextFormatting.RED);
    private static final ITextComponent SNAPSHOT_TOOLTIP_1 = new TranslationTextComponent("selectWorld.tooltip.snapshot1").func_240699_a_(TextFormatting.GOLD);
    private static final ITextComponent SNAPSHOT_TOOLTIP_2 = new TranslationTextComponent("selectWorld.tooltip.snapshot2").func_240699_a_(TextFormatting.GOLD);
    private static final ITextComponent WORLD_LOCKED_TOOLTIP = new TranslationTextComponent("selectWorld.locked").func_240699_a_(TextFormatting.RED);
    private static final ITextComponent WORLD_PRE_WORLDHEIGHT_TOOLTIP = new TranslationTextComponent("selectWorld.pre_worldheight").func_240699_a_(TextFormatting.RED);
    private static final String SERVER_CONFIG_NAME = "serverconfig";
    private static final Marker CONFIG = MarkerManager.getMarker((String)"CONFIG");
    private final SelectConfigWorldScreen screen;
    private final List<WorldSummary> levelList;
    private final ITextComponent createConfigTooltip;

    public ConfigWorldSelectionList(SelectConfigWorldScreen selectConfigWorldScreen, Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight, String query, List<WorldSummary> levelList) {
        super(minecraft, selectConfigWorldScreen.getBackground(), width, height, y0, y1, itemHeight);
        this.screen = selectConfigWorldScreen;
        this.levelList = levelList;
        this.createConfigTooltip = new TranslationTextComponent("configmenusforge.gui.select.create_config", new Object[]{selectConfigWorldScreen.getDisplayName()}).func_240699_a_(TextFormatting.GOLD);
        this.refreshList(query);
    }

    public void refreshList(String query) {
        this.func_230963_j_();
        String s = query.toLowerCase(Locale.ROOT);
        for (WorldSummary levelsummary : this.levelList) {
            if (!levelsummary.func_75788_b().toLowerCase(Locale.ROOT).contains(s) && !levelsummary.func_75786_a().toLowerCase(Locale.ROOT).contains(s)) continue;
            this.func_230513_b_((AbstractList.AbstractListEntry)new ConfigWorldListEntry(this.screen, this.field_230668_b_, levelsummary));
        }
    }

    protected int func_230952_d_() {
        return this.field_230670_d_ / 2 + 144;
    }

    public int func_230949_c_() {
        return 260;
    }

    protected boolean func_230971_aw__() {
        return this.screen.func_241217_q_() == this;
    }

    public void setSelected(@Nullable ConfigWorldListEntry configWorldListEntry) {
        super.func_241215_a_((AbstractList.AbstractListEntry)configWorldListEntry);
        this.screen.updateButtonStatus(configWorldListEntry != null && !configWorldListEntry.summary.func_237315_o_());
    }

    protected void func_241219_a_(AbstractList.Ordering pOrdering) {
        this.func_241572_a_(pOrdering, configWorldListEntry -> !configWorldListEntry.summary.func_237315_o_());
    }

    public final class ConfigWorldListEntry
    extends ExtendedList.AbstractListEntry<ConfigWorldListEntry>
    implements AutoCloseable {
        private final SelectConfigWorldScreen screen;
        private final Minecraft minecraft;
        final WorldSummary summary;
        private final ResourceLocation iconLocation;
        private File iconFile;
        @Nullable
        private final DynamicTexture icon;
        private long lastClickTime;

        public ConfigWorldListEntry(SelectConfigWorldScreen selectConfigWorldScreen, Minecraft minecraft, WorldSummary levelSummary) {
            this.screen = selectConfigWorldScreen;
            this.summary = levelSummary;
            this.minecraft = minecraft;
            String s = levelSummary.func_75786_a();
            this.iconLocation = new ResourceLocation("minecraft", "worlds/" + Util.func_244361_a((String)s, ResourceLocation::func_240909_b_) + "/" + Hashing.sha1().hashUnencodedChars((CharSequence)s) + "/icon");
            this.iconFile = levelSummary.func_237312_c_();
            if (!this.iconFile.isFile()) {
                this.iconFile = null;
            }
            this.icon = this.loadServerIcon();
        }

        public void func_230432_a_(MatrixStack pMatrixStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean hovered, float pPartialTicks) {
            String s = this.summary.func_75788_b();
            String s1 = this.summary.func_75786_a() + " (" + DATE_FORMAT.format(new Date(this.summary.func_75784_e())) + ")";
            if (StringUtils.isEmpty((CharSequence)s)) {
                s = I18n.func_135052_a((String)"selectWorld.world", (Object[])new Object[0]) + " " + (pIndex + 1);
            }
            ITextComponent component = this.summary.func_237316_p_();
            this.minecraft.field_71466_p.func_238421_b_(pMatrixStack, s, (float)(pLeft + 32 + 3), (float)(pTop + 1), 0xFFFFFF);
            this.minecraft.field_71466_p.func_238421_b_(pMatrixStack, s1, (float)(pLeft + 32 + 3), (float)(pTop + 9 + 3), 0x808080);
            this.minecraft.field_71466_p.func_243248_b(pMatrixStack, component, (float)(pLeft + 32 + 3), (float)(pTop + 9 + 9 + 3), 0x808080);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(this.icon != null ? this.iconLocation : ICON_MISSING);
            RenderSystem.enableBlend();
            AbstractGui.func_238463_a_((MatrixStack)pMatrixStack, (int)pLeft, (int)pTop, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderSystem.disableBlend();
            if (this.minecraft.field_71474_y.field_85185_A || hovered) {
                int textureY;
                this.minecraft.func_110434_K().func_110577_a(ICON_OVERLAY_LOCATION);
                AbstractGui.func_238467_a_((MatrixStack)pMatrixStack, (int)pLeft, (int)pTop, (int)(pLeft + 32), (int)(pTop + 32), (int)-1601138544);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean leftHovered = pMouseX - pLeft < 32;
                int n = textureY = leftHovered ? 32 : 0;
                if (this.summary.func_237315_o_()) {
                    AbstractGui.func_238463_a_((MatrixStack)pMatrixStack, (int)pLeft, (int)pTop, (float)96.0f, (float)textureY, (int)32, (int)32, (int)256, (int)256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.field_71466_p.func_238425_b_((ITextProperties)WORLD_LOCKED_TOOLTIP, 175));
                    }
                } else if (this.summary.func_186355_l()) {
                    AbstractGui.func_238463_a_((MatrixStack)pMatrixStack, (int)pLeft, (int)pTop, (float)32.0f, (float)textureY, (int)32, (int)32, (int)256, (int)256);
                    if (this.summary.func_186356_m()) {
                        AbstractGui.func_238463_a_((MatrixStack)pMatrixStack, (int)pLeft, (int)pTop, (float)96.0f, (float)textureY, (int)32, (int)32, (int)256, (int)256);
                        if (leftHovered) {
                            this.screen.setActiveTooltip((List<IReorderingProcessor>)ImmutableList.of((Object)FROM_NEWER_TOOLTIP_1.func_241878_f(), (Object)FROM_NEWER_TOOLTIP_2.func_241878_f()));
                        }
                    } else if (!SharedConstants.func_215069_a().isStable()) {
                        AbstractGui.func_238463_a_((MatrixStack)pMatrixStack, (int)pLeft, (int)pTop, (float)64.0f, (float)textureY, (int)32, (int)32, (int)256, (int)256);
                        if (leftHovered) {
                            this.screen.setActiveTooltip((List<IReorderingProcessor>)ImmutableList.of((Object)SNAPSHOT_TOOLTIP_1.func_241878_f(), (Object)SNAPSHOT_TOOLTIP_2.func_241878_f()));
                        }
                    }
                } else if (!this.fileExists()) {
                    AbstractGui.func_238463_a_((MatrixStack)pMatrixStack, (int)pLeft, (int)pTop, (float)32.0f, (float)textureY, (int)32, (int)32, (int)256, (int)256);
                    AbstractGui.func_238463_a_((MatrixStack)pMatrixStack, (int)pLeft, (int)pTop, (float)64.0f, (float)textureY, (int)32, (int)32, (int)256, (int)256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.field_71466_p.func_238425_b_((ITextProperties)ConfigWorldSelectionList.this.createConfigTooltip, 200));
                    }
                } else {
                    AbstractGui.func_238463_a_((MatrixStack)pMatrixStack, (int)pLeft, (int)pTop, (float)0.0f, (float)textureY, (int)32, (int)32, (int)256, (int)256);
                }
            }
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.summary.func_237315_o_()) {
                return true;
            }
            ConfigWorldSelectionList.this.setSelected(this);
            this.screen.updateButtonStatus(ConfigWorldSelectionList.this.func_230958_g_() != null);
            if (mouseX - (double)ConfigWorldSelectionList.this.func_230968_n_() <= 32.0) {
                this.openConfig();
                return true;
            }
            if (Util.func_211177_b() - this.lastClickTime < 250L) {
                this.openConfig();
                return true;
            }
            this.lastClickTime = Util.func_211177_b();
            return false;
        }

        public void openConfig() {
            this.loadModConfig(this.screen.getConfig());
            ConfigScreen configScreen = ConfigScreen.create(this.screen, this.screen.getDisplayName(), this.screen.getBackground(), this.screen.getConfig(), IEntryData.makeValueToDataMap(this.screen.getConfig()));
            this.minecraft.func_147108_a((Screen)configScreen);
        }

        public void loadModConfig(ModConfig config) {
            this.loadModConfig(config, this.getConfigBasePath());
        }

        private void loadModConfig(ModConfig config, Path configBasePath) {
            ConfigMenusForge.LOGGER.trace(CONFIG, "Loading config file type {} at {} for {}", (Object)config.getType(), (Object)config.getFileName(), (Object)config.getModId());
            FileUtils.getOrCreateDirectory((Path)configBasePath, (String)ConfigWorldSelectionList.SERVER_CONFIG_NAME);
            CommentedFileConfig configData = (CommentedFileConfig)config.getHandler().reader(configBasePath).apply(config);
            ModConfigSync.setConfigData(config, (CommentedConfig)configData);
            config.save();
        }

        private Path getConfigBasePath() {
            return this.minecraft.func_71359_d().func_215781_c().resolve(this.summary.func_75786_a()).resolve(ConfigWorldSelectionList.SERVER_CONFIG_NAME);
        }

        public boolean fileExists() {
            return Files.exists(this.getConfigBasePath().resolve(this.screen.getConfig().getFileName()), new LinkOption[0]);
        }

        @Nullable
        private DynamicTexture loadServerIcon() {
            boolean flag;
            boolean bl = flag = this.iconFile != null && this.iconFile.isFile();
            if (flag) {
                try {
                    DynamicTexture dynamictexture1;
                    try (FileInputStream inputstream = new FileInputStream(this.iconFile);){
                        NativeImage nativeimage = NativeImage.func_195713_a((InputStream)inputstream);
                        Validate.validState((nativeimage.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                        Validate.validState((nativeimage.func_195714_b() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                        DynamicTexture dynamictexture = new DynamicTexture(nativeimage);
                        this.minecraft.func_110434_K().func_229263_a_(this.iconLocation, (Texture)dynamictexture);
                        dynamictexture1 = dynamictexture;
                    }
                    return dynamictexture1;
                }
                catch (Throwable throwable2) {
                    ConfigMenusForge.LOGGER.error("Invalid icon for world {}", (Object)this.summary.func_75786_a(), (Object)throwable2);
                    this.iconFile = null;
                    return null;
                }
            }
            this.minecraft.func_110434_K().func_147645_c(this.iconLocation);
            return null;
        }

        @Override
        public void close() {
            if (this.icon != null) {
                this.icon.close();
            }
        }
    }
}

