/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.structures;

import L_Ender.cataclysm.entity.Netherite_Monstrosity_Entity;
import L_Ender.cataclysm.init.ModEntities;
import L_Ender.cataclysm.init.ModStructures;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SoulBlackSmithPieces {
    private static final ResourceLocation UPPER_SIDE = new ResourceLocation("cataclysm", "soulblacksmith2");
    private static final ResourceLocation BOTTOM_SIDE = new ResourceLocation("cataclysm", "soulblacksmith");
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.of((Object)UPPER_SIDE, (Object)new BlockPos(0, 1, 0), (Object)BOTTOM_SIDE, (Object)new BlockPos(0, 1, 0));

    public static void start(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, Random random) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        BlockPos rotationOffSet = new BlockPos(0, 0, 0).func_190942_a(rotation);
        BlockPos blockpos = rotationOffSet.func_177982_a(x, pos.func_177956_o(), z);
        pieceList.add((StructurePiece)new Piece(templateManager, UPPER_SIDE, blockpos, rotation));
        rotationOffSet = new BlockPos(0, 0, -34).func_190942_a(rotation);
        blockpos = rotationOffSet.func_177982_a(x, pos.func_177956_o(), z);
        pieceList.add((StructurePiece)new Piece(templateManager, BOTTOM_SIDE, blockpos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation resourceLocation;
        private Rotation rotation;

        public Piece(TemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn) {
            super(ModStructures.SBSP, 0);
            this.resourceLocation = resourceLocationIn;
            BlockPos blockpos = (BlockPos)OFFSET.get(this.resourceLocation);
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            this.rotation = rotationIn;
            this.setupPiece(templateManagerIn);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(ModStructures.SBSP, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.setupPiece(templateManagerIn);
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("monstrosity".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                Netherite_Monstrosity_Entity monstrosity = (Netherite_Monstrosity_Entity)((EntityType)ModEntities.NETHERITE_MONSTROSITY.get()).func_200721_a((World)worldIn.func_201672_e());
                monstrosity.func_174828_a(pos, 180.0f, 180.0f);
                worldIn.func_217376_c((Entity)monstrosity);
            }
        }
    }
}

