/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.structures;

import L_Ender.cataclysm.init.ModEntities;
import L_Ender.cataclysm.structures.RuinedCitadelPieces;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class RuinedCitadelStructure
extends Structure<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_MONSTERS = ImmutableList.of((Object)new MobSpawnInfo.Spawners((EntityType)ModEntities.ENDERMAPTERA.get(), 3, 1, 1));

    public RuinedCitadelStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return STRUCTURE_MONSTERS;
    }

    protected boolean func_230363_a_(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom random, int x, int z, Biome biome, ChunkPos chunkPos, NoFeatureConfig config) {
        int i = x >> 4;
        int j = z >> 4;
        random.setSeed((long)(i ^ j << 4) ^ seed);
        random.nextInt();
        return !this.isEndCityWithin(generator, seed, random, x, z, 10);
    }

    private boolean isEndCityWithin(ChunkGenerator generator, long seed, SharedSeedRandom random, int x, int z, int radius) {
        StructureSeparationSettings structureseparationsettings = generator.func_235957_b_().func_236197_a_(Structure.field_236379_o_);
        if (structureseparationsettings != null) {
            for (int surroundingX = x - radius; surroundingX <= x + radius; ++surroundingX) {
                for (int surroundingZ = z - radius; surroundingZ <= z + radius; ++surroundingZ) {
                    ChunkPos chunkpos = Structure.field_236379_o_.func_236392_a_(structureseparationsettings, seed, random, surroundingX, surroundingZ);
                    if (surroundingX != chunkpos.field_77276_a || surroundingZ != chunkpos.field_77275_b) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistryManager, ChunkGenerator generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            int surfaceY = generator.func_222531_c(x, z, Heightmap.Type.WORLD_SURFACE_WG);
            if (surfaceY < 48) {
                return;
            }
            BlockPos blockpos = new BlockPos(x, surfaceY + 5, z);
            RuinedCitadelPieces.start(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }
    }
}

