/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.entity.etc;

import L_Ender.cataclysm.entity.etc.CMPathFinder;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class CMPathNavigateGround
extends GroundPathNavigator {
    static final float EPSILON = 1.0E-8f;

    public CMPathNavigateGround(MobEntity entity, World world) {
        super(entity, world);
    }

    protected PathFinder func_179679_a(int maxVisitedNodes) {
        this.field_179695_a = new WalkNodeProcessor();
        this.field_179695_a.func_186317_a(true);
        return new CMPathFinder(this.field_179695_a, maxVisitedNodes);
    }

    protected void func_75508_h() {
        Path path = Objects.requireNonNull(this.field_75514_c);
        Vector3d entityPos = this.func_75502_i();
        int pathLength = path.func_75874_d();
        for (int i = path.func_75873_e(); i < path.func_75874_d(); ++i) {
            if ((double)path.func_75877_a((int)i).field_75837_b == Math.floor(entityPos.field_72448_b)) continue;
            pathLength = i;
            break;
        }
        Vector3d base = entityPos.func_72441_c((double)(-this.field_75515_a.func_213311_cf() * 0.5f), 0.0, (double)(-this.field_75515_a.func_213311_cf() * 0.5f));
        Vector3d max = base.func_72441_c((double)this.field_75515_a.func_213311_cf(), (double)this.field_75515_a.func_213302_cg(), (double)this.field_75515_a.func_213311_cf());
        if (this.tryShortcut(path, new Vector3d(this.field_75515_a.func_226277_ct_(), this.field_75515_a.func_226278_cu_(), this.field_75515_a.func_226281_cx_()), pathLength, base, max) && (this.isAt(path, 0.5f) || this.atElevationChange(path) && this.isAt(path, this.field_75515_a.func_213311_cf() * 0.5f))) {
            path.func_75872_c(path.func_75873_e() + 1);
        }
        this.func_179677_a(entityPos);
    }

    private boolean isAt(Path path, float threshold) {
        Vector3d pathPos = path.func_75878_a((Entity)this.field_75515_a);
        return MathHelper.func_76135_e((float)((float)(this.field_75515_a.func_226277_ct_() - pathPos.field_72450_a))) < threshold && MathHelper.func_76135_e((float)((float)(this.field_75515_a.func_226281_cx_() - pathPos.field_72449_c))) < threshold && Math.abs(this.field_75515_a.func_226278_cu_() - pathPos.field_72448_b) < 1.0;
    }

    private boolean atElevationChange(Path path) {
        int curr = path.func_75873_e();
        int end = Math.min(path.func_75874_d(), curr + MathHelper.func_76123_f((float)(this.field_75515_a.func_213311_cf() * 0.5f)) + 1);
        int currY = path.func_75877_a((int)curr).field_75837_b;
        for (int i = curr + 1; i < end; ++i) {
            if (path.func_75877_a((int)i).field_75837_b == currY) continue;
            return true;
        }
        return false;
    }

    private boolean tryShortcut(Path path, Vector3d entityPos, int pathLength, Vector3d base, Vector3d max) {
        int i = pathLength;
        while (--i > path.func_75873_e()) {
            Vector3d vec = path.func_75881_a((Entity)this.field_75515_a, i).func_178788_d(entityPos);
            if (!this.sweep(vec, base, max)) continue;
            path.func_75872_c(i);
            return false;
        }
        return true;
    }

    protected boolean func_75493_a(Vector3d start, Vector3d end, int sizeX, int sizeY, int sizeZ) {
        return true;
    }

    private boolean sweep(Vector3d vec, Vector3d base, Vector3d max) {
        float t = 0.0f;
        float max_t = (float)vec.func_72433_c();
        if (max_t < 1.0E-8f) {
            return true;
        }
        float[] tr = new float[3];
        int[] ldi = new int[3];
        int[] tri = new int[3];
        int[] step = new int[3];
        float[] tDelta = new float[3];
        float[] tNext = new float[3];
        float[] normed = new float[3];
        for (int i = 0; i < 3; ++i) {
            float value = CMPathNavigateGround.element(vec, i);
            boolean dir = value >= 0.0f;
            step[i] = dir ? 1 : -1;
            float lead = CMPathNavigateGround.element(dir ? max : base, i);
            tr[i] = CMPathNavigateGround.element(dir ? base : max, i);
            ldi[i] = CMPathNavigateGround.leadEdgeToInt(lead, step[i]);
            tri[i] = CMPathNavigateGround.trailEdgeToInt(tr[i], step[i]);
            normed[i] = value / max_t;
            tDelta[i] = MathHelper.func_76135_e((float)(max_t / value));
            float dist = dir ? (float)(ldi[i] + 1) - lead : lead - (float)ldi[i];
            tNext[i] = tDelta[i] < Float.POSITIVE_INFINITY ? tDelta[i] * dist : Float.POSITIVE_INFINITY;
        }
        return true;
    }

    protected boolean func_230287_a_(PathNodeType nodeType) {
        if (nodeType == PathNodeType.WATER) {
            return false;
        }
        if (nodeType == PathNodeType.LAVA) {
            return false;
        }
        return nodeType != PathNodeType.OPEN;
    }

    static int leadEdgeToInt(float coord, int step) {
        return MathHelper.func_76141_d((float)(coord - (float)step * 1.0E-8f));
    }

    static int trailEdgeToInt(float coord, int step) {
        return MathHelper.func_76141_d((float)(coord + (float)step * 1.0E-8f));
    }

    static float element(Vector3d v, int i) {
        switch (i) {
            case 0: {
                return (float)v.field_72450_a;
            }
            case 1: {
                return (float)v.field_72448_b;
            }
            case 2: {
                return (float)v.field_72449_c;
            }
        }
        return 0.0f;
    }
}

