/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.entity;

import L_Ender.cataclysm.config.CMConfig;
import L_Ender.cataclysm.entity.AI.CmAttackGoal;
import L_Ender.cataclysm.entity.AI.SimpleAnimationGoal;
import L_Ender.cataclysm.entity.Boss_monster;
import L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import L_Ender.cataclysm.entity.etc.CMPathNavigateGround;
import L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import L_Ender.cataclysm.init.ModEffect;
import L_Ender.cataclysm.init.ModSounds;
import L_Ender.cataclysm.init.ModTag;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.event.ForgeEventFactory;

public class Ignis_Entity
extends Boss_monster {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.YELLOW, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    public static final Animation SWING_ATTACK = Animation.create((int)65);
    public static final Animation SWING_ATTACK_SOUL = Animation.create((int)56);
    public static final Animation HORIZONTAL_SWING_ATTACK = Animation.create((int)68);
    public static final Animation HORIZONTAL_SWING_ATTACK_SOUL = Animation.create((int)58);
    public static final Animation SHIELD_SMASH_ATTACK = Animation.create((int)70);
    public static final Animation PHASE_2 = Animation.create((int)68);
    public static final Animation POKE_ATTACK = Animation.create((int)65);
    public static final Animation POKE_ATTACK2 = Animation.create((int)56);
    public static final Animation POKE_ATTACK3 = Animation.create((int)50);
    public static final Animation POKED_ATTACK = Animation.create((int)65);
    public static final Animation PHASE_3 = Animation.create((int)120);
    public static final Animation MAGIC_ATTACK = Animation.create((int)95);
    public static final Animation SMASH_IN_AIR = Animation.create((int)105);
    public static final Animation SMASH = Animation.create((int)47);
    public static final Animation BODY_CHECK_ATTACK1 = Animation.create((int)62);
    public static final Animation BODY_CHECK_ATTACK2 = Animation.create((int)62);
    public static final Animation BODY_CHECK_ATTACK3 = Animation.create((int)62);
    public static final Animation BODY_CHECK_ATTACK4 = Animation.create((int)62);
    public static final Animation BODY_CHECK_ATTACK_SOUL1 = Animation.create((int)45);
    public static final Animation BODY_CHECK_ATTACK_SOUL2 = Animation.create((int)45);
    public static final Animation BODY_CHECK_ATTACK_SOUL3 = Animation.create((int)45);
    public static final Animation BODY_CHECK_ATTACK_SOUL4 = Animation.create((int)45);
    public static final Animation IGNIS_DEATH = Animation.create((int)124);
    public static final Animation BURNS_THE_EARTH = Animation.create((int)67);
    public static final Animation COUNTER = Animation.create((int)115);
    public static final Animation STRIKE = Animation.create((int)47);
    public static final Animation TRIPLE_ATTACK = Animation.create((int)139);
    public static final Animation FOUR_COMBO = Animation.create((int)141);
    public static final Animation BREAK_THE_SHIELD = Animation.create((int)87);
    public static final int BODY_CHECK_COOLDOWN = 200;
    private static final DataParameter<Boolean> IS_BLOCKING = EntityDataManager.func_187226_a(Ignis_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SHIELD_BREAK = EntityDataManager.func_187226_a(Ignis_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SHIELD = EntityDataManager.func_187226_a(Ignis_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SHIELD_DURABILITY = EntityDataManager.func_187226_a(Ignis_Entity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SHOW_SHIELD = EntityDataManager.func_187226_a(Ignis_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SWORD = EntityDataManager.func_187226_a(Ignis_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOSS_PHASE = EntityDataManager.func_187226_a(Ignis_Entity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private Vector3d prevBladePos = new Vector3d(0.0, 0.0, 0.0);
    private int body_check_cooldown = 0;
    private int timeWithoutTarget;
    public float blockingProgress;
    public float swordProgress;
    public float prevblockingProgress;
    public float prevswordProgress;

    public Ignis_Entity(EntityType entity, World world) {
        super(entity, world);
        this.field_70138_W = 2.5f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.UNPASSABLE_RAIL, 0.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        if (world.field_72995_K) {
            this.socketPosArray = new Vector3d[]{new Vector3d(0.0, 0.0, 0.0)};
        }
        Ignis_Entity.setConfigattribute((LivingEntity)this, CMConfig.IgnisHealthMultiplier, CMConfig.IgnisDamageMultiplier);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, SWING_ATTACK, SWING_ATTACK_SOUL, HORIZONTAL_SWING_ATTACK, HORIZONTAL_SWING_ATTACK_SOUL, POKE_ATTACK, POKE_ATTACK2, POKE_ATTACK3, POKED_ATTACK, MAGIC_ATTACK, PHASE_3, SHIELD_SMASH_ATTACK, PHASE_2, BODY_CHECK_ATTACK4, BODY_CHECK_ATTACK3, BODY_CHECK_ATTACK2, BODY_CHECK_ATTACK1, BODY_CHECK_ATTACK_SOUL1, BODY_CHECK_ATTACK_SOUL2, BODY_CHECK_ATTACK_SOUL3, BODY_CHECK_ATTACK_SOUL4, SMASH, COUNTER, STRIKE, SMASH_IN_AIR, BURNS_THE_EARTH, TRIPLE_ATTACK, BREAK_THE_SHIELD, FOUR_COMBO, IGNIS_DEATH};
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(2, (Goal)new CmAttackGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new Hornzontal_SwingGoal(this, HORIZONTAL_SWING_ATTACK, 31, 51, 23, 36));
        this.field_70714_bg.func_75776_a(1, (Goal)new Hornzontal_SwingGoal(this, HORIZONTAL_SWING_ATTACK_SOUL, 27, 47, 19, 31));
        this.field_70714_bg.func_75776_a(1, (Goal)new PokeGoal(this, POKE_ATTACK, 39, 59, 34, 42, 34, 40));
        this.field_70714_bg.func_75776_a(1, (Goal)new PokeGoal(this, POKE_ATTACK2, 33, 53, 28, 36, 28, 34));
        this.field_70714_bg.func_75776_a(1, (Goal)new PokeGoal(this, POKE_ATTACK3, 29, 49, 24, 33, 24, 30));
        this.field_70714_bg.func_75776_a(1, (Goal)new Phase_Transition(this, PHASE_2));
        this.field_70714_bg.func_75776_a(1, (Goal)new Phase_Transition2(this, PHASE_3));
        this.field_70714_bg.func_75776_a(1, (Goal)new Shield_Smash(this, SHIELD_SMASH_ATTACK));
        this.field_70714_bg.func_75776_a(1, (Goal)new Body_Check(this, BODY_CHECK_ATTACK1, 25, 20, 0.25f, 0.25f));
        this.field_70714_bg.func_75776_a(1, (Goal)new Body_Check(this, BODY_CHECK_ATTACK2, 25, 20, 0.25f, 0.25f));
        this.field_70714_bg.func_75776_a(1, (Goal)new Body_Check(this, BODY_CHECK_ATTACK3, 25, 20, 0.25f, 0.25f));
        this.field_70714_bg.func_75776_a(1, (Goal)new Body_Check(this, BODY_CHECK_ATTACK4, 25, 20, 0.25f, 0.25f));
        this.field_70714_bg.func_75776_a(1, (Goal)new Body_Check(this, BODY_CHECK_ATTACK_SOUL1, 21, 16, 0.4f, 0.4f));
        this.field_70714_bg.func_75776_a(1, (Goal)new Body_Check(this, BODY_CHECK_ATTACK_SOUL2, 21, 16, 0.4f, 0.4f));
        this.field_70714_bg.func_75776_a(1, (Goal)new Body_Check(this, BODY_CHECK_ATTACK_SOUL3, 21, 16, 0.4f, 0.4f));
        this.field_70714_bg.func_75776_a(1, (Goal)new Body_Check(this, BODY_CHECK_ATTACK_SOUL4, 21, 16, 0.4f, 0.4f));
        this.field_70714_bg.func_75776_a(1, (Goal)new Poked(this, POKED_ATTACK));
        this.field_70714_bg.func_75776_a(1, (Goal)new Air_Smash(this, SMASH_IN_AIR));
        this.field_70714_bg.func_75776_a(1, new SimpleAnimationGoal<Ignis_Entity>(this, SMASH));
        this.field_70714_bg.func_75776_a(1, (Goal)new Ignis_Attack_Goal(this, SWING_ATTACK, 34));
        this.field_70714_bg.func_75776_a(1, (Goal)new Ignis_Attack_Goal(this, SWING_ATTACK_SOUL, 28));
        this.field_70714_bg.func_75776_a(1, (Goal)new Ignis_Attack_Goal(this, COUNTER, 105));
        this.field_70714_bg.func_75776_a(1, (Goal)new Ignis_Attack_Goal(this, STRIKE, 34));
        this.field_70714_bg.func_75776_a(1, (Goal)new Triple_Attack(this, TRIPLE_ATTACK));
        this.field_70714_bg.func_75776_a(1, (Goal)new Four_Combo(this, FOUR_COMBO));
        this.field_70714_bg.func_75776_a(1, (Goal)new Break_the_Shield(this, BREAK_THE_SHIELD));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        double range = this.calculateRange(source);
        if (range > CMConfig.IgnisLongRangelimit * CMConfig.IgnisLongRangelimit) {
            return false;
        }
        if (!source.func_76357_e()) {
            damage = Math.min((float)CMConfig.IgnisDamageCap, damage);
        }
        if (this.getBossPhase() == 0 && (double)this.func_110143_aJ() <= (double)this.func_110138_aP() * 0.5 && !source.func_76357_e()) {
            damage = (float)((double)damage * 0.25);
        }
        if (!(this.getAnimation() != PHASE_3 && this.getAnimation() != PHASE_2 || source.func_76357_e())) {
            return false;
        }
        Entity entity = source.func_76364_f();
        if (damage > 0.0f && this.canBlockDamageSource(source)) {
            this.func_184590_k(damage);
            if (!source.func_76352_a() && entity instanceof LivingEntity) {
                this.func_190629_c((LivingEntity)entity);
            }
            this.func_184185_a(SoundEvents.field_187603_D, 0.5f, 0.4f + this.func_70681_au().nextFloat() * 0.1f);
            return false;
        }
        Crackiness ignis$crackiness = this.getCrackiness();
        if (this.getBossPhase() > 0 && super.func_70097_a(source, damage) && this.getCrackiness() != ignis$crackiness) {
            this.func_184185_a((SoundEvent)ModSounds.IGNIS_ARMOR_BREAK.get(), 1.0f, 0.8f);
        }
        return super.func_70097_a(source, damage);
    }

    private boolean canBlockDamageSource(DamageSource damageSourceIn) {
        Vector3d vector3d2;
        AbstractArrowEntity abstractarrowentity;
        Entity entity = damageSourceIn.func_76364_f();
        boolean flag = false;
        if (entity instanceof AbstractArrowEntity && (abstractarrowentity = (AbstractArrowEntity)entity).func_213874_s() > 0) {
            flag = true;
        }
        if (!damageSourceIn.func_76363_c() && !flag && this.getIsShield() && (vector3d2 = damageSourceIn.func_188404_v()) != null) {
            Vector3d vector3d = this.func_70676_i(1.0f);
            Vector3d vector3d1 = vector3d2.func_72444_a(this.func_213303_ch()).func_72432_b();
            vector3d1 = new Vector3d(vector3d1.field_72450_a, 0.0, vector3d1.field_72449_c);
            return vector3d1.func_72430_b(vector3d) < 0.0;
        }
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_BLOCKING, (Object)false);
        this.field_70180_af.func_187214_a(IS_SHIELD, (Object)false);
        this.field_70180_af.func_187214_a(BOSS_PHASE, (Object)0);
        this.field_70180_af.func_187214_a(IS_SHIELD_BREAK, (Object)false);
        this.field_70180_af.func_187214_a(IS_SWORD, (Object)false);
        this.field_70180_af.func_187214_a(SHOW_SHIELD, (Object)true);
        this.field_70180_af.func_187214_a(SHIELD_DURABILITY, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("BossPhase", this.getBossPhase());
        compound.func_74757_a("Is_Shield_Break", this.getIsShieldBreak());
        compound.func_74768_a("Shield_Durability", this.getShieldDurability());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setBossPhase(compound.func_74762_e("BossPhase"));
        this.setIsShieldBreak(compound.func_74767_n("Is_Shield_Break"));
        this.setShieldDurability(compound.func_74762_e("Shield_Durability"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void setIsBlocking(boolean isBlocking) {
        this.func_184212_Q().func_187227_b(IS_BLOCKING, (Object)isBlocking);
    }

    public boolean getIsBlocking() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_BLOCKING);
    }

    public void setIsShield(boolean isShield) {
        this.func_184212_Q().func_187227_b(IS_SHIELD, (Object)isShield);
    }

    public boolean getIsShield() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_SHIELD);
    }

    public void setIsSword(boolean isSword) {
        this.func_184212_Q().func_187227_b(IS_SWORD, (Object)isSword);
    }

    public boolean getIsSword() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_SWORD);
    }

    public void setIsShieldBreak(boolean isShieldBreak) {
        this.func_184212_Q().func_187227_b(IS_SHIELD_BREAK, (Object)isShieldBreak);
    }

    public boolean getIsShieldBreak() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_SHIELD_BREAK);
    }

    public void setShieldDurability(int ShieldDurability) {
        this.func_184212_Q().func_187227_b(SHIELD_DURABILITY, (Object)ShieldDurability);
    }

    public int getShieldDurability() {
        return (Integer)this.func_184212_Q().func_187225_a(SHIELD_DURABILITY);
    }

    public void setShowShield(boolean showShield) {
        this.func_184212_Q().func_187227_b(SHOW_SHIELD, (Object)showShield);
    }

    public boolean getShowShield() {
        return (Boolean)this.func_184212_Q().func_187225_a(SHOW_SHIELD);
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void setBossPhase(int bossPhase) {
        this.func_184212_Q().func_187227_b(BOSS_PHASE, (Object)bossPhase);
    }

    public int getBossPhase() {
        return (Integer)this.func_184212_Q().func_187225_a(BOSS_PHASE);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 50.0).func_233815_a_(Attributes.field_233821_d_, (double)0.33f).func_233815_a_(Attributes.field_233823_f_, 14.0).func_233815_a_(Attributes.field_233818_a_, 333.0).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSounds.IGNIS_AMBIENT.get();
    }

    private static Animation getRandomPoke(Random rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return POKE_ATTACK;
            }
            case 1: {
                return POKE_ATTACK2;
            }
            case 2: {
                return POKE_ATTACK3;
            }
        }
        return POKE_ATTACK;
    }

    public void func_70071_h_() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0 && this.getAnimation() == NO_ANIMATION && !this.getIsBlocking() && !this.getIsSword()) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        this.prevblockingProgress = this.blockingProgress;
        this.prevswordProgress = this.swordProgress;
        if (this.getIsBlocking() && this.blockingProgress < 10.0f) {
            this.blockingProgress += 1.0f;
        }
        if (!this.getIsBlocking() && this.blockingProgress > 0.0f) {
            this.blockingProgress -= 1.0f;
        }
        if (this.getIsSword() && this.swordProgress < 10.0f) {
            this.swordProgress += 1.0f;
        }
        if (!this.getIsSword() && this.swordProgress > 0.0f) {
            this.swordProgress -= 1.0f;
        }
        if (!this.func_184188_bt().isEmpty() && ((Entity)this.func_184188_bt().get(0)).func_225608_bj_()) {
            ((Entity)this.func_184188_bt().get(0)).func_226284_e_(false);
        }
        LivingEntity target = this.func_70638_az();
        this.spawnSwipeParticles();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(24) == 0 && !this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + 0.5, SoundEvents.field_187597_B, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
        } else {
            ++this.timeWithoutTarget;
            if (target != null) {
                this.timeWithoutTarget = 0;
                if (this.getIsShieldBreak()) {
                    if (!this.getIsSword()) {
                        this.setIsSword(true);
                    }
                    if (this.getIsBlocking()) {
                        this.setIsBlocking(false);
                    }
                } else {
                    if (!this.getIsBlocking()) {
                        this.setIsBlocking(true);
                    }
                    if (this.getIsSword()) {
                        this.setIsSword(false);
                    }
                }
            }
            if (this.getAnimation() == NO_ANIMATION && this.timeWithoutTarget > 150 && (this.getIsBlocking() || this.getIsSword()) && target == null) {
                this.timeWithoutTarget = 0;
                this.setIsSword(false);
                this.setIsBlocking(false);
            }
            if (this.getIsShieldBreak()) {
                if (this.getIsBlocking()) {
                    this.setIsBlocking(false);
                    this.setIsSword(true);
                }
                this.setShieldDurability(3);
                this.setShowShield(false);
            }
            if (this.getBossPhase() > 0) {
                this.bossInfo.func_186745_a(BossInfo.Color.BLUE);
            }
            if (this.getBossPhase() > 1) {
                this.bossInfo.func_186741_a(true);
                if (this.getAnimation() != PHASE_3) {
                    this.setIsShieldBreak(true);
                }
            }
            if (this.getIsBlocking() && this.blockingProgress == 10.0f) {
                if (this.getAnimation() == NO_ANIMATION) {
                    this.setIsShield(true);
                }
                if (this.getAnimation() == COUNTER) {
                    this.setIsShield(true);
                } else if (this.getAnimation() == POKED_ATTACK) {
                    this.setIsShield(false);
                } else if (this.getAnimation() == BREAK_THE_SHIELD) {
                    this.setIsShield(false);
                } else if (this.getAnimation() == HORIZONTAL_SWING_ATTACK) {
                    this.setIsShield(this.getAnimationTick() > 31);
                } else if (this.getAnimation() == HORIZONTAL_SWING_ATTACK_SOUL) {
                    this.setIsShield(this.getAnimationTick() > 27);
                } else if (this.getAnimation() == BODY_CHECK_ATTACK1 || this.getAnimation() == BODY_CHECK_ATTACK2 || this.getAnimation() == BODY_CHECK_ATTACK3 || this.getAnimation() == BODY_CHECK_ATTACK4) {
                    this.setIsShield(this.getAnimationTick() < 25);
                } else if (this.getAnimation() == BODY_CHECK_ATTACK_SOUL1 || this.getAnimation() == BODY_CHECK_ATTACK_SOUL2 || this.getAnimation() == BODY_CHECK_ATTACK_SOUL3 || this.getAnimation() == BODY_CHECK_ATTACK_SOUL4) {
                    this.setIsShield(this.getAnimationTick() < 21);
                } else if (this.getAnimation() == POKE_ATTACK) {
                    this.setIsShield(this.getAnimationTick() < 39);
                } else if (this.getAnimation() == POKE_ATTACK2) {
                    this.setIsShield(this.getAnimationTick() < 34);
                } else if (this.getAnimation() == POKE_ATTACK3) {
                    this.setIsShield(this.getAnimationTick() < 29);
                } else if (this.getAnimation() == SWING_ATTACK) {
                    this.setIsShield(this.getAnimationTick() < 34);
                } else if (this.getAnimation() == SWING_ATTACK_SOUL) {
                    this.setIsShield(this.getAnimationTick() < 28);
                }
            } else {
                this.setIsShield(false);
            }
        }
        if (this.body_check_cooldown > 0) {
            --this.body_check_cooldown;
        }
        this.repelEntities(1.7f, 4.0f, 1.7f, 1.7f);
        this.field_70177_z = this.field_70761_aq;
        if (this.func_70089_S()) {
            if (!this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.getShieldDurability() > 2 && !this.getIsShieldBreak()) {
                this.setAnimation(BREAK_THE_SHIELD);
            } else if (!this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && this.getBossPhase() < 1) {
                this.setAnimation(PHASE_2);
            } else if (target != null && target.func_70089_S()) {
                if ((this.blockingProgress == 10.0f || this.swordProgress == 10.0f) && !this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.func_70068_e((Entity)target) >= 64.0 && this.func_70068_e((Entity)target) <= 1024.0 && target.func_233570_aj_() && this.func_70681_au().nextFloat() * 100.0f < 0.9f) {
                    this.setAnimation(SMASH_IN_AIR);
                } else if ((this.blockingProgress == 10.0f || this.swordProgress == 10.0f) && !this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.func_70032_d((Entity)target) < 7.0f && this.func_70681_au().nextFloat() * 100.0f < 6.0f) {
                    Animation animation = Ignis_Entity.getRandomPoke(this.field_70146_Z);
                    this.setAnimation(animation);
                } else if ((this.blockingProgress == 10.0f || this.swordProgress == 10.0f) && !this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.func_70032_d((Entity)target) < 5.0f && this.func_70681_au().nextFloat() * 100.0f < 12.0f) {
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        Animation animation2 = this.getBossPhase() > 0 ? HORIZONTAL_SWING_ATTACK_SOUL : HORIZONTAL_SWING_ATTACK;
                        this.setAnimation(animation2);
                    } else {
                        Animation animation3 = this.getBossPhase() > 0 ? SWING_ATTACK_SOUL : SWING_ATTACK;
                        this.setAnimation(animation3);
                    }
                } else if ((this.blockingProgress == 10.0f || this.swordProgress == 10.0f) && !this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.func_70032_d((Entity)target) < 3.0f && this.func_70681_au().nextFloat() * 100.0f < 20.0f && this.getIsShield()) {
                    this.setAnimation(SHIELD_SMASH_ATTACK);
                } else if ((this.blockingProgress == 10.0f || this.swordProgress == 10.0f) && !this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && this.func_70032_d((Entity)target) < 3.0f && this.func_70681_au().nextFloat() * 100.0f < 10.0f && this.body_check_cooldown <= 0) {
                    this.body_check_cooldown = 200;
                    Animation animation3 = this.getBossPhase() > 0 ? BODY_CHECK_ATTACK_SOUL1 : BODY_CHECK_ATTACK1;
                    this.setAnimation(animation3);
                }
            }
        }
        super.func_70071_h_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.getAnimation() == SWING_ATTACK && this.getAnimationTick() == 34) {
            this.func_184185_a((SoundEvent)ModSounds.STRONGSWING.get(), 1.0f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
            this.AreaAttack(5.25f, 6.0f, 60.0f, 1.0f, 0.05f, 80, 3, 150);
        }
        if (this.getAnimation() == HORIZONTAL_SWING_ATTACK && this.getAnimationTick() == 31) {
            this.func_184185_a((SoundEvent)ModSounds.STRONGSWING.get(), 1.0f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
            this.AreaAttack(5.25f, 6.0f, 170.0f, 1.1f, 0.08f, 100, 5, 150);
        }
        if (this.getAnimation() == SWING_ATTACK_SOUL && this.getAnimationTick() == 28) {
            this.func_184185_a((SoundEvent)ModSounds.STRONGSWING.get(), 1.0f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
            this.AreaAttack(5.25f, 6.0f, 60.0f, 1.0f, 0.05f, 80, 3, 150);
        }
        if (this.getAnimation() == HORIZONTAL_SWING_ATTACK_SOUL && this.getAnimationTick() == 27) {
            this.func_184185_a((SoundEvent)ModSounds.STRONGSWING.get(), 1.0f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
            this.AreaAttack(5.25f, 6.0f, 170.0f, 1.1f, 0.08f, 100, 5, 150);
        }
        if (this.getAnimation() == BREAK_THE_SHIELD) {
            if (this.getAnimationTick() == 25) {
                this.setShowShield(false);
                this.ShieldExplode(-2.75f, 1.5f, 2.0f);
            }
            if (this.getAnimationTick() == 79) {
                this.setIsShieldBreak(true);
            }
            if (this.getAnimationTick() == 55) {
                this.func_184185_a(SoundEvents.field_187525_aO, 1.0f, 0.4f);
                ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 30.0f, 0.15f, 0, 50);
                List<LivingEntity> entities = this.getEntityLivingBaseNearby(12.0, 12.0, 12.0, 12.0);
                for (LivingEntity inRange : entities) {
                    if (inRange instanceof PlayerEntity && ((PlayerEntity)inRange).field_71075_bZ.field_75102_a || this.func_184191_r((Entity)inRange)) continue;
                    inRange.func_195064_c(new EffectInstance((Effect)ModEffect.EFFECTSTUN.get(), 60));
                }
            }
        }
        if (this.getAnimation() == PHASE_2) {
            if (this.getAnimationTick() == 29) {
                this.func_184185_a((SoundEvent)ModSounds.FLAME_BURST.get(), 1.0f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
            }
            if (this.getAnimationTick() > 29 && this.getAnimationTick() < 39) {
                this.Sphereparticle(2.0f, 0.0f, 5.0f);
                this.Phase_Transition(14, 0.4f, 0.03f, 5, 150);
            }
            if (this.getAnimationTick() == 34) {
                this.setBossPhase(1);
            }
        }
        if (this.getAnimation() == PHASE_3) {
            if (this.getAnimationTick() == 58) {
                this.setBossPhase(2);
                this.setShowShield(false);
                if (!this.getIsShieldBreak()) {
                    this.ShieldExplode(2.0f, 0.575f, 2.0f);
                }
                this.func_184185_a((SoundEvent)ModSounds.FLAME_BURST.get(), 1.0f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
                this.func_184185_a((SoundEvent)ModSounds.SWORD_STOMP.get(), 1.0f, 0.75f + this.func_70681_au().nextFloat() * 0.1f);
                ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 30.0f, 0.15f, 0, 10);
                this.ShieldSmashparticle(0.5f, 1.0f, -0.15f);
            }
            if (this.getAnimationTick() > 58) {
                if (this.getAnimationTick() < 68) {
                    this.Sphereparticle(0.5f, 1.0f, 6.0f);
                    this.Phase_Transition(27, 0.6f, 0.05f, 5, 150);
                }
                if (this.getAnimationTick() < 78 && this.func_110143_aJ() <= this.func_110138_aP() * 0.5f) {
                    this.func_70691_i((float)(7.0 * CMConfig.IgnisHealthMultiplier));
                }
            }
        }
        if (this.getAnimation() == SHIELD_SMASH_ATTACK) {
            if (this.getAnimationTick() == 34) {
                this.func_184185_a(SoundEvents.field_191263_gW, 1.5f, 0.8f + this.func_70681_au().nextFloat() * 0.1f);
                ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 20.0f, 0.3f, 0, 20);
                this.AreaAttack(4.85f, 2.5f, 45.0f, 1.5f, 0.15f, 200, 0, 0);
                this.ShieldSmashDamage(4, 2.75f);
                this.ShieldSmashparticle(1.3f, 2.75f, -0.1f);
            }
            if (this.getAnimationTick() == 37) {
                this.ShieldSmashDamage(5, 2.75f);
            }
            if (this.getAnimationTick() == 40) {
                this.ShieldSmashDamage(6, 2.75f);
            }
        }
        if (this.getAnimation() == SMASH) {
            if (this.getAnimationTick() == 5) {
                this.func_184185_a(SoundEvents.field_191263_gW, 1.5f, 0.8f + this.func_70681_au().nextFloat() * 0.1f);
                ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 20.0f, 0.3f, 0, 20);
                this.AreaAttack(4.85f, 2.5f, 45.0f, 1.5f, 0.15f, 200, 0, 0);
                this.ShieldSmashDamage(3, 1.5f);
                this.ShieldSmashparticle(1.3f, 1.5f, 0.0f);
            }
            if (this.getAnimationTick() == 8) {
                this.ShieldSmashDamage(4, 1.5f);
            }
            if (this.getAnimationTick() == 11) {
                this.ShieldSmashDamage(5, 1.5f);
            }
            if (this.getAnimationTick() == 14) {
                this.ShieldSmashDamage(6, 1.5f);
            }
        }
        if (this.getAnimation() == POKE_ATTACK) {
            if (this.getAnimationTick() == 37) {
                this.func_184185_a((SoundEvent)ModSounds.IGNIS_POKE.get(), 1.0f, 0.75f + this.func_70681_au().nextFloat() * 0.1f);
            }
            if (this.getAnimationTick() == 39) {
                this.Poke(7.0f, 70.0f, 60);
            }
        }
        if (this.getAnimation() == POKE_ATTACK2) {
            if (this.getAnimationTick() == 32) {
                this.func_184185_a((SoundEvent)ModSounds.IGNIS_POKE.get(), 1.0f, 0.75f + this.func_70681_au().nextFloat() * 0.1f);
            }
            if (this.getAnimationTick() == 34) {
                this.Poke(7.0f, 65.0f, 50);
            }
        }
        if (this.getAnimation() == POKE_ATTACK3) {
            if (this.getAnimationTick() == 27) {
                this.func_184185_a((SoundEvent)ModSounds.IGNIS_POKE.get(), 1.0f, 0.75f + this.func_70681_au().nextFloat() * 0.1f);
            }
            if (this.getAnimationTick() == 29) {
                this.Poke(7.0f, 60.0f, 40);
            }
        }
        if ((this.getAnimation() == BODY_CHECK_ATTACK1 || this.getAnimation() == BODY_CHECK_ATTACK2 || this.getAnimation() == BODY_CHECK_ATTACK3 || this.getAnimation() == BODY_CHECK_ATTACK4) && this.getAnimationTick() == 25) {
            this.BodyCheckAttack(3.0f, 6.0f, 120.0f, 0.8f, 0.03f, 40, 80);
        }
        if ((this.getAnimation() == BODY_CHECK_ATTACK_SOUL1 || this.getAnimation() == BODY_CHECK_ATTACK_SOUL2 || this.getAnimation() == BODY_CHECK_ATTACK_SOUL3 || this.getAnimation() == BODY_CHECK_ATTACK_SOUL4) && this.getAnimationTick() == 21) {
            this.BodyCheckAttack(3.0f, 6.0f, 120.0f, 0.9f, 0.03f, 60, 100);
        }
        if (this.getAnimation() == TRIPLE_ATTACK) {
            if (this.getAnimationTick() == 30) {
                this.func_184185_a((SoundEvent)ModSounds.STRONGSWING.get(), 1.0f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
                this.AreaAttack(5.5f, 6.0f, 100.0f, 1.0f, 0.05f, 80, 3, 150);
            }
            if (this.getAnimationTick() == 73) {
                this.func_184185_a((SoundEvent)ModSounds.STRONGSWING.get(), 1.0f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
                this.AreaAttack(5.5f, 6.0f, 45.0f, 1.1f, 0.06f, 120, 5, 150);
            }
            if (this.getAnimationTick() == 108) {
                this.BodyCheckAttack(4.85f, 6.0f, 60.0f, 1.0f, 0.01f, 40, 0);
            }
        }
        if (this.getAnimation() == FOUR_COMBO) {
            if (this.getAnimationTick() == 115) {
                this.func_184185_a((SoundEvent)ModSounds.FLAME_BURST.get(), 1.0f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
                this.func_184185_a((SoundEvent)ModSounds.SWORD_STOMP.get(), 1.0f, 0.75f + this.func_70681_au().nextFloat() * 0.1f);
                ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 30.0f, 0.15f, 0, 50);
                this.AreaAttack(4.0f, 4.0f, 45.0f, 1.2f, 0.1f, 200, 5, 150);
                this.ShieldSmashparticle(0.5f, 1.0f, -0.15f);
            }
            if (this.getAnimationTick() > 115 && this.getAnimationTick() < 125) {
                this.Sphereparticle(0.5f, 1.0f, 6.0f);
                this.Phase_Transition(56, 0.4f, 0.03f, 5, 150);
            }
        }
    }

    @Override
    @Nullable
    public Animation getDeathAnimation() {
        return IGNIS_DEATH;
    }

    private void AreaAttack(float range, float height, float arc, float damage, float hpdamage, int shieldbreakticks, int firetime, int brandticks) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.func_226281_cx_() - this.func_226281_cx_(), entityHit.func_226277_ct_() - this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.field_70761_aq % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.func_226281_cx_() - this.func_226281_cx_()) * (entityHit.func_226281_cx_() - this.func_226281_cx_()) + (entityHit.func_226277_ct_() - this.func_226277_ct_()) * (entityHit.func_226277_ct_() - this.func_226277_ct_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || entityHit instanceof Ignis_Entity) continue;
            boolean flag = entityHit.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)(this.func_233637_b_(Attributes.field_233823_f_) * (double)damage + (double)(entityHit.func_110138_aP() * hpdamage)));
            if (entityHit instanceof PlayerEntity && entityHit.func_184585_cz() && shieldbreakticks > 0) {
                Ignis_Entity.disableShield(entityHit, shieldbreakticks);
            }
            if (!flag) continue;
            entityHit.func_70015_d(firetime);
            if (brandticks <= 0) continue;
            EffectInstance effectinstance1 = entityHit.func_70660_b((Effect)ModEffect.EFFECTBLAZING_BRAND.get());
            int i = 1;
            if (effectinstance1 != null) {
                i += effectinstance1.func_76458_c();
                entityHit.func_184596_c((Effect)ModEffect.EFFECTBLAZING_BRAND.get());
            } else {
                --i;
            }
            i = MathHelper.func_76125_a((int)i, (int)0, (int)4);
            EffectInstance effectinstance = new EffectInstance((Effect)ModEffect.EFFECTBLAZING_BRAND.get(), brandticks, i, false, false, true);
            entityHit.func_195064_c(effectinstance);
            this.func_70691_i(6 * (i + 1));
        }
    }

    private void BodyCheckAttack(float range, float height, float arc, float damage, float hpdamage, int shieldbreakticks, int slowticks) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.func_226281_cx_() - this.func_226281_cx_(), entityHit.func_226277_ct_() - this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.field_70761_aq % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.func_226281_cx_() - this.func_226281_cx_()) * (entityHit.func_226281_cx_() - this.func_226281_cx_()) + (entityHit.func_226277_ct_() - this.func_226277_ct_()) * (entityHit.func_226277_ct_() - this.func_226277_ct_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.func_184191_r((Entity)entityHit) || entityHit instanceof Ignis_Entity) continue;
            boolean flag = entityHit.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)(this.func_233637_b_(Attributes.field_233823_f_) * (double)damage + (double)(entityHit.func_110138_aP() * hpdamage)));
            if (entityHit instanceof PlayerEntity && entityHit.func_184585_cz() && shieldbreakticks > 0) {
                Ignis_Entity.disableShield(entityHit, shieldbreakticks);
            }
            double d0 = entityHit.func_226277_ct_() - this.func_226277_ct_();
            double d1 = entityHit.func_226281_cx_() - this.func_226281_cx_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            entityHit.func_70024_g(d0 / d2 * 2.5, 0.2, d1 / d2 * 2.5);
            if (!flag) continue;
            this.func_184185_a(SoundEvents.field_187689_f, 1.5f, 0.8f + this.func_70681_au().nextFloat() * 0.1f);
            if (slowticks <= 0) continue;
            entityHit.func_195064_c(new EffectInstance((Effect)ModEffect.EFFECTSTUN.get(), slowticks, 1, false, false, true));
        }
    }

    private void Poke(float range, float arc, int shieldbreakticks) {
        LivingEntity target = this.func_70638_az();
        if (target != null) {
            float entityHitAngle = (float)((Math.atan2(target.func_226281_cx_() - this.func_226281_cx_(), target.func_226277_ct_() - this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.field_70761_aq % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            if (this.func_70032_d((Entity)target) <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f || entityRelativeAngle <= -360.0f + arc / 2.0f) {
                boolean flag = target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_) + target.func_110138_aP() * 0.1f);
                if (target instanceof PlayerEntity && target.func_184585_cz() && shieldbreakticks > 0) {
                    Ignis_Entity.disableShield(target, shieldbreakticks);
                }
                if (flag && !EntityTypeTags.func_219762_a().func_199910_a(ModTag.IGNIS_CANT_POKE).func_230235_a_((Object)target.func_200600_R())) {
                    if (target.func_225608_bj_()) {
                        target.func_226284_e_(false);
                    }
                    target.func_184205_a((Entity)this, true);
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, POKED_ATTACK);
                }
            }
        }
    }

    private void Flameswing() {
        Vector3d bladePos = this.socketPosArray[0];
        int snowflakeDensity = 4;
        float snowflakeRandomness = 0.5f;
        double length = this.prevBladePos.func_178788_d(bladePos).func_72433_c();
        int numClouds = (int)Math.floor(2.0 * length);
        for (int i = 0; i < numClouds; ++i) {
            double x = this.prevBladePos.field_72450_a + (double)i * (bladePos.field_72450_a - this.prevBladePos.field_72450_a) / (double)numClouds;
            double y = this.prevBladePos.field_72448_b + (double)i * (bladePos.field_72448_b - this.prevBladePos.field_72448_b) / (double)numClouds;
            double z = this.prevBladePos.field_72449_c + (double)i * (bladePos.field_72449_c - this.prevBladePos.field_72449_c) / (double)numClouds;
            for (int j = 0; j < snowflakeDensity; ++j) {
                float xOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                float yOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                float zOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                if (this.getBossPhase() > 0) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, 0.0, 0.0, 0.0);
                    continue;
                }
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnSwipeParticles() {
        if (this.field_70170_p.field_72995_K) {
            Vector3d bladePos = this.socketPosArray[0];
            if (this.getAnimation() == HORIZONTAL_SWING_ATTACK && this.getAnimationTick() > 27 && this.getAnimationTick() < 33) {
                this.Flameswing();
            }
            if (this.getAnimation() == SWING_ATTACK && this.getAnimationTick() > 25 && this.getAnimationTick() < 37) {
                this.Flameswing();
            }
            if (this.getAnimation() == HORIZONTAL_SWING_ATTACK_SOUL && this.getAnimationTick() > 24 && this.getAnimationTick() < 28) {
                this.Flameswing();
            }
            if (this.getAnimation() == SWING_ATTACK_SOUL && this.getAnimationTick() > 26 && this.getAnimationTick() < 29) {
                this.Flameswing();
            }
            if (this.getAnimation() == BURNS_THE_EARTH && this.getAnimationTick() > 35 && this.getAnimationTick() < 52) {
                this.Flameswing();
            }
            if (this.getAnimation() == TRIPLE_ATTACK) {
                this.Flameswing();
            }
            if (this.getAnimation() == PHASE_3 && this.getAnimationTick() > 96 && this.getAnimationTick() < 100) {
                this.Flameswing();
            }
            if (this.getAnimation() == FOUR_COMBO) {
                this.Flameswing();
            }
            if (this.getAnimation() == STRIKE && this.getAnimationTick() > 23 && this.getAnimationTick() < 28) {
                this.Flameswing();
            }
            this.prevBladePos = bladePos;
        }
    }

    private void ShieldSmashparticle(float radius, float vec, float math) {
        if (this.field_70170_p.field_72995_K) {
            for (int i1 = 0; i1 < 80 + this.field_70146_Z.nextInt(12); ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1;
                float f = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                double theta = (double)this.field_70761_aq * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                int hitX = MathHelper.func_76128_c((double)(this.func_226277_ct_() + (double)vec * vecX + extraX));
                int hitY = MathHelper.func_76128_c((double)this.func_226278_cu_());
                int hitZ = MathHelper.func_76128_c((double)(this.func_226281_cx_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.field_70170_p.func_180495_p(hit.func_177977_b());
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, block), this.func_226277_ct_() + (double)vec * vecX + extraX + (double)(f * math), this.func_226278_cu_() + extraY, this.func_226281_cx_() + (double)vec * vecZ + extraZ + (double)(f1 * math), motionX, motionY, motionZ);
            }
        }
    }

    private void ShieldExplode(float radius, float math, float y) {
        if (!this.field_70170_p.field_72995_K) {
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            float f = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_() + extraX + (double)(f * math), this.func_226278_cu_() + (double)y, this.func_226281_cx_() + extraZ + (double)(f1 * math), 2.0f, Explosion.Mode.NONE);
        }
    }

    private void ShieldSmashDamage(int distance, float vec) {
        double perpFacing = (double)this.field_70761_aq * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72338_b - 0.5));
        double spread = Math.PI * 2;
        int arcLen = MathHelper.func_76143_f((double)((double)distance * spread));
        double minY = this.func_226278_cu_() - 1.0;
        double maxY = this.func_226278_cu_() + 1.5;
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vecX = Math.cos(theta);
            double vecZ = Math.sin(theta);
            double px = this.func_226277_ct_() + vecX * (double)distance + (double)vec * Math.cos((double)(this.field_70761_aq + 90.0f) * Math.PI / 180.0);
            double pz = this.func_226281_cx_() + vecZ * (double)distance + (double)vec * Math.sin((double)(this.field_70761_aq + 90.0f) * Math.PI / 180.0);
            if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                int hitX = MathHelper.func_76128_c((double)px);
                int hitZ = MathHelper.func_76128_c((double)pz);
                BlockPos pos = new BlockPos(hitX, hitY, hitZ);
                BlockPos abovePos = new BlockPos((Vector3i)pos).func_177984_a();
                BlockState block = this.field_70170_p.func_180495_p(pos);
                BlockState blockAbove = this.field_70170_p.func_180495_p(abovePos);
                if (!(block.func_185904_a() == Material.field_151579_a || block.func_177230_c().hasTileEntity(block) || blockAbove.func_185904_a().func_76230_c() || BlockTags.func_199896_a().func_199910_a(ModTag.NETHERITE_MONSTROSITY_IMMUNE).func_230235_a_((Object)block.func_177230_c()))) {
                    FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(this.field_70170_p, (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
                    fallingBlockEntity.func_70024_g(0.0, 0.2 + this.func_70681_au().nextGaussian() * 0.15, 0.0);
                    this.field_70170_p.func_217376_c((Entity)fallingBlockEntity);
                }
            }
            AxisAlignedBB selection = new AxisAlignedBB(px - 0.5, minY, pz - 0.5, px + 0.5, maxY, pz + 0.5);
            List hit = this.field_70170_p.func_217357_a(LivingEntity.class, selection);
            for (LivingEntity entity : hit) {
                boolean flag;
                if (this.func_184191_r((Entity)entity) || entity instanceof Ignis_Entity || entity == this || !(flag = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_)))) continue;
                double airborne = 0.1 * (double)distance + this.field_70170_p.field_73012_v.nextDouble() * 0.15;
                entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, airborne, 0.0));
            }
        }
    }

    private void Sphereparticle(float height, float vec, float size) {
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 2 == 0) {
            double d0 = this.func_226277_ct_();
            double d1 = this.func_226278_cu_() + (double)height;
            double d2 = this.func_226281_cx_();
            double theta = (double)this.field_70761_aq * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            for (float i = -size; i <= size; i += 1.0f) {
                for (float j = -size; j <= size; j += 1.0f) {
                    for (float k = -size; k <= size; k += 1.0f) {
                        double d3 = (double)j + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                        double d4 = (double)i + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                        double d5 = (double)k + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                        double d6 = (double)MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5)) / 0.5 + this.field_70146_Z.nextGaussian() * 0.05;
                        if (this.getBossPhase() == 0) {
                            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + (double)vec * vecX, d1, d2 + (double)vec * vecZ, d3 / d6, d4 / d6, d5 / d6);
                        } else {
                            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, d0 + (double)vec * vecX, d1, d2 + (double)vec * vecZ, d3 / d6, d4 / d6, d5 / d6);
                        }
                        if (i == -size || i == size || j == -size || j == size) continue;
                        k += size * 2.0f - 1.0f;
                    }
                }
            }
        }
    }

    private void Phase_Transition(int dist, float damage, float hpdamage, int firetime, int brandticks) {
        if (this.getAnimationTick() % 2 == 0) {
            int distance = this.getAnimationTick() / 2 - dist;
            List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(distance, distance, distance, distance);
            for (LivingEntity entityHit : entitiesHit) {
                boolean flag;
                if (this.func_184191_r((Entity)entityHit) || entityHit instanceof Ignis_Entity || entityHit == this || !(flag = entityHit.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this), (float)(this.func_233637_b_(Attributes.field_233823_f_) * (double)damage + (double)hpdamage)))) continue;
                entityHit.func_70015_d(firetime);
                if (brandticks <= 0) continue;
                EffectInstance effectinstance1 = entityHit.func_70660_b((Effect)ModEffect.EFFECTBLAZING_BRAND.get());
                int i = 1;
                if (effectinstance1 != null) {
                    i += effectinstance1.func_76458_c();
                    entityHit.func_184596_c((Effect)ModEffect.EFFECTBLAZING_BRAND.get());
                } else {
                    --i;
                }
                i = MathHelper.func_76125_a((int)i, (int)0, (int)4);
                EffectInstance effectinstance = new EffectInstance((Effect)ModEffect.EFFECTBLAZING_BRAND.get(), brandticks, i, false, false, true);
                entityHit.func_195064_c(effectinstance);
            }
        }
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            boolean flag;
            LivingEntity target;
            int tick = 5;
            if (this.getAnimation() == POKED_ATTACK) {
                tick = this.getAnimationTick();
                if (this.getAnimationTick() == 46) {
                    passenger.func_184210_p();
                }
                this.field_70761_aq = this.field_70177_z = this.field_70126_B;
                this.field_70759_as = this.field_70177_z;
            }
            float radius = 4.0f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = tick < 10 ? 0.0 : (double)(0.2f * (float)MathHelper.func_76125_a((int)(tick - 10), (int)0, (int)15));
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY + (double)1.2f, this.func_226281_cx_() + extraZ);
            if ((tick - 10) % 4 == 0 && (target = this.func_70638_az()) != null && passenger == target && (flag = target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 4.0f + target.func_110138_aP() * 0.02f))) {
                EffectInstance effectinstance1 = target.func_70660_b((Effect)ModEffect.EFFECTBLAZING_BRAND.get());
                int i = 1;
                if (effectinstance1 != null) {
                    i += effectinstance1.func_76458_c();
                    target.func_184596_c((Effect)ModEffect.EFFECTBLAZING_BRAND.get());
                } else {
                    --i;
                }
                i = MathHelper.func_76125_a((int)i, (int)0, (int)4);
                EffectInstance effectinstance = new EffectInstance((Effect)ModEffect.EFFECTBLAZING_BRAND.get(), 150, i, false, false, true);
                target.func_195064_c(effectinstance);
                this.func_70691_i(2 * (i + 1));
            }
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        super.repelEntities(x, y, z, radius);
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    public void func_213352_e(Vector3d travelVector) {
        this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_) * (this.func_180799_ab() ? 0.2f : 1.0f));
        if (this.getAnimation() == POKED_ATTACK) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            travelVector = Vector3d.field_186680_a;
            super.func_213352_e(travelVector);
            return;
        }
        super.func_213352_e(travelVector);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.IGNIS_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSounds.IGNIS_DEATH.get();
    }

    protected BodyController func_184650_s() {
        return new SmartBodyHelper2((MobEntity)this);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new CMPathNavigateGround((MobEntity)this, this.field_70170_p);
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private boolean shouldFollowUp(float Range) {
        LivingEntity target = this.func_70638_az();
        if (target != null && target.func_70089_S()) {
            Vector3d betweenEntitiesVec;
            Vector3d targetMoveVec = target.func_213322_ci();
            boolean targetComingCloser = targetMoveVec.func_72430_b(betweenEntitiesVec = this.func_213303_ch().func_178788_d(target.func_213303_ch())) > 0.0;
            return this.func_70032_d((Entity)target) < Range || this.func_70032_d((Entity)target) < 5.0f + Range && targetComingCloser;
        }
        return false;
    }

    class Break_the_Shield
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Break_the_Shield(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            if (Ignis_Entity.this.getAnimationTick() > 35 && target != null) {
                Ignis_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.field_70177_z = Ignis_Entity.this.field_70126_B;
            }
        }
    }

    class Four_Combo
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Four_Combo(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            if (Ignis_Entity.this.getAnimationTick() < 26 && target != null || Ignis_Entity.this.getAnimationTick() < 48 && Ignis_Entity.this.getAnimationTick() > 28 && target != null || Ignis_Entity.this.getAnimationTick() < 76 && Ignis_Entity.this.getAnimationTick() > 59 && target != null || Ignis_Entity.this.getAnimationTick() < 103 && Ignis_Entity.this.getAnimationTick() > 87 && target != null) {
                Ignis_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.field_70177_z = Ignis_Entity.this.field_70126_B;
            }
            if (Ignis_Entity.this.getAnimationTick() == 69 || Ignis_Entity.this.getAnimationTick() == 42 || Ignis_Entity.this.getAnimationTick() == 19) {
                float f1 = (float)Math.cos(Math.toRadians(Ignis_Entity.this.field_70177_z + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(Ignis_Entity.this.field_70177_z + 90.0f));
                if (target != null) {
                    if (Ignis_Entity.this.func_70032_d((Entity)target) > 3.5f) {
                        Ignis_Entity.this.func_70024_g((double)f1 * 1.5, 0.0, (double)f2 * 1.5);
                    }
                } else {
                    Ignis_Entity.this.func_70024_g((double)f1 * 1.5, 0.0, (double)f2 * 1.5);
                }
            }
        }
    }

    class Triple_Attack
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Triple_Attack(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            if (Ignis_Entity.this.getAnimationTick() < 30 && target != null || Ignis_Entity.this.getAnimationTick() < 69 && Ignis_Entity.this.getAnimationTick() > 42 && target != null || Ignis_Entity.this.getAnimationTick() < 108 && Ignis_Entity.this.getAnimationTick() > 84 && target != null || Ignis_Entity.this.getAnimationTick() > 124 && target != null) {
                Ignis_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.field_70177_z = Ignis_Entity.this.field_70126_B;
            }
            if (Ignis_Entity.this.getAnimationTick() == 27 || Ignis_Entity.this.getAnimationTick() == 105) {
                float f1 = (float)Math.cos(Math.toRadians(Ignis_Entity.this.field_70177_z + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(Ignis_Entity.this.field_70177_z + 90.0f));
                if (target != null) {
                    if (Ignis_Entity.this.func_70032_d((Entity)target) > 3.5f) {
                        Ignis_Entity.this.func_70024_g((double)f1 * 1.5, 0.0, (double)f2 * 1.5);
                    }
                } else {
                    Ignis_Entity.this.func_70024_g((double)f1 * 1.5, 0.0, (double)f2 * 1.5);
                }
            }
        }
    }

    class Ignis_Attack_Goal
    extends SimpleAnimationGoal<Ignis_Entity> {
        private final int look1;

        public Ignis_Attack_Goal(Ignis_Entity entity, Animation animation, int look1) {
            super(entity, animation);
            this.look1 = look1;
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            if (Ignis_Entity.this.getAnimationTick() < this.look1 && target != null) {
                Ignis_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.field_70177_z = Ignis_Entity.this.field_70126_B;
            }
            Ignis_Entity.this.func_213293_j(0.0, Ignis_Entity.this.func_213322_ci().field_72448_b, 0.0);
        }
    }

    class Body_Check
    extends SimpleAnimationGoal<Ignis_Entity> {
        private final int look;
        private final int charge;
        private final float motionx;
        private final float motionz;

        public Body_Check(Ignis_Entity entity, Animation animation, int look, int charge, float motionx, float motionz) {
            super(entity, animation);
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.look = look;
            this.charge = charge;
            this.motionx = motionx;
            this.motionz = motionz;
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            if (Ignis_Entity.this.getAnimationTick() < this.look && target != null) {
                Ignis_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.field_70177_z = Ignis_Entity.this.field_70126_B;
            }
            if (Ignis_Entity.this.getAnimationTick() == this.charge && target != null) {
                Ignis_Entity.this.func_213293_j((target.func_226277_ct_() - Ignis_Entity.this.func_226277_ct_()) * (double)this.motionx, 0.0, (target.func_226281_cx_() - Ignis_Entity.this.func_226281_cx_()) * (double)this.motionz);
            }
        }
    }

    class Air_Smash
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Air_Smash(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            if (target != null) {
                Ignis_Entity.this.func_70625_a((Entity)target, 30.0f, 30.0f);
            }
            if (Ignis_Entity.this.getAnimationTick() == 19) {
                if (target != null) {
                    Ignis_Entity.this.func_213293_j((target.func_226277_ct_() - Ignis_Entity.this.func_226277_ct_()) * 0.2, 1.4, (target.func_226281_cx_() - Ignis_Entity.this.func_226281_cx_()) * 0.2);
                } else {
                    Ignis_Entity.this.func_213293_j(0.0, 1.4, 0.0);
                }
            }
            if (Ignis_Entity.this.getAnimationTick() > 19 && Ignis_Entity.this.func_233570_aj_()) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)Ignis_Entity.this, SMASH);
            }
        }
    }

    class Shield_Smash
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Shield_Smash(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            if (Ignis_Entity.this.getAnimationTick() < 34 && target != null) {
                Ignis_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.field_70177_z = Ignis_Entity.this.field_70126_B;
            }
            Ignis_Entity.this.func_213293_j(0.0, Ignis_Entity.this.func_213322_ci().field_72448_b, 0.0);
            if (Ignis_Entity.this.getAnimationTick() == 45 && Ignis_Entity.this.shouldFollowUp(4.0f) && Ignis_Entity.this.field_70146_Z.nextInt(3) == 0 && Ignis_Entity.this.body_check_cooldown <= 0) {
                Ignis_Entity.this.body_check_cooldown = 200;
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)Ignis_Entity.this, BODY_CHECK_ATTACK3);
            }
        }
    }

    class Phase_Transition2
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Phase_Transition2(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            if (Ignis_Entity.this.getAnimationTick() < 34 && target != null) {
                Ignis_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.field_70177_z = Ignis_Entity.this.field_70126_B;
            }
            Ignis_Entity.this.func_213293_j(0.0, Ignis_Entity.this.func_213322_ci().field_72448_b, 0.0);
        }
    }

    class Phase_Transition
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Phase_Transition(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            if (Ignis_Entity.this.getAnimationTick() < 34 && target != null || Ignis_Entity.this.getAnimationTick() > 54 && target != null) {
                Ignis_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.field_70177_z = Ignis_Entity.this.field_70126_B;
            }
            Ignis_Entity.this.func_213293_j(0.0, Ignis_Entity.this.func_213322_ci().field_72448_b, 0.0);
        }
    }

    class Poked
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Poked(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            if (target != null) {
                Ignis_Entity.this.func_70671_ap().func_75651_a((Entity)target, 20.0f, 20.0f);
            }
            Ignis_Entity.this.func_213293_j(0.0, Ignis_Entity.this.func_213322_ci().field_72448_b, 0.0);
        }
    }

    class PokeGoal
    extends SimpleAnimationGoal<Ignis_Entity> {
        private final int look1;
        private final int look2;
        private final int charge;
        private final int bodycheck;
        private final int motion1;
        private final int motion2;

        public PokeGoal(Ignis_Entity entity, Animation animation, int look1, int look2, int charge, int bodycheck, int motion1, int motion2) {
            super(entity, animation);
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.look1 = look1;
            this.look2 = look2;
            this.charge = charge;
            this.bodycheck = bodycheck;
            this.motion1 = motion1;
            this.motion2 = motion2;
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            float f1 = (float)Math.cos(Math.toRadians(Ignis_Entity.this.field_70177_z + 90.0f));
            float f2 = (float)Math.sin(Math.toRadians(Ignis_Entity.this.field_70177_z + 90.0f));
            if (Ignis_Entity.this.getAnimationTick() < this.look1 && target != null || Ignis_Entity.this.getAnimationTick() > this.look2 && target != null) {
                Ignis_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.field_70177_z = Ignis_Entity.this.field_70126_B;
            }
            if (Ignis_Entity.this.getAnimationTick() == this.charge) {
                if (target != null) {
                    float r = Ignis_Entity.this.func_70032_d((Entity)target);
                    r = MathHelper.func_76131_a((float)r, (float)0.0f, (float)15.0f);
                    Ignis_Entity.this.func_70024_g((double)f1 * 0.3 * (double)r, 0.0, (double)f2 * 0.3 * (double)r);
                } else {
                    Ignis_Entity.this.func_70024_g(f1, 0.0, f2);
                }
            }
            if (Ignis_Entity.this.getAnimationTick() == this.bodycheck && Ignis_Entity.this.shouldFollowUp(3.0f) && Ignis_Entity.this.field_70146_Z.nextInt(2) == 0 && Ignis_Entity.this.body_check_cooldown <= 0) {
                Ignis_Entity.this.body_check_cooldown = 200;
                Animation bodycheck = Ignis_Entity.this.getBossPhase() > 0 ? BODY_CHECK_ATTACK_SOUL4 : BODY_CHECK_ATTACK4;
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)Ignis_Entity.this, bodycheck);
            }
            if (Ignis_Entity.this.getAnimationTick() < this.motion1 || Ignis_Entity.this.getAnimationTick() > this.motion2) {
                Ignis_Entity.this.func_213293_j(0.0, Ignis_Entity.this.func_213322_ci().field_72448_b, 0.0);
            }
        }
    }

    class Hornzontal_SwingGoal
    extends SimpleAnimationGoal<Ignis_Entity> {
        private final int look1;
        private final int look2;
        private final int charge;
        private final int bodycheck;

        public Hornzontal_SwingGoal(Ignis_Entity entity, Animation animation, int look1, int look2, int charge, int bodycheck) {
            super(entity, animation);
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.look1 = look1;
            this.look2 = look2;
            this.charge = charge;
            this.bodycheck = bodycheck;
        }

        public void func_75246_d() {
            LivingEntity target = Ignis_Entity.this.func_70638_az();
            if (Ignis_Entity.this.getAnimationTick() < this.look1 && target != null || Ignis_Entity.this.getAnimationTick() > this.look2 && target != null) {
                Ignis_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.field_70177_z = Ignis_Entity.this.field_70126_B;
            }
            if (Ignis_Entity.this.getAnimationTick() == this.charge) {
                float f1 = (float)Math.cos(Math.toRadians(Ignis_Entity.this.field_70177_z + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(Ignis_Entity.this.field_70177_z + 90.0f));
                if (target != null) {
                    float r = Ignis_Entity.this.func_70032_d((Entity)target);
                    r = MathHelper.func_76131_a((float)r, (float)0.0f, (float)10.0f);
                    Ignis_Entity.this.func_70024_g((double)f1 * 0.3 * (double)r, 0.0, (double)f2 * 0.3 * (double)r);
                }
            }
            if (Ignis_Entity.this.getAnimationTick() == this.bodycheck && Ignis_Entity.this.shouldFollowUp(3.5f) && Ignis_Entity.this.field_70146_Z.nextInt(3) == 0 && Ignis_Entity.this.body_check_cooldown <= 0) {
                Ignis_Entity.this.body_check_cooldown = 200;
                Animation bodycheck = Ignis_Entity.this.getBossPhase() > 0 ? BODY_CHECK_ATTACK_SOUL2 : BODY_CHECK_ATTACK2;
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)Ignis_Entity.this, bodycheck);
            }
        }
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.35f),
        MEDIUM(0.25f),
        HIGH(0.1f);

        private static final List<Crackiness> BY_DAMAGE;
        private final float fraction;

        private Crackiness(float p_28900_) {
            this.fraction = p_28900_;
        }

        public static Crackiness byFraction(float p_28902_) {
            for (Crackiness ignis$crackiness : BY_DAMAGE) {
                if (!(p_28902_ < ignis$crackiness.fraction)) continue;
                return ignis$crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

