/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.entity;

import L_Ender.cataclysm.entity.Ender_Golem_Entity;
import L_Ender.cataclysm.entity.Ender_Guardian_Entity;
import L_Ender.cataclysm.entity.etc.DirectPathNavigator;
import L_Ender.cataclysm.entity.etc.FlightMoveController;
import L_Ender.cataclysm.entity.projectile.Void_Shard_Entity;
import L_Ender.cataclysm.init.ModEntities;
import L_Ender.cataclysm.init.ModSounds;
import L_Ender.cataclysm.init.ModTag;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Endermaptera_Entity
extends MonsterEntity
implements IAnimatedEntity {
    public static final ResourceLocation HAS_JAWS_LOOT = new ResourceLocation("cataclysm", "entities/endermaptera_has_jaws");
    private int animationTick;
    private Animation currentAnimation;
    public static final Animation JAW_ATTACK = Animation.create((int)13);
    public static final Animation HEADBUTT_ATTACK = Animation.create((int)13);
    public float attachChangeProgress = 0.0f;
    public float prevAttachChangeProgress = 0.0f;
    private static final DataParameter<Direction> ATTACHED_FACE = EntityDataManager.func_187226_a(Endermaptera_Entity.class, (IDataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(Endermaptera_Entity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> HAS_JAWS = EntityDataManager.func_187226_a(Endermaptera_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private Direction prevAttachDir = Direction.DOWN;
    private boolean isUpsideDownNavigator;

    public Endermaptera_Entity(EntityType entity, World world) {
        super(entity, world);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.field_70728_aV = 6;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    private void switchNavigator(boolean rightsideUp) {
        if (rightsideUp) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new ClimberPathNavigator((MobEntity)this, this.field_70170_p);
            this.isUpsideDownNavigator = false;
        } else {
            this.field_70765_h = new FlightMoveController((MobEntity)this, 0.6f, false);
            this.field_70699_by = new DirectPathNavigator((MobEntity)this, this.field_70170_p);
            this.isUpsideDownNavigator = true;
        }
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, (double)0.27f).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233826_i_, 6.0).func_233815_a_(Attributes.field_233820_c_, 0.25);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(ATTACHED_FACE, (Object)Direction.DOWN);
        this.field_70180_af.func_187214_a(HAS_JAWS, (Object)true);
    }

    public Direction getAttachmentFacing() {
        return (Direction)this.field_70180_af.func_187225_a(ATTACHED_FACE);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.getHasJaws() ? HAS_JAWS_LOOT : super.func_184647_J();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Has_Jaws", this.getHasJaws());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)Direction.func_82600_a((int)compound.func_74771_c("AttachFace")));
        this.setHasJaw(compound.func_74767_n("Has_Jaws"));
    }

    public void setHasJaw(boolean HasJaws) {
        this.func_184212_Q().func_187227_b(HAS_JAWS, (Object)HasJaws);
    }

    public boolean getHasJaws() {
        return (Boolean)this.func_184212_Q().func_187225_a(HAS_JAWS);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected SoundEvent func_184639_G() {
        this.func_184185_a((SoundEvent)ModSounds.ENDERMAPTERA_AMBIENT.get(), 1.0f, 0.6f);
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a((SoundEvent)ModSounds.ENDERMAPTERA_HURT.get(), 1.0f, 0.6f);
        return null;
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a((SoundEvent)ModSounds.ENDERMAPTERA_DEATH.get(), 1.0f, 0.6f);
        return null;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)ModSounds.ENDERMAPTERA_STEP.get(), 0.15f, 0.6f);
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, JAW_ATTACK, HEADBUTT_ATTACK};
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == this) {
            return true;
        }
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof Ender_Guardian_Entity || entityIn instanceof Ender_Golem_Entity || entityIn instanceof ShulkerEntity || entityIn instanceof Endermaptera_Entity) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getHasJaws()) {
            this.setAnimation(JAW_ATTACK);
        } else {
            this.setAnimation(HEADBUTT_ATTACK);
        }
        return true;
    }

    public void func_70071_h_() {
        block22: {
            block21: {
                LivingEntity target;
                super.func_70071_h_();
                this.prevAttachChangeProgress = this.attachChangeProgress;
                AnimationHandler.INSTANCE.updateAnimations((Entity)this);
                if (this.attachChangeProgress > 0.0f) {
                    this.attachChangeProgress -= 0.25f;
                }
                Vector3d vector3d = this.func_213322_ci();
                if (!this.field_70170_p.field_72995_K) {
                    this.setBesideClimbableBlock(this.field_70123_F || this.field_70124_G && !this.func_233570_aj_());
                    if (this.func_233570_aj_() || this.func_203005_aq() || this.func_180799_ab()) {
                        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)Direction.DOWN);
                    } else if (this.field_70124_G) {
                        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)Direction.UP);
                    } else {
                        Direction closestDirection = Direction.DOWN;
                        double closestDistance = 100.0;
                        for (Direction dir : HORIZONTALS) {
                            BlockPos antPos = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_226278_cu_()), MathHelper.func_76128_c((double)this.func_226281_cx_()));
                            BlockPos offsetPos = antPos.func_177972_a(dir);
                            Vector3d offset = Vector3d.func_237489_a_((Vector3i)offsetPos);
                            if (!(closestDistance > this.func_213303_ch().func_72438_d(offset)) || !this.field_70170_p.func_234929_a_(offsetPos, (Entity)this, dir.func_176734_d())) continue;
                            closestDistance = this.func_213303_ch().func_72438_d(offset);
                            closestDirection = dir;
                        }
                        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)closestDirection);
                    }
                }
                boolean flag = false;
                if (this.getAttachmentFacing() != Direction.DOWN) {
                    if (this.getAttachmentFacing() == Direction.UP) {
                        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 1.0, 0.0));
                    } else {
                        if (!this.field_70123_F && this.getAttachmentFacing() != Direction.UP) {
                            Vector3d vec = Vector3d.func_237491_b_((Vector3i)this.getAttachmentFacing().func_176730_m());
                            this.func_213317_d(this.func_213322_ci().func_178787_e(vec.func_72432_b().func_216372_d((double)0.1f, (double)0.1f, (double)0.1f)));
                        }
                        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
                            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.5, 1.0));
                            flag = true;
                        }
                    }
                }
                if (this.getAttachmentFacing() == Direction.UP) {
                    this.func_189654_d(true);
                    this.func_213317_d(vector3d.func_216372_d(0.7, 1.0, 0.7));
                } else {
                    this.func_189654_d(false);
                }
                if (!flag && this.func_70617_f_()) {
                    this.func_213317_d(vector3d.func_216372_d(1.0, 0.4, 1.0));
                }
                if (this.prevAttachDir != this.getAttachmentFacing()) {
                    this.attachChangeProgress = 1.0f;
                }
                this.prevAttachDir = this.getAttachmentFacing();
                if (this.field_70170_p.field_72995_K) break block21;
                if (this.getAttachmentFacing() == Direction.UP && !this.isUpsideDownNavigator) {
                    this.switchNavigator(false);
                }
                if (this.getAttachmentFacing() != Direction.UP && this.isUpsideDownNavigator) {
                    this.switchNavigator(true);
                }
                if ((target = this.func_70638_az()) == null || !(this.func_70032_d((Entity)target) < target.func_213311_cf() + this.func_213311_cf()) || !this.func_70685_l((Entity)target)) break block22;
                float damage = (int)this.func_233637_b_(Attributes.field_233823_f_);
                if (this.getAnimation() == JAW_ATTACK && this.getAnimationTick() == 11) {
                    target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage);
                    if (this.field_70146_Z.nextInt(6) == 0) {
                        this.BrokenJaws();
                    }
                }
                if (this.getAnimation() != HEADBUTT_ATTACK || this.getAnimationTick() != 6) break block22;
                target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage * 0.75f);
                break block22;
            }
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    private void BrokenJaws() {
        this.func_184185_a(SoundEvents.field_187635_cQ, 0.5f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
        this.setHasJaw(false);
        int shardCount = 8 + this.field_70146_Z.nextInt(4);
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < shardCount; ++i) {
                float f = (float)(i + 1) / (float)shardCount * 360.0f;
                Void_Shard_Entity shard = new Void_Shard_Entity((EntityType)ModEntities.VOID_SHARD.get(), this.field_70170_p, (LivingEntity)this);
                shard.shootFromRotation((Entity)this, this.field_70125_A - (float)this.field_70146_Z.nextInt(40), f, 0.0f, 0.15f + this.field_70146_Z.nextFloat() * 0.2f, 1.0f);
                this.field_70170_p.func_217376_c((Entity)shard);
            }
        }
    }

    protected void func_191955_a(BlockState state) {
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public static boolean canSpawn(EntityType<Endermaptera_Entity> entity, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return Endermaptera_Entity.func_223315_a(entity, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn) && !worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_(BlockTags.func_199896_a().func_199910_a(ModTag.ENDERMAPTERA_CAN_NOT_SPAWN));
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }
}

