/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.entity;

import L_Ender.cataclysm.config.CMConfig;
import L_Ender.cataclysm.entity.AI.CmAttackGoal;
import L_Ender.cataclysm.entity.Boss_monster;
import L_Ender.cataclysm.entity.Ender_Guardian_Entity;
import L_Ender.cataclysm.entity.Endermaptera_Entity;
import L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import L_Ender.cataclysm.entity.etc.CMPathNavigateGround;
import L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import L_Ender.cataclysm.entity.projectile.Void_Rune_Entity;
import L_Ender.cataclysm.init.ModSounds;
import L_Ender.cataclysm.init.ModTag;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class Ender_Golem_Entity
extends Boss_monster {
    public static final Animation ANIMATION_ATTACK1 = Animation.create((int)25);
    public static final Animation ANIMATION_ATTACK2 = Animation.create((int)25);
    public static final Animation ANIMATION_EARTHQUAKE = Animation.create((int)35);
    public static final Animation VOID_RUNE_ATTACK = Animation.create((int)83);
    public static final Animation ENDER_GOLEM_DEATH = Animation.create((int)95);
    public static final int VOID_RUNE_ATTACK_COOLDOWN = 250;
    private static final DataParameter<Boolean> IS_AWAKEN = EntityDataManager.func_187226_a(Ender_Golem_Entity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int void_rune_attack_cooldown = 0;
    private int timeWithoutTarget;
    public float deactivateProgress;
    public float prevdeactivateProgress;
    public boolean Breaking = CMConfig.EndergolemBlockBreaking;

    public Ender_Golem_Entity(EntityType entity, World world) {
        super(entity, world);
        this.field_70728_aV = 15;
        this.field_70138_W = 1.5f;
        this.func_184644_a(PathNodeType.UNPASSABLE_RAIL, 0.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        Ender_Golem_Entity.setConfigattribute((LivingEntity)this, CMConfig.EnderGolemHealthMultiplier, CMConfig.EnderGolemDamageMultiplier);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_ATTACK1, ANIMATION_ATTACK2, ANIMATION_EARTHQUAKE, VOID_RUNE_ATTACK, ENDER_GOLEM_DEATH};
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new CmAttackGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new AwakenGoal());
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_233666_p_().func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233821_d_, (double)0.28f).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233826_i_, 12.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    private static Animation getRandomAttack(Random rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return ANIMATION_ATTACK1;
            }
            case 1: {
                return ANIMATION_ATTACK2;
            }
            case 2: {
                return ANIMATION_EARTHQUAKE;
            }
        }
        return ANIMATION_EARTHQUAKE;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        double range;
        if (!(this.getAnimation() != VOID_RUNE_ATTACK && this.getIsAwaken() || source.func_76357_e() && source.func_82725_o())) {
            damage = (float)((double)damage * 0.5);
        }
        if ((range = this.calculateRange(source)) > CMConfig.EndergolemLongRangelimit * CMConfig.EndergolemLongRangelimit) {
            return false;
        }
        Entity entity = source.func_76364_f();
        if (entity instanceof GolemEntity) {
            damage = (float)((double)damage * 0.5);
        }
        return super.func_70097_a(source, damage);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_AWAKEN, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("is_Awaken", this.getIsAwaken());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setIsAwaken(compound.func_74767_n("is_Awaken"));
    }

    public void setIsAwaken(boolean isAwaken) {
        this.func_184212_Q().func_187227_b(IS_AWAKEN, (Object)isAwaken);
    }

    public boolean getIsAwaken() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_AWAKEN);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70177_z = this.field_70761_aq;
        this.repelEntities(1.7f, 3.7f, 1.7f, 1.7f);
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        LivingEntity target = this.func_70638_az();
        this.prevdeactivateProgress = this.deactivateProgress;
        if (!this.getIsAwaken() && this.deactivateProgress < 30.0f) {
            this.deactivateProgress += 1.0f;
        }
        if (this.getIsAwaken() && this.deactivateProgress > 0.0f) {
            this.deactivateProgress -= 1.0f;
        }
        if (!this.getIsAwaken() && this.field_70173_aa % 20 == 0) {
            this.func_70691_i(2.0f);
        }
        if (this.deactivateProgress == 0.0f && this.func_70089_S()) {
            if (target != null && target.func_70089_S()) {
                if (this.void_rune_attack_cooldown <= 0 && !this.func_175446_cd() && this.getAnimation() == NO_ANIMATION && target.func_233570_aj_() && (this.field_70146_Z.nextInt(45) == 0 && this.func_70032_d((Entity)target) < 4.0f || this.field_70146_Z.nextInt(24) == 0 && this.func_70032_d((Entity)target) < 10.0f)) {
                    this.void_rune_attack_cooldown = 250;
                    this.setAnimation(VOID_RUNE_ATTACK);
                } else if (this.func_70032_d((Entity)target) < 4.0f && !this.func_175446_cd() && this.getAnimation() == NO_ANIMATION) {
                    Animation animation = Ender_Golem_Entity.getRandomAttack(this.field_70146_Z);
                    this.setAnimation(animation);
                }
            }
            if (this.getAnimation() == ANIMATION_EARTHQUAKE && this.getAnimationTick() == 19) {
                this.EarthQuake(5.0f, 6);
                this.EarthQuakeParticle();
                ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 15.0f, 0.1f, 0, 10);
                if (this.Breaking) {
                    this.BlockBreaking(4, 4, 4);
                } else if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                    this.BlockBreaking(4, 4, 4);
                }
            }
            if ((this.getAnimation() == ANIMATION_ATTACK1 || this.getAnimation() == ANIMATION_ATTACK2) && this.getAnimationTick() == 13) {
                this.func_184185_a((SoundEvent)ModSounds.GOLEMATTACK.get(), 1.0f, 1.0f);
                if (target != null && this.func_70032_d((Entity)target) < 4.75f) {
                    target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_) + (float)this.field_70146_Z.nextInt(4));
                    target.func_233627_a_(1.25f, this.func_226277_ct_() - target.func_226277_ct_(), this.func_226281_cx_() - target.func_226281_cx_());
                }
            }
            if (this.getAnimation() == VOID_RUNE_ATTACK) {
                if (this.getAnimationTick() == 22) {
                    this.EarthQuake(4.25f, 4);
                    this.EarthQuakeParticle();
                    ScreenShake_Entity.ScreenShake(this.field_70170_p, this.func_213303_ch(), 15.0f, 0.1f, 0, 10);
                    if (!this.field_70170_p.field_72995_K) {
                        if (this.Breaking) {
                            this.BlockBreaking(4, 4, 4);
                        } else if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                            this.BlockBreaking(4, 4, 4);
                        }
                    }
                }
                if (this.getAnimationTick() == 28) {
                    this.VoidRuneAttack();
                }
            }
        }
        if (this.void_rune_attack_cooldown > 0) {
            --this.void_rune_attack_cooldown;
        }
        if (!this.field_70170_p.field_72995_K) {
            ++this.timeWithoutTarget;
            if (target != null) {
                this.timeWithoutTarget = 0;
                if (!this.getIsAwaken()) {
                    this.setIsAwaken(true);
                }
            }
            if (this.timeWithoutTarget > 400 && this.getIsAwaken() && target == null) {
                this.timeWithoutTarget = 0;
                this.setIsAwaken(false);
            }
        }
    }

    private void BlockBreaking(int x, int y, int z) {
        int MthX = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int MthY = MathHelper.func_76128_c((double)this.func_226278_cu_());
        int MthZ = MathHelper.func_76128_c((double)this.func_226281_cx_());
        boolean flag = false;
        if (!this.field_70170_p.field_72995_K) {
            for (int k2 = -x; k2 <= x; ++k2) {
                for (int l2 = -z; l2 <= z; ++l2) {
                    for (int j = 0; j <= y; ++j) {
                        int i3 = MthX + k2;
                        int k = MthY + j;
                        int l = MthZ + l2;
                        BlockPos blockpos = new BlockPos(i3, k, l);
                        BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                        Block block = blockstate.func_177230_c();
                        ITag Tag = BlockTags.func_199896_a().func_199910_a(ModTag.ENDER_GOLEM_CAN_DESTROY);
                        if (block == Blocks.field_150350_a || !Tag.func_230235_a_((Object)block) || !blockstate.canEntityDestroy((IBlockReader)this.field_70170_p, blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                        flag = this.field_70170_p.func_225521_a_(blockpos, true, (Entity)this) || flag;
                    }
                }
            }
        }
    }

    private void EarthQuakeParticle() {
        if (this.field_70170_p.field_72995_K) {
            BlockState block = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b());
            for (int i1 = 0; i1 < 20 + this.field_70146_Z.nextInt(12); ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1;
                double extraX = 4.0f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = 4.0f * MathHelper.func_76134_b((float)angle);
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, block), this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY, this.func_226281_cx_() + extraZ, motionX, motionY, motionZ);
            }
        }
    }

    private void EarthQuake(float grow, int damage) {
        this.func_184185_a(SoundEvents.field_187539_bB, 1.5f, 1.0f + this.func_70681_au().nextFloat() * 0.1f);
        for (LivingEntity entity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g((double)grow))) {
            if (this.func_184191_r((Entity)entity) || entity instanceof Ender_Golem_Entity || entity == this) continue;
            entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_) + (float)this.field_70146_Z.nextInt(damage));
            this.launch((Entity)entity, true);
        }
    }

    private void VoidRuneAttack() {
        LivingEntity target = this.func_70638_az();
        if (target != null) {
            int k;
            double d0 = Math.min(target.func_226278_cu_(), this.func_226278_cu_());
            double d1 = Math.max(target.func_226278_cu_(), this.func_226278_cu_()) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(target.func_226281_cx_() - this.func_226281_cx_()), (double)(target.func_226277_ct_() - this.func_226277_ct_()));
            float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * 2.0f;
            float f3 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * 2.0f;
            for (int l = 0; l < 10; ++l) {
                double d2 = 1.5 * (double)(l + 1);
                int j = (int)(1.25f * (float)l);
                this.spawnFangs(this.func_226277_ct_() + (double)f2 + (double)MathHelper.func_76134_b((float)f) * d2, this.func_226281_cx_() + (double)f3 + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
                this.spawnFangs(this.func_226277_ct_() - (double)f2 + (double)MathHelper.func_76134_b((float)f) * d2, this.func_226281_cx_() - (double)f3 + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
            }
            for (k = 0; k < 6; ++k) {
                float f4 = f + (float)k * (float)Math.PI * 2.0f / 6.0f + 0.83775806f;
                this.spawnFangs(this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f4) * 2.5, this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f4) * 2.5, d0, d1, f2, 5);
            }
            for (k = 0; k < 8; ++k) {
                this.spawnFangs(this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * 4.5, this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * 4.5, d0, d1, f3, 15);
            }
        }
    }

    private void spawnFangs(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos(x, maxY, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)this.field_70170_p, blockpos1, Direction.UP)) continue;
            if (!this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b()) {
                d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)minY) - 1);
        if (flag) {
            this.field_70170_p.func_217376_c((Entity)new Void_Rune_Entity(this.field_70170_p, x, (double)blockpos.func_177956_o() + d0, z, rotation, delay, (LivingEntity)this));
        }
    }

    private void launch(Entity e, boolean huge) {
        double d0 = e.func_226277_ct_() - this.func_226277_ct_();
        double d1 = e.func_226281_cx_() - this.func_226281_cx_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        float f = huge ? 2.0f : 0.5f;
        e.func_70024_g(d0 / d2 * (double)f, huge ? 0.5 : (double)0.2f, d1 / d2 * (double)f);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == this) {
            return true;
        }
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof Ender_Golem_Entity || entityIn instanceof Ender_Guardian_Entity || entityIn instanceof ShulkerEntity || entityIn instanceof Endermaptera_Entity) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
        this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
        if (this.field_70725_aQ == 40) {
            this.func_184185_a((SoundEvent)ModSounds.MONSTROSITYLAND.get(), 1.0f, 1.0f);
        }
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        super.repelEntities(x, y, z, radius);
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    @Override
    @Nullable
    public Animation getDeathAnimation() {
        return ENDER_GOLEM_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.GOLEMHURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSounds.GOLEMDEATH.get();
    }

    protected BodyController func_184650_s() {
        return new SmartBodyHelper2((MobEntity)this);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new CMPathNavigateGround((MobEntity)this, this.field_70170_p);
    }

    class AwakenGoal
    extends Goal {
        public AwakenGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Ender_Golem_Entity.this.deactivateProgress > 0.0f;
        }

        public void func_75246_d() {
            Ender_Golem_Entity.this.func_213293_j(0.0, Ender_Golem_Entity.this.func_213322_ci().field_72448_b, 0.0);
        }
    }

    class AttackGoal
    extends Goal {
        public AttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return Ender_Golem_Entity.this.getAnimation() == ANIMATION_EARTHQUAKE || Ender_Golem_Entity.this.getAnimation() == VOID_RUNE_ATTACK;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            Ender_Golem_Entity.this.func_213293_j(0.0, Ender_Golem_Entity.this.func_213322_ci().field_72448_b, 0.0);
            LivingEntity target = Ender_Golem_Entity.this.func_70638_az();
            if (Ender_Golem_Entity.this.getAnimation() == ANIMATION_EARTHQUAKE) {
                if (Ender_Golem_Entity.this.getAnimationTick() < 19 && target != null) {
                    Ender_Golem_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                } else {
                    Ender_Golem_Entity.this.field_70177_z = Ender_Golem_Entity.this.field_70126_B;
                }
            }
            if (Ender_Golem_Entity.this.getAnimation() == VOID_RUNE_ATTACK) {
                if (Ender_Golem_Entity.this.getAnimationTick() < 22 && target != null) {
                    Ender_Golem_Entity.this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                } else {
                    Ender_Golem_Entity.this.field_70177_z = Ender_Golem_Entity.this.field_70126_B;
                }
            }
        }
    }
}

