/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.common.entites;

import com.cgessinger.creaturesandbeasts.common.blocks.LizardEggBlock;
import com.cgessinger.creaturesandbeasts.common.config.CNBConfig;
import com.cgessinger.creaturesandbeasts.common.goals.AnimatedBreedGoal;
import com.cgessinger.creaturesandbeasts.common.init.ModBlockRegistry;
import com.cgessinger.creaturesandbeasts.common.init.ModEntityTypes;
import com.cgessinger.creaturesandbeasts.common.init.ModItems;
import com.cgessinger.creaturesandbeasts.common.interfaces.IAnimationHolder;
import com.cgessinger.creaturesandbeasts.common.interfaces.IModNetable;
import com.cgessinger.creaturesandbeasts.common.items.AppleSliceItem;
import com.cgessinger.creaturesandbeasts.common.util.AnimationHandler;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.JukeboxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class LizardEntity
extends AnimalEntity
implements IAnimatable,
IModNetable,
IAnimationHolder<LizardEntity> {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final DataParameter<Boolean> PARTYING = EntityDataManager.func_187226_a(LizardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SAD = EntityDataManager.func_187226_a(LizardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> LIZARD_VARIANT = EntityDataManager.func_187226_a(LizardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> LAY_EGG = EntityDataManager.func_187226_a(LizardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public BlockPos jukeboxPosition;
    private final AnimationHandler<LizardEntity> animationHandler;

    public LizardEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70749_g = new LookController((MobEntity)this){

            public void func_75649_a() {
                LizardEntity lizard = (LizardEntity)this.field_75659_a;
                if (lizard.shouldLookAround()) {
                    super.func_75649_a();
                }
            }
        };
        this.animationHandler = new AnimationHandler<LizardEntity>("breed_controller", this, 110, 1, 0, LAY_EGG);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LIZARD_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(PARTYING, (Object)false);
        this.field_70180_af.func_187214_a(SAD, (Object)false);
        this.field_70180_af.func_187214_a(LAY_EGG, (Object)false);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        int variant;
        boolean forceNotSad = false;
        if (dataTag != null && dataTag.func_74764_b("variant")) {
            variant = dataTag.func_74762_e("variant");
            forceNotSad = true;
        } else {
            Biome.Category biomeCategory = worldIn.func_226691_t_(this.func_233580_cy_()).func_201856_r();
            variant = this.getLizardTypeFromBiome(biomeCategory);
        }
        this.setVariant(variant);
        this.setSad(!forceNotSad && this.func_70681_au().nextInt(10) == 1);
        if (dataTag != null && dataTag.func_74764_b("health")) {
            this.func_70606_j(dataTag.func_74760_g("health"));
        }
        if (dataTag != null && dataTag.func_74764_b("name")) {
            this.func_200203_b(ITextComponent.func_244388_a((String)dataTag.func_74779_i("name")));
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70636_d() {
        if (this.jukeboxPosition != null) {
            TileEntity te = this.field_70170_p.func_175625_s(this.jukeboxPosition);
            if (!this.jukeboxPosition.func_218137_a((IPosition)this.func_213303_ch(), 10.0) || !(te instanceof JukeboxTileEntity) || ((JukeboxTileEntity)te).func_195537_c() == ItemStack.field_190927_a) {
                this.setPartying(false, null);
            }
        }
        if (this.isPartying() || ((Boolean)this.field_70180_af.func_187225_a(LAY_EGG)).booleanValue()) {
            this.field_70699_by.func_75499_g();
            this.func_70661_as().func_75489_a(0.0);
        }
        super.func_70636_d();
        this.animationHandler.process();
        if (this.func_70089_S() && ((Boolean)this.field_70180_af.func_187225_a(LAY_EGG)).booleanValue() && this.field_70173_aa % 10 == 0) {
            BlockPos blockpos = this.func_233580_cy_().func_177977_b();
            this.field_70170_p.func_217379_c(2001, blockpos, Block.func_196246_j((BlockState)this.field_70170_p.func_180495_p(blockpos)));
        }
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (((Boolean)this.field_70180_af.func_187225_a(LAY_EGG)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("lizard.dig", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (!(this.field_70721_aZ > -0.15f) || !(this.field_70721_aZ < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("lizard.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.isPartying()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("lizard.dance", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
        this.setPartying(false, null);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ActionResultType result = super.func_230254_b_(player, hand);
        ItemStack item = player.func_184586_b(hand);
        if (item.func_77973_b() instanceof AppleSliceItem && this.isSad()) {
            this.setSad(false);
            item.func_190918_g(player.field_71075_bZ.field_75098_d ? 0 : 1);
            this.spawnParticles((IParticleData)ParticleTypes.field_197633_z);
            return ActionResultType.SUCCESS;
        }
        return result;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(3, new AnimatedBreedGoal<LizardEntity>(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0){

            public boolean func_75250_a() {
                return !((LizardEntity)this.field_75457_a).isPartying() && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233821_d_, 0.4);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity entity) {
        LizardEntity baby = (LizardEntity)((EntityType)ModEntityTypes.LIZARD.get()).func_200721_a((World)world);
        baby.setVariant(((LizardEntity)entity).getVariant());
        return baby;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("variant", this.getVariant());
        compound.func_74757_a("sad", this.isSad());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("variant")) {
            this.setVariant(compound.func_74762_e("variant"));
        }
        if (compound.func_74764_b("sad")) {
            this.setSad(compound.func_74767_n("sad"));
        }
    }

    public LizardType getLizardType() {
        return LizardType.values()[this.getVariant()];
    }

    public int getLizardTypeFromBiome(Biome.Category biomeCategory) {
        switch (biomeCategory) {
            case DESERT: 
            case MESA: {
                return this.func_70681_au().nextInt(2);
            }
            case JUNGLE: {
                return this.func_70681_au().nextInt(2) + 2;
            }
        }
        return this.func_70681_au().nextInt(4);
    }

    public int getVariant() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(LIZARD_VARIANT)), (int)0, (int)LizardType.values().length);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(LIZARD_VARIANT, (Object)variant);
    }

    public void setPartying(boolean isPartying, BlockPos jukeboxPos) {
        if (!this.isSad()) {
            this.field_70180_af.func_187227_b(PARTYING, (Object)isPartying);
            this.jukeboxPosition = jukeboxPos;
        }
    }

    public boolean isPartying() {
        return (Boolean)this.field_70180_af.func_187225_a(PARTYING);
    }

    public boolean isSad() {
        return (Boolean)this.field_70180_af.func_187225_a(SAD);
    }

    public void setSad(boolean sad) {
        this.field_70180_af.func_187227_b(SAD, (Object)sad);
    }

    public boolean shouldLookAround() {
        return !this.isPartying() && (Boolean)this.field_70180_af.func_187225_a(LAY_EGG) == false;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() instanceof AppleSliceItem;
    }

    public void spawnParticles(IParticleData data) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(data, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    @Override
    public ItemStack getItem() {
        if (!this.isSad() && !this.func_70631_g_()) {
            LizardType type = this.getLizardType();
            ItemStack stack = new ItemStack((IItemProvider)type.getItem());
            CompoundNBT nbt = stack.func_196082_o();
            nbt.func_74768_a("variant", Arrays.asList(LizardType.values()).indexOf((Object)type));
            nbt.func_74776_a("health", this.func_110143_aJ());
            if (this.func_145818_k_()) {
                nbt.func_74778_a("name", this.func_200201_e().getString());
            }
            return stack;
        }
        return null;
    }

    @Override
    public void spawnParticleFeedback() {
        this.spawnParticles((IParticleData)ParticleTypes.field_197632_y);
    }

    public void func_70623_bb() {
        if (!CNBConfig.ServerConfig.LIZARD_CONFIG.shouldExist) {
            this.func_70106_y();
            return;
        }
        super.func_70623_bb();
    }

    @Override
    public void executeBreakpoint(Optional<AnimationHandler.ExecutionData> data) {
        if (data.isPresent() && data.get().isBreedData) {
            ServerWorld world = data.get().world;
            LizardEntity lizardMate = (LizardEntity)data.get().entity;
            BlockState state = (BlockState)((BlockState)((BlockState)((Block)ModBlockRegistry.LIZARD_EGGS.get()).func_176223_P().func_206870_a((Property)LizardEggBlock.EGGS, (Comparable)Integer.valueOf(this.field_70146_Z.nextInt(4) + 3))).func_206870_a((Property)LizardEggBlock.VARIANT_0, (Comparable)Integer.valueOf(this.getVariant()))).func_206870_a((Property)LizardEggBlock.VARIANT_1, (Comparable)Integer.valueOf(lizardMate.getVariant()));
            world.func_180501_a(this.func_233580_cy_(), state, 3);
        }
    }

    @Override
    public AnimationHandler<LizardEntity> getAnimationHandler(String name) {
        return this.animationHandler;
    }

    public static boolean canLizardSpawn(EntityType<LizardEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_226659_b_(pos, 0) > 8;
    }

    public static enum LizardType {
        DESERT_1(LizardType.createLocation("textures/model/entity/lizard/lizard_desert.png"), LizardType.createLocation("textures/model/entity/lizard/sad_lizard_desert.png"), (Item)ModItems.LIZARD_ITEM_0.get()),
        DESERT_2(LizardType.createLocation("textures/model/entity/lizard/lizard_desert_2.png"), LizardType.createLocation("textures/model/entity/lizard/sad_lizard_desert_2.png"), (Item)ModItems.LIZARD_ITEM_1.get()),
        JUNGLE_1(LizardType.createLocation("textures/model/entity/lizard/lizard_jungle.png"), LizardType.createLocation("textures/model/entity/lizard/sad_lizard_jungle.png"), (Item)ModItems.LIZARD_ITEM_2.get()),
        JUNGLE_2(LizardType.createLocation("textures/model/entity/lizard/lizard_jungle_2.png"), LizardType.createLocation("textures/model/entity/lizard/sad_lizard_jungle_2.png"), (Item)ModItems.LIZARD_ITEM_3.get());

        public final ResourceLocation textureLocation;
        public final ResourceLocation textureLocationSad;
        public final Item item;

        private LizardType(ResourceLocation tl, ResourceLocation tls, Item it) {
            this.textureLocation = tl;
            this.textureLocationSad = tls;
            this.item = it;
        }

        private static ResourceLocation createLocation(String pathPart) {
            return new ResourceLocation("cnb", pathPart);
        }

        public ResourceLocation getTextureLocation(boolean sad) {
            if (sad) {
                return this.textureLocationSad;
            }
            return this.textureLocation;
        }

        public Item getItem() {
            return this.item;
        }
    }
}

