/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.common.entites;

import com.cgessinger.creaturesandbeasts.common.config.CNBConfig;
import com.cgessinger.creaturesandbeasts.common.goals.GoToWaterGoal;
import com.cgessinger.creaturesandbeasts.common.goals.MountAdultGoal;
import com.cgessinger.creaturesandbeasts.common.goals.SmoothSwimGoal;
import com.cgessinger.creaturesandbeasts.common.init.ModEntityTypes;
import com.cgessinger.creaturesandbeasts.common.init.ModSoundEventTypes;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GrebeEntity
extends AnimalEntity {
    private final UUID healthReductionUUID = UUID.fromString("189faad9-35de-4e15-a598-82d147b996d7");
    private final float babyHealth = 5.0f;
    private static final DataParameter<BlockPos> TRAVEL_POS = EntityDataManager.func_187226_a(GrebeEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    public static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX, Items.field_196088_aY});
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;

    public GrebeEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 10.0f);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableEntity.AgeableData(0.6f);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new MountAdultGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new SmoothSwimGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new PanicGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new SwimTravelGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new WanderGoal(this, 1.0, 2));
        this.field_70714_bg.func_75776_a(5, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(5, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new GoToWaterGoal(this, 0.8));
    }

    public void func_70873_a(int age) {
        super.func_70873_a(age);
        double MAX_HEALTH = this.func_110148_a(Attributes.field_233818_a_).func_111126_e();
        if (this.func_70631_g_()) {
            Objects.requireNonNull(this);
            if (MAX_HEALTH > 5.0) {
                HashMultimap multimap = HashMultimap.create();
                Objects.requireNonNull(this);
                multimap.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(this.healthReductionUUID, "yeti_health_reduction", 5.0 - MAX_HEALTH, AttributeModifier.Operation.ADDITION));
                this.func_233645_dx_().func_233793_b_((Multimap)multimap);
                this.func_70606_j(this.babyHealth);
            }
        }
    }

    protected void func_175500_n() {
        this.func_184210_p();
        this.func_110148_a(Attributes.field_233818_a_).func_188479_b(this.healthReductionUUID);
        this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E || this.func_70090_H() || this.func_184218_aH() ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f && !this.func_70090_H() && !this.func_184218_aH()) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta *= 0.9f;
        Vector3d motion = this.func_213322_ci();
        if (!this.field_70122_E && motion.field_72448_b < 0.0) {
            this.func_213317_d(motion.func_216372_d(1.0, 0.6, 1.0));
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)((EntityType)ModEntityTypes.LITTLE_GREBE.get()).func_200721_a((World)p_241840_1_);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected float func_70599_aP() {
        return 0.6f;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70631_g_()) {
            return (SoundEvent)ModSoundEventTypes.LITTLE_GREBE_CHICK_AMBIENT.get();
        }
        return (SoundEvent)ModSoundEventTypes.LITTLE_GREBE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEventTypes.LITTLE_GREBE_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEventTypes.LITTLE_GREBE_HURT.get();
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.3;
    }

    public void func_70108_f(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!this.func_184223_x(entityIn) && !entityIn.field_70145_X && !this.field_70145_X && (d2 = MathHelper.func_76132_a((double)(d0 = entityIn.func_226277_ct_() - this.func_226277_ct_()), (double)(d1 = entityIn.func_226281_cx_() - this.func_226281_cx_()))) >= 0.01) {
            double d3 = 1.0 / (d2 = (double)MathHelper.func_76133_a((double)d2));
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 = d0 / d2 * d3 * 0.05 - (double)this.field_70144_Y;
            d1 = d1 / d2 * d3 * 0.05 - (double)this.field_70144_Y;
            this.func_70024_g(-d0, 0.0, -d1);
            if (!entityIn.func_184207_aI()) {
                entityIn.func_70024_g(d0, 0.0, d1);
            }
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    private BlockPos getTravelPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(TRAVEL_POS);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TRAVEL_POS, (Object)new BlockPos(0, 2, 0));
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.1f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public void func_70623_bb() {
        if (!CNBConfig.ServerConfig.GREBE_CONFIG.shouldExist) {
            this.func_70106_y();
            return;
        }
        super.func_70623_bb();
    }

    public static boolean canGrebeSpawn(EntityType<GrebeEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_226659_b_(pos, 0) > 8;
    }

    static class SwimTravelGoal
    extends Goal {
        private final GrebeEntity turtle;
        private final double speed;
        private boolean field_203139_c;

        SwimTravelGoal(GrebeEntity turtle, double speedIn) {
            this.turtle = turtle;
            this.speed = speedIn;
        }

        public boolean func_75250_a() {
            return this.turtle.func_70090_H();
        }

        public void func_75249_e() {
            this.field_203139_c = false;
        }

        public void func_75246_d() {
            if (this.turtle.func_70661_as().func_75500_f()) {
                int j;
                int i;
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)this.turtle.getTravelPos());
                Vector3d vector3d1 = RandomPositionGenerator.func_203155_a((CreatureEntity)this.turtle, (int)16, (int)3, (Vector3d)vector3d, (double)0.3141592741012573);
                if (vector3d1 == null) {
                    vector3d1 = RandomPositionGenerator.func_75464_a((CreatureEntity)this.turtle, (int)8, (int)7, (Vector3d)vector3d);
                }
                if (vector3d1 != null && !this.turtle.field_70170_p.func_217344_a((i = MathHelper.func_76128_c((double)vector3d1.field_72450_a)) - 34, 0, (j = MathHelper.func_76128_c((double)vector3d1.field_72449_c)) - 34, i + 34, 0, j + 34)) {
                    vector3d1 = null;
                }
                if (vector3d1 == null) {
                    this.field_203139_c = true;
                    return;
                }
                this.turtle.func_70661_as().func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, this.speed);
            }
        }

        public boolean func_75253_b() {
            return !this.turtle.func_70661_as().func_75500_f() && !this.field_203139_c && !this.turtle.func_70880_s();
        }
    }

    static class WanderGoal
    extends RandomWalkingGoal {
        private WanderGoal(GrebeEntity entity, double speedIn, int chance) {
            super((CreatureEntity)entity, speedIn, chance);
        }

        public boolean func_75250_a() {
            return !this.field_75457_a.func_70090_H() && super.func_75250_a();
        }
    }
}

