/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.common.entites;

import com.cgessinger.creaturesandbeasts.common.config.CNBConfig;
import com.cgessinger.creaturesandbeasts.common.entites.AbstractSporelingEntity;
import com.cgessinger.creaturesandbeasts.common.init.ModSoundEventTypes;
import com.cgessinger.creaturesandbeasts.common.interfaces.IAnimationHolder;
import com.cgessinger.creaturesandbeasts.common.util.AnimationHandler;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class FriendlySporelingEntity
extends AbstractSporelingEntity
implements IAnimationHolder<FriendlySporelingEntity> {
    private static final DataParameter<Boolean> WAVE = EntityDataManager.func_187226_a(FriendlySporelingEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> INSPECT = EntityDataManager.func_187226_a(FriendlySporelingEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public final AnimationHandler<FriendlySporelingEntity> animationHandler;

    public FriendlySporelingEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_98053_h(true);
        this.animationHandler = new AnimationHandler<FriendlySporelingEntity>("trade_controller", this, 40, 1, 0, INSPECT);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (((Boolean)this.field_70180_af.func_187225_a(WAVE)).booleanValue()) {
            this.field_70699_by.func_75499_g();
            this.func_70661_as().func_75489_a(0.0);
        }
        this.animationHandler.process();
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setSporelingType(this.func_70681_au().nextInt(2));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaveGoal(this, PlayerEntity.class, 8.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WAVE, (Object)false);
        this.field_70180_af.func_187214_a(INSPECT, (Object)false);
    }

    public void setWave(boolean wave) {
        this.field_70180_af.func_187227_b(WAVE, (Object)wave);
    }

    @Override
    public <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (super.animationPredicate(event) == PlayState.STOP) {
            if (((Boolean)this.field_70180_af.func_187225_a(WAVE)).booleanValue() && this.getHolding() == ItemStack.field_190927_a) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("sporeling.wave", Boolean.valueOf(false)));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEventTypes.SPORELING_OVERWORLD_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEventTypes.SPORELING_OVERWORLD_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEventTypes.SPORELING_OVERWORLD_AMBIENT.get();
    }

    public void func_70623_bb() {
        if (!CNBConfig.ServerConfig.FRIENDLY_SPORELING_CONFIG.shouldExist) {
            this.func_70106_y();
            return;
        }
        super.func_70623_bb();
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.func_92059_d();
        if (this.func_213365_e(stack) && this.animationHandler.canStart()) {
            this.func_233630_a_(itemEntity);
            this.func_184201_a(EquipmentSlotType.MAINHAND, stack);
            this.setHolding(stack);
            itemEntity.func_70106_y();
            this.animationHandler.startAnimation(AnimationHandler.ExecutionData.create().withItemStack(stack).build());
        }
    }

    public boolean func_213365_e(ItemStack itemstackIn) {
        if (!this.func_190630_a(EquipmentSlotType.MAINHAND)) {
            if (itemstackIn.func_77948_v()) {
                for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)itemstackIn).entrySet()) {
                    if (!((Enchantment)entry.getKey()).func_190936_d()) continue;
                    return true;
                }
            }
            return itemstackIn.func_77973_b() == Items.field_221582_j;
        }
        return false;
    }

    @Override
    public void executeBreakpoint(Optional<AnimationHandler.ExecutionData> data) {
        if (!data.isPresent()) {
            return;
        }
        ItemStack stack = data.get().stack;
        if (stack != null) {
            if (stack.func_77948_v()) {
                Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
                for (Map.Entry entry : map.entrySet()) {
                    if (!((Enchantment)entry.getKey()).func_190936_d()) continue;
                    map.remove(entry.getKey(), entry.getValue());
                    if (stack.func_77984_f()) {
                        float percent = this.func_70681_au().nextFloat() * 0.8f + 0.1f;
                        int damage = (int)(percent * (float)stack.func_77958_k() + (float)stack.func_77952_i());
                        int setDamage = Math.min(damage, (int)((float)stack.func_77958_k() * 0.9f));
                        stack.func_196085_b(Math.max(stack.func_77952_i(), setDamage));
                    }
                    EnchantmentHelper.func_82782_a((Map)map, (ItemStack)stack);
                    break;
                }
            } else if (stack.func_77973_b() == Items.field_221582_j) {
                stack = new ItemStack((IItemProvider)Items.field_221814_dq, stack.func_190916_E());
            }
            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            this.setHolding(ItemStack.field_190927_a);
            this.func_199701_a_(stack);
        }
    }

    @Override
    public AnimationHandler<FriendlySporelingEntity> getAnimationHandler(String name) {
        return this.animationHandler;
    }

    public static boolean canSporelingSpawn(EntityType<FriendlySporelingEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_226659_b_(pos, 0) > 8;
    }

    static class WaveGoal
    extends LookAtGoal {
        private final FriendlySporelingEntity sporeling;
        private int waveTimer;

        public WaveGoal(FriendlySporelingEntity entityIn, Class<? extends LivingEntity> watchTargetClass, float maxDistance) {
            super((MobEntity)entityIn, watchTargetClass, maxDistance);
            this.sporeling = entityIn;
            this.waveTimer = 0;
        }

        public boolean func_75250_a() {
            boolean shouldExec = super.func_75250_a();
            if (shouldExec && this.waveTimer == 0 && this.sporeling.func_70681_au().nextInt(9) == 0) {
                this.waveTimer = 8;
            } else if (this.waveTimer > 0 && this.field_75334_a != null) {
                this.sporeling.setWave(--this.waveTimer > 0);
            }
            return shouldExec;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.sporeling.func_70671_ap().func_180424_b();
        }
    }
}

