/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.item;

import ejektaflex.bountiful.BountifulConfig;
import ejektaflex.bountiful.BountifulContent;
import ejektaflex.bountiful.data.bounty.BountyData;
import ejektaflex.bountiful.data.bounty.checkers.CheckerRegistry;
import ejektaflex.bountiful.data.bounty.enums.BountyNBT;
import ejektaflex.bountiful.data.bounty.enums.BountyRarity;
import ejektaflex.bountiful.data.registry.DecreeRegistry;
import ejektaflex.bountiful.data.structure.Decree;
import ejektaflex.bountiful.ext.ExtMiscKt;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 42\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002:\u000234B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J,\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J0\u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0010H\u0016J&\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070(2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u0014H\u0016J(\u0010+\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010.\u001a\u00020%H\u0016J \u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0010H\u0016\u00a8\u00065"}, d2={"Lejektaflex/bountiful/item/ItemBounty;", "Lnet/minecraft/item/Item;", "Lnet/minecraftforge/registries/IForgeRegistryEntry;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "cashIn", "", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "ensureBounty", "decrees", "", "Lejektaflex/bountiful/data/structure/Decree;", "rarity", "Lejektaflex/bountiful/data/bounty/enums/BountyRarity;", "ensureTimerStarted", "getDisplayName", "getRarity", "Lnet/minecraft/item/Rarity;", "getTranslationKey", "", "inventoryTick", "entityIn", "Lnet/minecraft/entity/Entity;", "itemSlot", "", "isSelected", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "playerIn", "handIn", "onUse", "livingEntityIn", "Lnet/minecraft/entity/LivingEntity;", "count", "shouldCauseReequipAnimation", "oldStack", "newStack", "slotChanged", "BountyCreationException", "Companion", "Bountiful"})
public final class ItemBounty
extends Item
implements IForgeRegistryEntry<Item> {
    private static final Random rand;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String func_77658_a() {
        return "bountiful.bounty";
    }

    @NotNull
    public ITextComponent func_200295_i(@NotNull ItemStack stack) {
        ITextComponent iTextComponent;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (BountyData.Companion.isValidBounty(stack)) {
            ItemStack $this$toData$iv = stack;
            boolean $i$f$toData = false;
            boolean bl = false;
            BountyData bountyData = new BountyData();
            boolean bl2 = false;
            boolean bl3 = false;
            INBTSerializable $this$apply$iv = bountyData;
            boolean bl4 = false;
            ItemStack itemStack = $this$toData$iv.getStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"stack");
            $this$apply$iv.deserializeNBT((INBT)itemStack.func_77978_p());
            BountyData bd = (BountyData)((INBTSerializable)bountyData);
            TranslationTextComponent translationTextComponent = new TranslationTextComponent("bountiful.rarity." + bd.getRarityEnum().name());
            boolean bl5 = false;
            boolean bl6 = false;
            TranslationTextComponent $this$apply = translationTextComponent;
            boolean bl7 = false;
            $this$apply.func_230529_a_((ITextComponent)new StringTextComponent(" "));
            $this$apply.func_230529_a_(super.func_200295_i(stack));
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientWorld clientWorld = Minecraft.func_71410_x().field_71441_e;
                if (clientWorld != null) {
                    ClientWorld clientWorld2 = clientWorld;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    ClientWorld world = clientWorld2;
                    boolean bl10 = false;
                    StringBuilder stringBuilder = new StringBuilder().append(" \u00a7f(");
                    ClientWorld clientWorld3 = world;
                    Intrinsics.checkNotNullExpressionValue((Object)clientWorld3, (String)"world");
                    $this$apply.func_230529_a_((ITextComponent)new StringTextComponent(stringBuilder.append(bd.remainingTime((World)clientWorld3)).append("\u00a7f)").toString()));
                }
            }
            iTextComponent = (ITextComponent)translationTextComponent;
        } else {
            ITextComponent iTextComponent2 = super.func_200295_i(stack);
            iTextComponent = iTextComponent2;
            Intrinsics.checkNotNullExpressionValue((Object)iTextComponent2, (String)"super.getDisplayName(stack)");
        }
        return iTextComponent;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, @NotNull PlayerEntity playerIn, @NotNull Hand handIn) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        Intrinsics.checkNotNullParameter((Object)handIn, (String)"handIn");
        if (worldIn.func_201670_d()) {
            ActionResult actionResult = super.func_77659_a(worldIn, playerIn, handIn);
            Intrinsics.checkNotNullExpressionValue((Object)actionResult, (String)"super.onItemRightClick(worldIn, playerIn, handIn)");
            return actionResult;
        }
        if (!((Boolean)BountifulConfig.Companion.getSERVER().getCashInAtBountyBoard().get()).booleanValue()) {
            this.cashIn(playerIn, handIn);
        } else {
            ExtMiscKt.sendTranslation((Entity)playerIn, "bountiful.bounty.turnin");
        }
        ActionResult actionResult = super.func_77659_a(worldIn, playerIn, handIn);
        Intrinsics.checkNotNullExpressionValue((Object)actionResult, (String)"super.onItemRightClick(worldIn, playerIn, handIn)");
        return actionResult;
    }

    public void func_219972_a(@NotNull World worldIn, @NotNull LivingEntity livingEntityIn, @NotNull ItemStack stack, int count) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)livingEntityIn, (String)"livingEntityIn");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (worldIn.field_72995_K) {
            super.func_219972_a(worldIn, livingEntityIn, stack, count);
            return;
        }
        if (!((Boolean)BountifulConfig.Companion.getSERVER().getCashInAtBountyBoard().get()).booleanValue()) {
            // empty if block
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)flagIn, (String)"flagIn");
        if (stack.func_77942_o()) {
            ItemStack $this$toData$iv = stack;
            boolean $i$f$toData = false;
            boolean bl = false;
            BountyData bountyData = new BountyData();
            boolean bl2 = false;
            boolean bl3 = false;
            INBTSerializable $this$apply$iv = bountyData;
            boolean bl4 = false;
            ItemStack itemStack = $this$toData$iv.getStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"stack");
            $this$apply$iv.deserializeNBT((INBT)itemStack.func_77978_p());
            BountyData bounty = (BountyData)((INBTSerializable)bountyData);
            World world = worldIn;
            Intrinsics.checkNotNull((Object)world);
            ClientPlayerEntity clientPlayerEntity = Minecraft.func_71410_x().field_71439_g;
            List<ITextComponent> bountyTipInfo = bounty.tooltipInfo(world, clientPlayerEntity != null && clientPlayerEntity.func_225608_bj_());
            for (ITextComponent line : bountyTipInfo) {
                tooltip.add(line);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Rarity func_77613_e(@NotNull ItemStack stack) {
        Rarity rarity;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.func_77942_o()) {
            CompoundNBT compoundNBT = stack.func_77978_p();
            Intrinsics.checkNotNull((Object)compoundNBT);
            if (compoundNBT.func_74764_b(BountyNBT.Rarity.getKey())) {
                CompoundNBT compoundNBT2 = stack.func_77978_p();
                Intrinsics.checkNotNull((Object)compoundNBT2);
                rarity = BountyRarity.Companion.getRarityFromInt(compoundNBT2.func_74762_e(BountyNBT.Rarity.getKey())).getItemRarity();
                return rarity;
            }
        }
        Rarity rarity2 = super.func_77613_e(stack);
        rarity = rarity2;
        Intrinsics.checkNotNullExpressionValue((Object)rarity2, (String)"super.getRarity(stack)");
        return rarity;
    }

    public final void ensureTimerStarted(@NotNull ItemStack stack, @NotNull World worldIn) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        if (stack.func_77973_b() instanceof ItemBounty && stack.func_77942_o()) {
            CompoundNBT compoundNBT = stack.func_77978_p();
            Intrinsics.checkNotNull((Object)compoundNBT);
            if (!compoundNBT.func_74764_b(BountyNBT.BountyStamp.getKey())) {
                CompoundNBT compoundNBT2 = stack.func_77978_p();
                Intrinsics.checkNotNull((Object)compoundNBT2);
                compoundNBT2.func_74772_a(BountyNBT.BountyStamp.getKey(), worldIn.func_82737_E());
            }
        }
    }

    public void func_77663_a(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)entityIn, (String)"entityIn");
        if (!worldIn.field_72995_K && worldIn.func_82737_E() % 20L == 3L) {
            this.ensureTimerStarted(stack, worldIn);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureBounty(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull List<Decree> decrees, @NotNull BountyRarity rarity) {
        BountyData bountyData;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter(decrees, (String)"decrees");
        Intrinsics.checkNotNullParameter((Object)((Object)rarity), (String)"rarity");
        try {
            bountyData = BountyData.Companion.create(rarity, decrees);
        }
        catch (BountyCreationException e) {
            return;
        }
        BountyData data = bountyData;
        if (stack.func_77973_b() instanceof ItemBounty) {
            if (!stack.func_77942_o()) {
                void $this$apply;
                bountyData = data.serializeNBT();
                boolean bl = false;
                boolean bl2 = false;
                BountyData bountyData2 = bountyData;
                ItemStack itemStack = stack;
                boolean bl3 = false;
                $this$apply.func_82580_o(BountyNBT.BountyStamp.getKey());
                $this$apply.func_74772_a(BountyNBT.BoardStamp.getKey(), worldIn.func_82737_E());
                Unit unit = Unit.INSTANCE;
                itemStack.func_77982_d((CompoundNBT)bountyData);
            }
        } else {
            throw (Throwable)new Exception(stack.func_200301_q() + " is not an ItemBounty, so you cannot generate bounty data for it!");
        }
    }

    public final boolean cashIn(@NotNull PlayerEntity player, @NotNull Hand hand2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand2, (String)"hand");
        ItemStack bountyItem = player.func_184586_b(hand2);
        if (!bountyItem.func_77942_o()) {
            ItemStack itemStack = player.func_184586_b(hand2);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"player.getHeldItem(hand)");
            World world = player.field_70170_p;
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"player.world");
            this.ensureBounty(itemStack, world, DecreeRegistry.INSTANCE.getContent(), Companion.calcRarity());
            return false;
        }
        ItemStack itemStack = bountyItem;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"bountyItem");
        ItemStack $this$toData$iv = itemStack;
        boolean $i$f$toData = false;
        boolean bl = false;
        BountyData bountyData = new BountyData();
        boolean bl2 = false;
        boolean bl3 = false;
        INBTSerializable $this$apply$iv = bountyData;
        boolean bl4 = false;
        ItemStack itemStack2 = $this$toData$iv.getStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"stack");
        $this$apply$iv.deserializeNBT((INBT)itemStack2.func_77978_p());
        BountyData bounty = (BountyData)((INBTSerializable)bountyData);
        World world = player.field_70170_p;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"player.world");
        if (bounty.hasExpired(world)) {
            ExtMiscKt.sendTranslation((Entity)player, "bountiful.bounty.expired");
            return false;
        }
        boolean succ = CheckerRegistry.INSTANCE.tryCashIn(player, bounty);
        if (succ) {
            bountyItem.func_190918_g(bountyItem.func_77976_d());
        } else {
            ExtMiscKt.sendTranslation((Entity)player, "bountiful.tooltip.requirements");
        }
        return false;
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        Intrinsics.checkNotNullParameter((Object)oldStack, (String)"oldStack");
        Intrinsics.checkNotNullParameter((Object)newStack, (String)"newStack");
        return slotChanged;
    }

    public ItemBounty() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f));
    }

    static {
        Companion = new Companion(null);
        rand = new Random();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lejektaflex/bountiful/item/ItemBounty$BountyCreationException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "err", "", "(Ljava/lang/String;)V", "Bountiful"})
    public static final class BountyCreationException
    extends Exception {
        public BountyCreationException(@NotNull String err) {
            Intrinsics.checkNotNullParameter((Object)err, (String)"err");
            super(err);
        }

        public /* synthetic */ BountyCreationException(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "Bounty could not be created!";
            }
            this(string);
        }

        public BountyCreationException() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lejektaflex/bountiful/item/ItemBounty$Companion;", "", "()V", "rand", "Ljava/util/Random;", "calcRarity", "Lejektaflex/bountiful/data/bounty/enums/BountyRarity;", "create", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "decrees", "", "Lejektaflex/bountiful/data/structure/Decree;", "Bountiful"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BountyRarity calcRarity() {
            int level = 0;
            Double chance = (Double)BountifulConfig.Companion.getSERVER().getRarityChance().get();
            int n = 0;
            int n2 = 3;
            while (n < n2) {
                void i;
                double d = rand.nextFloat();
                Double d2 = chance;
                Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"chance");
                if (!(d < d2)) break;
                ++level;
                ++i;
            }
            return BountyRarity.Companion.getRarityFromInt(level);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ItemStack create(@NotNull World world, @NotNull List<Decree> decrees) {
            void it;
            Item item;
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter(decrees, (String)"decrees");
            ItemStack itemStack = new ItemStack((IItemProvider)BountifulContent.INSTANCE.getBOUNTY());
            boolean bl = false;
            boolean bl2 = false;
            ItemStack $this$apply = itemStack;
            boolean bl3 = false;
            ItemStack $this$edit$iv = $this$apply;
            boolean $i$f$edit = false;
            if ($this$edit$iv.func_77973_b() instanceof ItemBounty) {
                item = $this$edit$iv.func_77973_b();
                if (item == null) {
                    throw new NullPointerException("null cannot be cast to non-null type ejektaflex.bountiful.item.ItemBounty");
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("Tried to edit stack ");
                ItemStack itemStack2 = $this$edit$iv.getStack();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"stack");
                StringBuilder stringBuilder2 = stringBuilder.append(itemStack2.func_190916_E()).append("x ");
                ItemStack itemStack3 = $this$edit$iv.getStack();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"stack");
                Item item2 = itemStack3.func_77973_b();
                Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"stack.item");
                throw (Throwable)new Exception(stringBuilder2.append(item2.getRegistryName()).append(" as if it was a ").append(Reflection.getOrCreateKotlinClass(ItemBounty.class)).toString());
            }
            ItemStack itemStack4 = $this$edit$iv;
            ItemBounty $this$edit = (ItemBounty)((Item)((ItemBounty)item));
            boolean bl4 = false;
            $this$edit.ensureBounty((ItemStack)it, world, decrees, Companion.calcRarity());
            return itemStack;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

