/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.bayou_blues.common.world.gen.feature;

import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.core.util.TreeUtil;
import com.mojang.serialization.Codec;
import com.teamaurora.bayou_blues.common.util.DirectionalBlockPos;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class WaterMegaCypressFeature
extends Feature<BaseTreeFeatureConfig> {
    public WaterMegaCypressFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos posIn, BaseTreeFeatureConfig config) {
        int z;
        int x;
        int i;
        boolean bald;
        int height = rand.nextInt(7) + 18;
        boolean bl = bald = rand.nextInt(15) == 0;
        if (posIn.func_177956_o() <= 0 || posIn.func_177956_o() + height > worldIn.func_217301_I() - 1) {
            return false;
        }
        int surfaceY = worldIn.func_205770_a(Heightmap.Type.OCEAN_FLOOR, posIn).func_177956_o();
        int waterY = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE, posIn).func_177956_o();
        if (waterY <= surfaceY) {
            return false;
        }
        BlockPos position = new BlockPos(posIn.func_177958_n(), waterY, posIn.func_177952_p());
        BlockPos bottom = new BlockPos(posIn.func_177958_n(), surfaceY, posIn.func_177952_p());
        for (BlockPos pos2 : BlockPos.func_218278_a((BlockPos)bottom, (BlockPos)bottom.func_177982_a(1, 0, 1))) {
            if (WaterMegaCypressFeature.isAirOrWaterOrLeaves((IWorldGenerationBaseReader)worldIn, pos2)) continue;
            return false;
        }
        ArrayList<DirectionalBlockPos> logs = new ArrayList<DirectionalBlockPos>();
        ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
        for (i = 0; i <= waterY - surfaceY; ++i) {
            for (x = -1; x <= 2; ++x) {
                for (z = -1; z <= 2; ++z) {
                    if (i == 0 && worldIn.func_204610_c(bottom.func_177982_a(x, -1, z)).func_206886_c() == Fluids.field_204546_a) {
                        return false;
                    }
                    logs.add(new DirectionalBlockPos(bottom.func_177982_a(x, i, z), Direction.UP));
                }
            }
        }
        for (i = 1; i <= height; ++i) {
            if (i <= 2) {
                for (x = -1; x <= 2; ++x) {
                    for (z = -1; z <= 2; ++z) {
                        if ((x == -1 || x == 2) && (z == -1 || z == 2)) continue;
                        logs.add(new DirectionalBlockPos(position.func_177982_a(x, i, z), Direction.UP));
                    }
                }
                continue;
            }
            logs.add(new DirectionalBlockPos(position.func_177981_b(i), Direction.UP));
            logs.add(new DirectionalBlockPos(position.func_177982_a(1, i, 0), Direction.UP));
            logs.add(new DirectionalBlockPos(position.func_177982_a(0, i, 1), Direction.UP));
            logs.add(new DirectionalBlockPos(position.func_177982_a(1, i, 1), Direction.UP));
        }
        int numBranches = rand.nextInt(5) + 4;
        for (int i2 = 0; i2 < numBranches; ++i2) {
            int y = bald ? rand.nextInt(height - 5) + 7 : rand.nextInt(height - 7) + 7;
            Direction dir = Direction.func_176731_b((int)rand.nextInt(4));
            if (dir == Direction.NORTH) {
                this.addBranch(position.func_177982_a(rand.nextInt(2), y, 0), dir, logs, leaves, rand);
                continue;
            }
            if (dir == Direction.EAST) {
                this.addBranch(position.func_177982_a(1, y, rand.nextInt(2)), dir, logs, leaves, rand);
                continue;
            }
            if (dir == Direction.SOUTH) {
                this.addBranch(position.func_177982_a(rand.nextInt(2), y, 1), dir, logs, leaves, rand);
                continue;
            }
            if (dir != Direction.WEST) continue;
            this.addBranch(position.func_177982_a(0, y, rand.nextInt(2)), dir, logs, leaves, rand);
        }
        if (bald) {
            int variant = rand.nextInt(4);
            switch (variant) {
                case 0: {
                    logs.add(new DirectionalBlockPos(position.func_177981_b(height + 1), Direction.UP));
                    break;
                }
                case 1: {
                    logs.add(new DirectionalBlockPos(position.func_177982_a(1, height + 1, 0), Direction.UP));
                    break;
                }
                case 2: {
                    logs.add(new DirectionalBlockPos(position.func_177982_a(0, height + 1, 1), Direction.UP));
                    break;
                }
                case 3: {
                    logs.add(new DirectionalBlockPos(position.func_177982_a(1, height + 1, 1), Direction.UP));
                }
            }
        } else {
            this.canopyDisc1(position.func_177981_b(height - 2), leaves);
            this.canopyDisc3Bottom(position.func_177981_b(height - 1), leaves, rand);
            this.canopyDisc3Top(position.func_177981_b(height), leaves);
            this.canopyDisc1(position.func_177981_b(height + 1), leaves);
        }
        List<BlockPos> leavesClean = this.cleanLeavesArray(leaves, logs);
        boolean flag = true;
        for (DirectionalBlockPos log : logs) {
            if (TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)log.pos) || worldIn.func_180495_p(log.pos).func_177230_c() == Blocks.field_150355_j) continue;
            flag = false;
        }
        if (!flag) {
            return false;
        }
        TreeUtil.setDirtAt((IWorld)worldIn, (BlockPos)position.func_177977_b());
        for (DirectionalBlockPos log : logs) {
            TreeUtil.placeDirectionalLogAt((IWorldWriter)worldIn, (BlockPos)log.pos, (Direction)log.direction, (Random)rand, (BaseTreeFeatureConfig)config);
        }
        for (BlockPos leaf : leavesClean) {
            TreeUtil.placeLeafAt((IWorldGenerationReader)worldIn, (BlockPos)leaf, (Random)rand, (BaseTreeFeatureConfig)config);
        }
        HashSet decSet = Sets.newHashSet();
        MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_78887_a();
        ArrayList<BlockPos> logsPos = new ArrayList<BlockPos>();
        for (DirectionalBlockPos log : logs) {
            logsPos.add(log.pos);
        }
        if (!config.field_227370_o_.isEmpty()) {
            logsPos.sort(Comparator.comparingInt(Vector3i::func_177956_o));
            leavesClean.sort(Comparator.comparingInt(Vector3i::func_177956_o));
            config.field_227370_o_.forEach(decorator -> decorator.func_225576_a_(worldIn, rand, logsPos, leavesClean, decSet, mutableBoundingBox));
        }
        return true;
    }

    private void addBranch(BlockPos pos, Direction dir, List<DirectionalBlockPos> logs, List<BlockPos> leaves, Random rand) {
        logs.add(new DirectionalBlockPos(pos.func_177972_a(dir), dir));
        logs.add(new DirectionalBlockPos(pos.func_177967_a(dir, 2), dir));
        this.disc2H(pos.func_177967_a(dir, 2), leaves, rand);
        this.disc1(pos.func_177967_a(dir, 2).func_177984_a(), leaves);
    }

    private void disc1(BlockPos pos, List<BlockPos> leaves) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                leaves.add(pos.func_177982_a(x, 0, z));
            }
        }
    }

    private void disc2H(BlockPos pos, List<BlockPos> leaves, Random rand) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                leaves.add(pos.func_177982_a(x, 0, z));
                if (rand.nextInt(3) != 0) continue;
                leaves.add(pos.func_177982_a(x, -1, z));
                if (rand.nextInt(3) != 0) continue;
                leaves.add(pos.func_177982_a(x, -2, z));
            }
        }
    }

    private void canopyDisc1(BlockPos pos, List<BlockPos> leaves) {
        for (int x = -1; x <= 2; ++x) {
            for (int z = -1; z <= 2; ++z) {
                if ((x == -1 || x == 2) && (z == -1 || z == 2)) continue;
                leaves.add(pos.func_177982_a(x, 0, z));
            }
        }
    }

    private void canopyDisc3Top(BlockPos pos, List<BlockPos> leaves) {
        for (int x = -3; x <= 4; ++x) {
            for (int z = -3; z <= 4; ++z) {
                if (!(x > -2 && x < 3 || z > -2 && z < 3) && (x != -2 && x != 3 || z != -2 && z != 3)) continue;
                leaves.add(pos.func_177982_a(x, 0, z));
            }
        }
    }

    private void canopyDisc3Bottom(BlockPos pos, List<BlockPos> leaves, Random rand) {
        for (int x = -3; x <= 4; ++x) {
            for (int z = -3; z <= 4; ++z) {
                if ((x == -3 || x == 4) && (z == -3 || z == 4)) continue;
                leaves.add(pos.func_177982_a(x, 0, z));
                if (!rand.nextBoolean()) continue;
                leaves.add(pos.func_177982_a(x, -1, z));
                if (rand.nextInt(3) == 0) continue;
                leaves.add(pos.func_177982_a(x, -2, z));
                if (!rand.nextBoolean()) continue;
                leaves.add(pos.func_177982_a(x, -3, z));
            }
        }
    }

    private List<BlockPos> cleanLeavesArray(List<BlockPos> leaves, List<DirectionalBlockPos> logs) {
        ArrayList<BlockPos> logsPos = new ArrayList<BlockPos>();
        for (DirectionalBlockPos log : logs) {
            logsPos.add(log.pos);
        }
        ArrayList<BlockPos> newLeaves = new ArrayList<BlockPos>();
        for (BlockPos leaf : leaves) {
            if (logsPos.contains(leaf)) continue;
            newLeaves.add(leaf);
        }
        return newLeaves;
    }

    public static boolean isAirOrWater(IWorldGenerationBaseReader world, BlockPos pos) {
        if (!(world instanceof IBlockReader)) {
            return world.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f) || world.func_217375_a(pos, state -> state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a));
        }
        return world.func_217375_a(pos, state -> state.isAir((IBlockReader)world, pos)) || world.func_217375_a(pos, state -> state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a));
    }

    public static boolean isAirOrWaterOrLeaves(IWorldGenerationBaseReader world, BlockPos pos) {
        if (world instanceof IWorldReader) {
            return world.func_217375_a(pos, state -> state.canBeReplacedByLeaves((IWorldReader)world, pos)) || world.func_217375_a(pos, state -> state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a));
        }
        return world.func_217375_a(pos, state -> WaterMegaCypressFeature.isAirOrWater(world, pos) || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }
}

