/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs.tempshelf;

import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import net.darkhax.badmobs.BadMobs;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigManager {
    private final ModContainer owner;
    private final ModConfig.Type type;
    private final String name;
    private final ForgeConfigSpec spec;
    private final ModConfig config;
    private boolean forgeRegistered = false;

    public ConfigManager(ForgeConfigSpec spec) {
        this(ModConfig.Type.COMMON, spec);
    }

    public ConfigManager(ModConfig.Type type, ForgeConfigSpec spec) {
        this(ModLoadingContext.get().getActiveContainer(), type, spec);
    }

    public ConfigManager(ModContainer owner, ModConfig.Type type, ForgeConfigSpec spec) {
        this(owner, type, ConfigManager.defaultConfigName(type, owner.getModId()), spec);
    }

    public ConfigManager(ModContainer owner, ModConfig.Type type, String name, ForgeConfigSpec spec) {
        this.owner = owner;
        this.type = type;
        this.name = name;
        this.spec = spec;
        this.config = new ModConfig(this.type, this.spec, this.owner, this.name);
    }

    public ConfigManager open() {
        try {
            ObfuscationReflectionHelper.findMethod(ConfigTracker.class, (String)"openConfig", (Class[])new Class[]{ModConfig.class, Path.class}).invoke((Object)ConfigTracker.INSTANCE, this.config, FMLPaths.CONFIGDIR.get());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            BadMobs.LOG.catching((Throwable)e);
        }
        return this;
    }

    public ConfigManager registerWithForge() {
        if (!this.forgeRegistered) {
            this.owner.addConfig(this.config);
            this.forgeRegistered = true;
            return this;
        }
        throw new IllegalStateException("The config " + this.config.getFileName() + " has already been registered with Forge.");
    }

    private static String defaultConfigName(ModConfig.Type type, String modId) {
        return String.format("%s-%s.toml", modId, type.extension());
    }
}

