/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs;

import net.darkhax.badmobs.config.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="badmobs")
public class BadMobs {
    public static final Logger LOG = LogManager.getLogger((String)"Bad Mobs");
    private Configuration config;

    public BadMobs() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLLoadCompleteEvent event) {
        this.config = new Configuration();
        MinecraftForge.EVENT_BUS.addListener(this::checkSpawn);
        MinecraftForge.EVENT_BUS.addListener(this::specialSpawn);
        MinecraftForge.EVENT_BUS.addListener(this::entityJoinWorld);
    }

    private void checkSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (!this.config.allowSpawn(event.getEntity(), event.getSpawnReason())) {
            event.getEntity().func_70106_y();
            event.setResult(Event.Result.DENY);
        }
    }

    private void specialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (!this.config.allowSpawn(event.getEntity(), event.getSpawnReason())) {
            event.getEntity().func_70106_y();
            event.setCanceled(true);
        }
    }

    private void entityJoinWorld(EntityJoinWorldEvent event) {
        if (!this.config.allowSpawn(event.getEntity(), null)) {
            event.getEntity().func_70106_y();
            event.setCanceled(true);
            LOG.info("Forcefully removed {}.", (Object)event.getEntity());
        }
    }
}

