/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtil {
    private static Minecraft getMinecraft() {
        return Minecraft.func_71410_x();
    }

    public static ItemRenderer getItemRenderer() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    public static void renderItemIntoGui(IItemProvider itemProvider, MatrixStack matrixStack, int xPos, int yPos) {
        RenderUtil.renderItemIntoGuiScaled(itemProvider, matrixStack, xPos, yPos, 1);
    }

    public static void renderItemIntoGuiScaled(IItemProvider itemProvider, MatrixStack matrixStack, int xPos, int yPos, int scale) {
        ItemRenderer itemRenderer = RenderUtil.getItemRenderer();
        matrixStack.func_227860_a_();
        RenderSystem.enableDepthTest();
        RenderHelper.func_227780_a_();
        if (scale != 1) {
            matrixStack.func_227862_a_((float)scale, (float)scale, (float)scale);
        }
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        itemRenderer.func_180450_b(new ItemStack(itemProvider), xPos, yPos);
        RenderSystem.popMatrix();
        RenderHelper.func_74518_a();
        RenderSystem.disableDepthTest();
        matrixStack.func_227865_b_();
    }

    private static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    private static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    private static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    private static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void resetColor() {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setColor4f(int color) {
        RenderSystem.color4f((float)RenderUtil.getRed(color), (float)RenderUtil.getGreen(color), (float)RenderUtil.getBlue(color), (float)RenderUtil.getAlpha(color));
    }

    public static void setColor3f(int color) {
        RenderSystem.color3f((float)RenderUtil.getRed(color), (float)RenderUtil.getGreen(color), (float)RenderUtil.getBlue(color));
    }

    public static int getDefaultTextColor() {
        return 0x404040;
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        RenderUtil.getMinecraft().func_110434_K().func_110577_a(resourceLocation);
    }
}

