/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.util;

import com.thenatekirby.babel.core.MutableResourceLocation;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.ModList;

public class ModUtil {
    public static boolean isModLoaded(@Nonnull String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static boolean isModLoaded(@Nonnull MutableResourceLocation mod) {
        return ModUtil.isModLoaded(mod.getRoot());
    }

    public static boolean isAnyModLoaded(MutableResourceLocation ... mods) {
        for (MutableResourceLocation mod : mods) {
            if (!ModUtil.isModLoaded(mod.getRoot())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T> T callIfModLoaded(@Nonnull String modId, Supplier<Callable<T>> supplier) {
        try {
            if (ModUtil.isModLoaded(modId)) {
                return supplier.get().call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static void runIfModLoaded(@Nonnull String modId, Supplier<Runnable> supplier) {
        try {
            if (ModUtil.isModLoaded(modId)) {
                supplier.get().run();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

