/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.thenatekirby.babel.api.IProgress;
import com.thenatekirby.babel.core.gui.GuiRenderer;
import com.thenatekirby.babel.gui.GuiWidget;
import com.thenatekirby.babel.mod.BabelTextureLocations;
import com.thenatekirby.babel.util.RenderUtil;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class VerticalBarGuiWidget
extends GuiWidget {
    private static final ResourceLocation GUI = BabelTextureLocations.GUI.COMPONENTS;
    private BarType barType;
    private ResourceLocation defaultLocation;
    private int textureX;
    private int textureY;
    private GuiRenderer renderer;
    private IProgress progressProvider;

    public VerticalBarGuiWidget(BarType barType, ResourceLocation defaultLocation, IProgress progressProvider, GuiRenderer renderer, int x, int y) {
        super(renderer.getGuiLeft() + x - 1, renderer.getGuiTop() + y - 1, 8, barType.height, NO_MESSAGE_COMPONENT);
        this.defaultLocation = defaultLocation;
        this.renderer = renderer;
        this.progressProvider = progressProvider;
        this.setBarType(barType);
        this.field_230693_o_ = false;
    }

    private void setBarType(BarType barType) {
        this.barType = barType;
        this.textureX = barType.textureX;
        this.textureY = barType.textureY;
    }

    public IProgress getProgressProvider() {
        return this.progressProvider;
    }

    public GuiRenderer getRenderer() {
        return this.renderer;
    }

    public void func_230431_b_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderUtil.bindTexture(GUI);
        if (this.progressProvider != null) {
            int progressHeight = (int)(this.progressProvider.getProgress() * (float)this.barType.height);
            int offset = this.barType.height - progressHeight;
            this.renderer.drawTexturedRect(matrixStack, this.field_230690_l_, this.field_230691_m_, this.textureX, this.textureY, this.field_230688_j_, this.field_230689_k_);
            this.renderer.drawTexturedRect(matrixStack, this.field_230690_l_, this.field_230691_m_ + offset, this.barType.fillOffsetX, this.textureY + (this.barType.height - progressHeight), this.field_230688_j_, progressHeight);
        }
        RenderUtil.bindTexture(this.defaultLocation);
    }

    public static enum BarType {
        EXPERIENCE(7, 62, 0, 18, 16, 0),
        POWER(7, 62, 0, 18, 8, 0);

        public int width;
        public int height;
        public int textureX;
        public int textureY;
        public int fillOffsetX;
        public int fillOffsetY;

        private BarType(int width, int height, int textureX, int textureY, int fillOffsetX, int fillOffsetY) {
            this.width = width;
            this.height = height;
            this.textureX = textureX;
            this.textureY = textureY;
            this.fillOffsetX = fillOffsetX;
            this.fillOffsetY = fillOffsetY;
        }
    }
}

