/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core.tileentity;

import com.thenatekirby.babel.core.inventory.ContainerInventory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BabelTileEntity
extends TileEntity {
    protected ContainerInventory inventory;
    private LazyOptional<IEnergyStorage> energyStorage = LazyOptional.empty();
    private LazyOptional<IItemHandler> itemHandler = LazyOptional.empty();
    private LazyOptional<IItemHandler> manualItemHandler = LazyOptional.empty();

    public BabelTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_226984_a_(@Nonnull World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        this.updateCapabilities();
    }

    protected void updateCapabilities() {
        this.energyStorage = this.inventory.getEnergyStorage().getCapacity() > 0 ? LazyOptional.of(() -> this.inventory.getEnergyStorage()) : LazyOptional.empty();
        this.itemHandler = LazyOptional.of(() -> this.inventory.getAllItemHandler());
        this.manualItemHandler = LazyOptional.of(() -> this.inventory.getManualItemHandler());
    }

    public ContainerInventory getInventory() {
        return this.inventory;
    }

    public void markInventoryDirty() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.onInventoryChanged((ServerWorld)this.field_145850_b);
        }
    }

    public void onInventoryChanged(@Nonnull ServerWorld world) {
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return this.manualItemHandler.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.inventory == null) {
            return super.getCapability(cap, side);
        }
        if (cap.equals((Object)CapabilityEnergy.ENERGY)) {
            return this.energyStorage.cast();
        }
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            if (side == null) {
                return this.manualItemHandler.cast();
            }
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        if (this.inventory != null && nbt.func_150297_b("inv", 10)) {
            this.inventory.deserializeNBT(nbt.func_74775_l("inv"));
        }
        super.func_230337_a_(state, nbt);
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        if (this.inventory != null) {
            compound.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        }
        return super.func_189515_b(compound);
    }
}

