/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.screens.steps;

import com.bisecthosting.mods.bhmenu.Config;
import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.bhdata.OrderData;
import com.bisecthosting.mods.bhmenu.bhdata.api.ApiData;
import com.bisecthosting.mods.bhmenu.bhdata.api.PlanService;
import com.bisecthosting.mods.bhmenu.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.screens.steps.SelectPlanTypeStep;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class SelectPackageStep
extends ProcessStep {
    private Slider slider;
    private final PlanService planService;
    private int packageIndex;
    private final ITextComponent perfectPlan = new TranslationTextComponent("step.select_package.plan");
    private final ITextComponent moveSlider = new TranslationTextComponent("step.select_package.slider");

    public SelectPackageStep(OrderData orderData) {
        super(orderData);
        this.planService = orderData.isPremium ? (PlanService)ApiData.PLANS.getLeft() : (PlanService)ApiData.PLANS.getRight();
        this.packageIndex = this.getPackagePlanIndexFromRecommendations();
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<IGuiEventListener> children) {
        super.init(screen, children);
        int y = MathHelper.func_76125_a((int)(screen.field_230709_l_ / 2 - 10), (int)120, (int)(screen.field_230709_l_ - 50));
        this.slider = new Slider(screen.field_230708_k_ / 2 - 100, y, 200, 20, (ITextComponent)new StringTextComponent(""), (ITextComponent)new StringTextComponent(""), 0.0, (double)(this.planService.plans.size() - 1), (double)this.packageIndex, false, false, b -> {}, slider -> {
            this.packageIndex = slider.getValueInt();
        });
        children.accept((IGuiEventListener)new Button(screen.field_230708_k_ / 2 - 50, y + 30, 100, 20, (ITextComponent)new TranslationTextComponent("step.select_package.order_plan"), b -> {
            this.orderData.packageId = this.getCurrentPlan().id;
            this.openOrderUrl();
            screen.getMinecraft().func_147108_a(screen.parent);
        }));
        children.accept((IGuiEventListener)this.slider);
    }

    @Override
    public void render(BHOrderScreen screen, FontRenderer font, MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        PlanService.PackagePlan currentPlan = this.getCurrentPlan();
        font.func_243248_b(ms, this.perfectPlan, (float)(screen.field_230708_k_ - font.func_238414_a_((ITextProperties)this.perfectPlan)) / 2.0f, (float)(this.slider.field_230691_m_ - 77), 0xFFFFFF);
        String plan = currentPlan.name;
        font.func_238421_b_(ms, plan, (float)(screen.field_230708_k_ - font.func_78256_a(plan)) / 2.0f, (float)(this.slider.field_230691_m_ - 50), 0xFFFFFF);
        TranslationTextComponent price = new TranslationTextComponent("step.select_package.price", new Object[]{Float.valueOf(currentPlan.price)});
        font.func_243248_b(ms, (ITextComponent)price, (float)(screen.field_230708_k_ - font.func_238414_a_((ITextProperties)price)) / 2.0f, (float)(this.slider.field_230691_m_ - 40), 0xFFFFFF);
        font.func_243248_b(ms, this.moveSlider, (float)(screen.field_230708_k_ - font.func_238414_a_((ITextProperties)this.moveSlider)) / 2.0f, (float)(this.slider.field_230691_m_ - 15), 0xFFFFFF);
    }

    private void openOrderUrl() {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("https://bisecthosting.com/modredirect.php?pid=");
        urlBuilder.append(this.orderData.packageId);
        urlBuilder.append("&configoption[");
        urlBuilder.append(this.orderData.isPremium ? 29 : 32);
        urlBuilder.append("]=");
        urlBuilder.append(this.orderData.getJarId());
        urlBuilder.append("&source=mod");
        if (!((String)Config.partnerId.get()).isEmpty()) {
            urlBuilder.append("&aid=");
            urlBuilder.append((String)Config.partnerId.get());
        }
        ModRef.LOGGER.info("Setting up order link " + urlBuilder);
        Util.func_110647_a().func_195640_a(urlBuilder.toString());
    }

    private PlanService.PackagePlan getCurrentPlan() {
        return this.planService.plans.get(this.packageIndex);
    }

    private int getPackagePlanIndexFromRecommendations() {
        int recommendedRam = ApiData.RAM_RECOMMENDATIONS.get(this.orderData.getJarId()).getRamForPlayers(this.orderData.playerCount);
        int planIndex = 0;
        boolean planFound = false;
        for (PlanService.PackagePlan plan : this.planService.plans) {
            if (plan.ram / 1024 >= recommendedRam) {
                planFound = true;
                break;
            }
            ++planIndex;
        }
        if (!planFound) {
            planIndex = 0;
        }
        return planIndex;
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        screen.setStep(new SelectPlanTypeStep(this.orderData));
    }
}

