/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.screens.steps;

import com.bisecthosting.mods.bhmenu.bhdata.OrderData;
import com.bisecthosting.mods.bhmenu.bhdata.api.ApiData;
import com.bisecthosting.mods.bhmenu.bhdata.api.JarGroupData;
import com.bisecthosting.mods.bhmenu.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.screens.JarGroupListWidget;
import com.bisecthosting.mods.bhmenu.screens.JarListWidget;
import com.bisecthosting.mods.bhmenu.screens.steps.PlayerCountStep;
import com.bisecthosting.mods.bhmenu.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.screens.steps.SelectPlanTypeStep;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SelectJarStep
extends ProcessStep {
    private JarGroupListWidget.JarGroupEntry selectedGroup = null;
    private JarListWidget.JarEntry selectedJar = null;
    private final ITextComponent nameFilter = new TranslationTextComponent("step.select_jar.name_filter");
    private final ITextComponent platformFilter = new TranslationTextComponent("step.select_jar.platform_filter");
    private final ITextComponent selectPack = new TranslationTextComponent("step.select_jar.select_pack");
    private JarGroupListWidget jarGroupList;
    private JarListWidget jarList;
    private TextFieldWidget searchBar;
    private Button selectButton;

    public SelectJarStep(OrderData orderData) {
        super(orderData);
        orderData.jar = null;
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<IGuiEventListener> children) {
        super.init(screen, children);
        int y0 = 80;
        int y1 = screen.field_230709_l_ - 80;
        List<JarGroupData> jarGroupIds = ApiData.AVAILABLE_GROUPS.values().stream().sorted().filter(group -> !group.ignore).collect(Collectors.toList());
        this.jarGroupList = new JarGroupListWidget(this, screen.getMinecraft(), screen.field_230708_k_ / 3, screen.field_230709_l_, y0 + 44, y1, jarGroupIds);
        this.jarGroupList.func_230959_g_(6);
        this.jarList = new JarListWidget(this, screen.getMinecraft(), screen.field_230708_k_ - this.jarGroupList.getWidth() - this.jarGroupList.getLeft() - 16, screen.field_230709_l_, y0, y1);
        this.jarList.func_230959_g_(this.jarGroupList.getLeft() + this.jarGroupList.getWidth() + 10);
        this.searchBar = new TextFieldWidget(screen.getMinecraft().field_71466_p, this.jarGroupList.getLeft(), this.jarGroupList.getTop() - 43, this.jarGroupList.getWidth(), 15, this.searchBar, (ITextComponent)new StringTextComponent(""));
        this.searchBar.func_212954_a(s -> this.filterJars());
        this.selectButton = new Button(this.jarList.getLeft() + (this.jarList.getWidth() - 150) / 2, this.jarList.getBottom() + 7, 150, 20, (ITextComponent)new TranslationTextComponent("step.select_jar.select"), b -> screen.setStep(new SelectPlanTypeStep(this.orderData)));
        children.accept((IGuiEventListener)this.jarGroupList);
        children.accept((IGuiEventListener)this.jarList);
        children.accept((IGuiEventListener)this.searchBar);
        children.accept((IGuiEventListener)this.selectButton);
        this.filterJars();
    }

    @Override
    public void tick(BHOrderScreen screen) {
        this.searchBar.func_146178_a();
        this.jarGroupList.func_241215_a_((AbstractList.AbstractListEntry)this.selectedGroup);
        this.jarList.func_241215_a_((AbstractList.AbstractListEntry)this.selectedJar);
        this.selectButton.field_230693_o_ = this.orderData.jar != null;
    }

    public void setSelectedGroup(@Nullable JarGroupListWidget.JarGroupEntry selectedGroup) {
        this.selectedGroup = selectedGroup == this.selectedGroup ? null : selectedGroup;
        this.filterJars();
    }

    public void setSelectedJar(@Nullable JarListWidget.JarEntry selectedJar) {
        this.selectedJar = selectedJar == this.selectedJar ? null : selectedJar;
        this.orderData.jar = this.selectedJar == null ? null : selectedJar.data;
    }

    public void filterJars() {
        this.jarList.func_230932_a_(0.0);
        Stream<JarGroupData.JarData> jarStream = ApiData.AVAILABLE_JARS.values().stream().sorted();
        if (this.selectedGroup != null) {
            jarStream = jarStream.filter(jar -> this.selectedGroup.data.premiumJars.containsKey(jar.premiumJarId));
        }
        if (!this.searchBar.func_146179_b().isEmpty()) {
            jarStream = jarStream.filter(jar -> jar.name.toLowerCase(Locale.ROOT).contains(this.searchBar.func_146179_b().toLowerCase(Locale.ROOT)));
        }
        List<JarGroupData.JarData> jars = jarStream.collect(Collectors.toList());
        this.jarList.buildJarList(jars);
        this.setSelectedJar((JarListWidget.JarEntry)this.jarList.func_230958_g_());
    }

    @Override
    public void render(BHOrderScreen screen, FontRenderer font, MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.jarGroupList.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.jarList.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        font.func_243248_b(ms, this.nameFilter, (float)this.searchBar.field_230690_l_ + (float)(this.searchBar.func_230998_h_() - font.func_238414_a_((ITextProperties)this.nameFilter)) / 2.0f, (float)(this.searchBar.field_230691_m_ - 15), 0xFFFFFF);
        font.func_243248_b(ms, this.platformFilter, (float)this.jarGroupList.getLeft() + (float)(this.jarGroupList.getWidth() - font.func_238414_a_((ITextProperties)this.platformFilter)) / 2.0f, (float)(this.jarGroupList.getTop() - 15), 0xFFFFFF);
        font.func_243248_b(ms, this.selectPack, (float)this.jarList.getLeft() + (float)(this.jarList.getWidth() - font.func_238414_a_((ITextProperties)this.selectPack)) / 2.0f, (float)(this.jarList.getTop() - 15), 0xFFFFFF);
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        if (!this.searchBar.func_146179_b().isEmpty()) {
            this.searchBar.func_146180_a("");
        } else if (this.selectedGroup != null) {
            this.selectedGroup = null;
        } else {
            screen.setStep(new PlayerCountStep(this.orderData));
        }
    }
}

