/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.bhdata.api.ApiData;
import com.bisecthosting.mods.bhmenu.bhdata.api.JarGroupData;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="bhmenu", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static ForgeConfigSpec.ConfigValue<String> title;
    public static ForgeConfigSpec.ConfigValue<String> description;
    public static ForgeConfigSpec.ConfigValue<String> partnerId;
    public static ForgeConfigSpec.ConfigValue<String> packId;
    public static ForgeConfigSpec.BooleanValue useLanguageFiles;

    public static void register() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        title = builder.comment("The title to display at the top of the entry.").define("title", (Object)"Need a server?");
        description = builder.comment("The description to display below the title.").define("description", (Object)"Click me to get your own server!");
        partnerId = builder.comment(new String[]{"Your partner ID to use in during the ordering process.", "Without this you will not be credited for the purchases.", "(Your partner id is not the same as your referral link, please check your client area to find your partner id at https://www.bisecthosting.com/partners/console.php)."}).define("partnerId", (Object)"");
        packId = builder.comment(new String[]{"The id of this modpack.", "(This is BH internal pack id; Find the id here: https://www.bisecthosting.com/partners/console.php)"}).define("pack_id", (Object)"");
        useLanguageFiles = builder.comment(new String[]{"Set this to true to use specific language translation keys.", "This requires a custom mod that adds resource files, such as OpenLoader.", "Use 'server_entry.title' key for the Title;", "Use 'server_entry.description' key for the Description."}).define("use_language_files", false);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, builder.build());
    }

    public static ITextComponent getTitle() {
        return (Boolean)useLanguageFiles.get() != false ? new TranslationTextComponent("server_entry.title") : new StringTextComponent((String)title.get());
    }

    public static ITextComponent getDescription() {
        return (Boolean)useLanguageFiles.get() != false ? new TranslationTextComponent("server_entry.description") : new StringTextComponent((String)description.get());
    }

    public static JarGroupData.JarData getRecommendedJarData() {
        if (((String)packId.get()).isEmpty()) {
            return null;
        }
        JarGroupData.JarData recommendedJar = ApiData.AVAILABLE_JARS.get(packId.get());
        if (recommendedJar == null) {
            ModRef.LOGGER.warn("Invalid pack id {}", packId.get());
            return null;
        }
        return recommendedJar;
    }
}

