/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.loot;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class WitheredBoneLootModifier
extends LootModifier {
    private final Item replacedItem;
    private final Item boneItem;
    public static final Serializer SERIALIZER = new Serializer();

    protected WitheredBoneLootModifier(ILootCondition[] conditionsIn, Item replacedItem, Item boneItem) {
        super(conditionsIn);
        this.replacedItem = replacedItem;
        this.boneItem = boneItem;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity t = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (t == null) {
            return generatedLoot;
        }
        if (t.func_200600_R().delegate.name().equals((Object)new ResourceLocation("minecraft:wither_skeleton"))) {
            int amountOfBones = 0;
            for (ItemStack i2 : generatedLoot) {
                if (i2.func_77973_b() != this.replacedItem) continue;
                amountOfBones += i2.func_190916_E();
            }
            generatedLoot.removeIf(i -> i.func_77973_b() == this.replacedItem);
            generatedLoot.add(new ItemStack((IItemProvider)this.boneItem, amountOfBones));
        }
        return generatedLoot;
    }

    private static class Serializer
    extends GlobalLootModifierSerializer<WitheredBoneLootModifier> {
        Serializer() {
            this.setRegistryName(new ResourceLocation("architects_palette", "wither_skeleton_bones"));
        }

        public WitheredBoneLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            String boneItem = JSONUtils.func_151200_h((JsonObject)object, (String)"bone");
            String replacedItem = JSONUtils.func_151200_h((JsonObject)object, (String)"replaces");
            Item witheredBone = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(boneItem));
            Item bone = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(replacedItem));
            return new WitheredBoneLootModifier(ailootcondition, bone, witheredBone);
        }

        public JsonObject write(WitheredBoneLootModifier instance) {
            JsonObject obj = instance.conditions.length > 0 ? this.makeConditions(instance.conditions) : new JsonObject();
            obj.addProperty("bone", instance.boneItem.getItem().getRegistryName().toString());
            obj.addProperty("replaces", instance.replacedItem.getItem().getRegistryName().toString());
            return obj;
        }
    }
}

