/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.data;

import architectspalette.common.blocks.abyssaline.ChiseledAbyssalineBlock;
import architectspalette.core.ArchitectsPalette;
import architectspalette.core.integration.advancement.CarveTotemTrigger;
import architectspalette.core.registry.APBlocks;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.PlacedBlockTrigger;
import net.minecraft.block.Block;
import net.minecraft.data.AdvancementProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Advancements
extends AdvancementProvider {
    private final Path PATH;

    public Advancements(DataGenerator generatorIn) {
        super(generatorIn);
        this.PATH = generatorIn.func_200391_b();
    }

    public void func_200398_a(DirectoryCache cache) {
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate Advancement" + advancement.func_192067_g());
            }
            Path path1 = Advancements.getPath(this.PATH, advancement);
            try {
                IDataProvider.func_218426_a((Gson)new GsonBuilder().setPrettyPrinting().create(), (DirectoryCache)cache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException ioException) {
                ArchitectsPalette.LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioException);
            }
        };
        new APAdvancements().accept(consumer);
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    public static class APAdvancements
    implements Consumer<Consumer<Advancement>> {
        private static IFormattableTextComponent getTranslationKey(String key, Object ... args) {
            return new TranslationTextComponent("architects_palette." + key, args);
        }

        private String getNameId(String id) {
            return "architects_palette:" + id;
        }

        protected static Advancement.Builder getAdvancement(Advancement parent, IItemProvider display, String name, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.func_200278_a().func_203905_a(parent).func_203902_a(display, (ITextComponent)APAdvancements.getTranslationKey("advancement." + name, new Object[0]), (ITextComponent)APAdvancements.getTranslationKey("advancement." + name + ".desc", new Object[0]), null, frame, showToast, announceToChat, hidden);
        }

        protected Advancement buyAdvancement(Advancement parent, IItemProvider display, String name, String item, Consumer<Advancement> advancementConsumer) {
            return APAdvancements.getAdvancement(parent, display, name, FrameType.TASK, true, false, false).func_200275_a(item, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{display})).func_203904_a(advancementConsumer, this.getNameId("main/" + name));
        }

        @Override
        public void accept(Consumer<Advancement> advancementConsumer) {
            Advancement architectsPalette = Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)((ChiseledAbyssalineBlock)APBlocks.CHISELED_ABYSSALINE_BRICKS.get()).func_199767_j(), (ITextComponent)APAdvancements.getTranslationKey("advancement.root", new Object[0]), (ITextComponent)APAdvancements.getTranslationKey("advancement.root.desc", new Object[0]), new ResourceLocation("architects_palette:textures/block/limestone_bricks.png"), FrameType.TASK, false, false, false).func_200275_a("craftingtable", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[0])).func_203904_a(advancementConsumer, this.getNameId("main/root"));
            Advancement totemCarving = APAdvancements.getAdvancement(architectsPalette, (IItemProvider)((Block)APBlocks.PLACID_ACACIA_TOTEM.get()).func_199767_j(), "totem_carving", FrameType.TASK, true, true, false).func_200275_a("carve_totem", (ICriterionInstance)CarveTotemTrigger.Instance.simple()).func_203904_a(advancementConsumer, this.getNameId("main/totem_carving"));
            Advancement whatACatch = APAdvancements.getAdvancement(architectsPalette, (IItemProvider)((Block)APBlocks.COD_LOG.get()).func_199767_j(), "buy_fish_block", FrameType.TASK, true, false, false).func_200275_a("cod_log", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{((Block)APBlocks.COD_LOG.get()).func_199767_j()})).func_200275_a("salmon_log", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{((Block)APBlocks.SALMON_LOG.get()).func_199767_j()})).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(advancementConsumer, this.getNameId("main/buy_fish_block"));
            Advancement buyPipes = this.buyAdvancement(architectsPalette, (IItemProvider)((Block)APBlocks.PIPE.get()).func_199767_j(), "buy_pipe", "pipe", advancementConsumer);
            Advancement buyEntrails = this.buyAdvancement(architectsPalette, (IItemProvider)((Block)APBlocks.ENTRAILS.get()).func_199767_j(), "buy_entrails", "entrails", advancementConsumer);
            Advancement placeEntrails = APAdvancements.getAdvancement(buyEntrails, (IItemProvider)((Block)APBlocks.ENTRAILS.get()).func_199767_j(), "place_entrails", FrameType.TASK, true, true, true).func_200275_a("entrails", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)APBlocks.ENTRAILS.get()))).func_203904_a(advancementConsumer, this.getNameId("main/place_entrails"));
            Advancement buyPlating = this.buyAdvancement(architectsPalette, (IItemProvider)APBlocks.PLATING_BLOCK.get().func_199767_j(), "buy_plating", "plating", advancementConsumer);
            Advancement buySpool = this.buyAdvancement(architectsPalette, (IItemProvider)((Block)APBlocks.SPOOL.get()).func_199767_j(), "buy_spool", "spool", advancementConsumer);
            Advancement buyCelestialStone = APAdvancements.getAdvancement(architectsPalette, (IItemProvider)((Block)APBlocks.SUNSTONE.get()).func_199767_j(), "buy_celestial_stone", FrameType.TASK, true, false, false).func_200275_a("moonstone", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{((Block)APBlocks.MOONSTONE.get()).func_199767_j()})).func_200275_a("sunstone", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{((Block)APBlocks.SUNSTONE.get()).func_199767_j()})).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(advancementConsumer, this.getNameId("main/buy_celestial_stone"));
            Advancement getWarpstone = this.buyAdvancement(architectsPalette, (IItemProvider)APBlocks.WARPSTONE.get().func_199767_j(), "find_warpstone", "warpstone", advancementConsumer);
            Advancement getTwistedSapling = this.buyAdvancement(getWarpstone, (IItemProvider)((Block)APBlocks.TWISTED_SAPLING.get()).func_199767_j(), "find_twisted_sapling", "sapling", advancementConsumer);
        }
    }
}

