/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.common.blocks.abyssaline;

import architectspalette.core.registry.APBlocks;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class AbyssalineBlock
extends Block {
    public static final BooleanProperty CHARGED = BooleanProperty.func_177716_a((String)"charged");

    public AbyssalineBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)CHARGED, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)CHARGED) != false ? 7 : 0;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)CHARGED, (Comparable)Boolean.valueOf(AbyssalineBlock.checkForNearbyChargedBlocks(worldIn, currentPos)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)CHARGED, (Comparable)Boolean.valueOf(AbyssalineBlock.checkForNearbyChargedBlocks((IWorld)context.func_195991_k(), context.func_195995_a())));
    }

    public static boolean checkForNearbyChargedBlocks(IWorld world, BlockPos pos) {
        BlockState state;
        BlockPos offset;
        boolean powered = false;
        for (Direction sides : Direction.values()) {
            offset = pos.func_177972_a(sides);
            state = world.func_180495_p(offset);
            if (state.func_177230_c() != APBlocks.CHISELED_ABYSSALINE_BRICKS.get() || !((Boolean)state.func_177229_b((Property)CHARGED)).booleanValue()) continue;
            powered = true;
            break;
        }
        if (!powered) {
            for (Direction sides : Direction.values()) {
                offset = pos.func_177972_a(sides);
                state = world.func_180495_p(offset);
                if (!AbyssalineBlock.isChargedBlock(state)) continue;
                return AbyssalineBlock.checkForNearbySource(world, offset, sides.func_176734_d(), 1);
            }
        }
        return powered;
    }

    private static boolean checkForNearbySource(IWorld world, BlockPos pos, Direction blacklistedDirection, int cycles) {
        BlockPos offset;
        BlockState state;
        if (cycles == 2) {
            return false;
        }
        boolean powered = false;
        for (Direction sides : Direction.values()) {
            if (sides == blacklistedDirection || (state = world.func_180495_p(offset = pos.func_177972_a(sides))).func_177230_c() != APBlocks.CHISELED_ABYSSALINE_BRICKS.get() || !((Boolean)state.func_177229_b((Property)CHARGED)).booleanValue()) continue;
            powered = true;
            break;
        }
        if (!powered) {
            for (Direction sides : Direction.values()) {
                offset = pos.func_177972_a(sides);
                state = world.func_180495_p(offset);
                if (!AbyssalineBlock.isChargedBlock(state)) continue;
                return AbyssalineBlock.checkForNearbySource(world, offset, sides.func_176734_d(), cycles + 1);
            }
        }
        return powered;
    }

    public static boolean isChargedBlock(BlockState state) {
        return state.func_177230_c() != APBlocks.CHISELED_ABYSSALINE_BRICKS.get() && state.func_235901_b_((Property)CHARGED) && (Boolean)state.func_177229_b((Property)CHARGED) != false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CHARGED});
    }
}

