/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.common.blocks;

import architectspalette.common.blocks.TotemWingBlock;
import architectspalette.core.integration.APCriterion;
import architectspalette.core.registry.APBlocks;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class TotemBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public final TotemWingBlock WING_BLOCK;
    public final TotemFace totemType;

    public TotemBlock(AbstractBlock.Properties properties, TotemWingBlock wingBlock, TotemFace face) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        this.WING_BLOCK = wingBlock;
        this.totemType = face;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            boolean waterlogged;
            BlockPos blockpos = pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176746_e());
            boolean bl = waterlogged = worldIn.func_204610_c(blockpos).func_206886_c() == Fluids.field_204546_a;
            if (worldIn.func_175623_d(blockpos) || waterlogged) {
                worldIn.func_180501_a(blockpos, (BlockState)((BlockState)this.WING_BLOCK.func_176223_P().func_206870_a((Property)TotemWingBlock.FACING, (Comparable)((Direction)state.func_177229_b((Property)FACING)).func_176746_e())).func_206870_a((Property)TotemWingBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 3);
            }
            boolean bl2 = waterlogged = worldIn.func_204610_c(blockpos = pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176735_f())).func_206886_c() == Fluids.field_204546_a;
            if (worldIn.func_175623_d(blockpos) || waterlogged) {
                worldIn.func_180501_a(blockpos, (BlockState)((BlockState)this.WING_BLOCK.func_176223_P().func_206870_a((Property)TotemWingBlock.FACING, (Comparable)((Direction)state.func_177229_b((Property)FACING)).func_176735_f())).func_206870_a((Property)TotemWingBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 3);
            }
            worldIn.func_230547_a_(pos, Blocks.field_150350_a);
            state.func_235734_a_((IWorld)worldIn, pos, 3);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack playerItem = player.func_184586_b(handIn);
        if (playerItem.func_77973_b() instanceof AxeItem) {
            BlockState newState = (BlockState)this.totemType.getStrip().func_176223_P().func_206870_a((Property)FACING, state.func_177229_b((Property)FACING));
            worldIn.func_180501_a(pos, newState, 3);
            playerItem.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(handIn));
            worldIn.func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayerEntity) {
                APCriterion.CARVE_TOTEM.trigger((ServerPlayerEntity)player);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return ActionResultType.FAIL;
    }

    public static enum TotemFace {
        GRINNING,
        PLACID,
        SHOCKED,
        BLANK;


        public Block getStrip() {
            switch (this) {
                case GRINNING: {
                    return (Block)APBlocks.PLACID_ACACIA_TOTEM.get();
                }
                case PLACID: {
                    return (Block)APBlocks.SHOCKED_ACACIA_TOTEM.get();
                }
                case SHOCKED: {
                    return (Block)APBlocks.BLANK_ACACIA_TOTEM.get();
                }
            }
            return (Block)APBlocks.GRINNING_ACACIA_TOTEM.get();
        }
    }
}

