/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements.modifier;

import com.builtbroken.ai.improvements.AnimalConfigSection;
import com.builtbroken.ai.improvements.ConfigMain;
import com.builtbroken.ai.improvements.FilteredConfigValue;
import com.builtbroken.ai.improvements.FixedLookController;
import com.builtbroken.ai.improvements.modifier.ModifierLevel;
import com.builtbroken.ai.improvements.modifier.editor.FilteredRemove;
import com.builtbroken.ai.improvements.modifier.editor.GenericRemove;
import com.builtbroken.ai.improvements.modifier.filters.FilterLayer;
import com.builtbroken.ai.improvements.modifier.filters.FilterResult;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.FollowSchoolLeaderGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aiimprovements")
public class ModifierSystem {
    public static final FilterLayer editor = new FilterLayer(null);
    public static final ModifierLevel mobEntityEditor = ModifierLevel.newFilter(entity -> entity instanceof MobEntity);
    public static final ModifierLevel fishEditor = ModifierLevel.newFilter(entity -> entity instanceof AbstractFishEntity);
    public static final ModifierLevel squidEditor = ModifierLevel.newFilter(entity -> entity instanceof SquidEntity);
    public static final ModifierLevel cowEditor = ModifierLevel.newFilter(entity -> entity instanceof CowEntity);
    public static final ModifierLevel chickenEditor = ModifierLevel.newFilter(entity -> entity instanceof ChickenEntity);
    public static final ModifierLevel pigEditor = ModifierLevel.newFilter(entity -> entity instanceof PigEntity);
    public static final ModifierLevel sheepEditor = ModifierLevel.newFilter(entity -> entity instanceof SheepEntity);

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        editor.handle(event.getEntity());
    }

    public static void init() {
        editor.add(mobEntityEditor);
        ModifierSystem.mobEntityEditor.goalEditor.add(new FilteredRemove(goal -> goal instanceof LookAtGoal, ConfigMain.CONFIG.removeLookGoal));
        ModifierSystem.mobEntityEditor.goalEditor.add(new FilteredRemove(goal -> goal instanceof LookRandomlyGoal, ConfigMain.CONFIG.removeLookRandom));
        ModifierSystem.mobEntityEditor.filters.add(entity -> ModifierSystem.replaceLookHelper((MobEntity)entity));
        ModifierSystem.mobEntityEditor.filters.add(fishEditor);
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof RandomSwimmingGoal, ConfigMain.CONFIG.removeFishSwim));
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof AvoidEntityGoal, ConfigMain.CONFIG.removeFishAvoidPlayer));
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof PanicGoal, ConfigMain.CONFIG.removeFishPanic));
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof FollowSchoolLeaderGoal, ConfigMain.CONFIG.removeFishFollowLeader));
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof PufferfishEntity.PuffGoal, ConfigMain.CONFIG.removeFishFollowLeader));
        ModifierSystem.mobEntityEditor.filters.add(squidEditor);
        ModifierSystem.squidEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof SquidEntity.MoveRandomGoal, ConfigMain.CONFIG.removeRandomMove));
        ModifierSystem.squidEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof SquidEntity.FleeGoal, ConfigMain.CONFIG.removeRandomMove));
        ModifierSystem.mobEntityEditor.filters.add(cowEditor);
        ModifierSystem.populateAnimalEditor(cowEditor, ConfigMain.CONFIG.cow);
        ModifierSystem.mobEntityEditor.filters.add(chickenEditor);
        ModifierSystem.populateAnimalEditor(chickenEditor, ConfigMain.CONFIG.chicken);
        ModifierSystem.mobEntityEditor.filters.add(pigEditor);
        ModifierSystem.populateAnimalEditor(pigEditor, ConfigMain.CONFIG.pig);
        ModifierSystem.mobEntityEditor.filters.add(sheepEditor);
        ModifierSystem.populateAnimalEditor(sheepEditor, ConfigMain.CONFIG.sheep);
        ModifierSystem.sheepEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof EatGrassGoal, ConfigMain.CONFIG.removeSheepEatBlock));
    }

    private static FilterResult replaceLookHelper(MobEntity living) {
        FilteredConfigValue replaceLookController = ConfigMain.CONFIG.replaceLookController;
        if (((Boolean)replaceLookController.configValue().get()).booleanValue() && (living.func_70671_ap() == null || living.func_70671_ap().getClass() == LookController.class)) {
            if (replaceLookController.isFiltered(living.func_200600_R().getRegistryName().toString())) {
                return FilterResult.DID_NOTHING;
            }
            LookController oldHelper = living.func_70671_ap();
            living.field_70749_g = new FixedLookController(living);
            if (living.func_70671_ap() instanceof FixedLookController) {
                ((FixedLookController)living.func_70671_ap()).copyDataIntoSelf(oldHelper);
                return FilterResult.MODIFIED;
            }
        }
        return FilterResult.DID_NOTHING;
    }

    private static void populateAnimalEditor(ModifierLevel animalEditor, AnimalConfigSection configs) {
        animalEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof SwimGoal, configs.removeFloat()));
        animalEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof PanicGoal, configs.removePanic()));
        animalEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof BreedGoal, configs.removeBreed()));
        animalEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof TemptGoal, configs.removeTempt()));
        animalEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof FollowParentGoal, configs.removeFollowParent()));
        animalEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof WaterAvoidingRandomWalkingGoal, configs.removeStroll()));
    }
}

