/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.entities.ai;

import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.util.math.MathHelper;
import wolfshotz.dml.entities.TameableDragonEntity;
import wolfshotz.dml.util.MathX;

public class LifeStageController {
    private static final UUID SCALE_MODIFIER_UUID = UUID.fromString("856d4ba4-9ffe-4a52-8606-890bb9be538b");
    private static final int TICKS_SINCE_CREATION_UPDATE_INTERVAL = 100;
    private final TameableDragonEntity dragon;
    private int ticksAlive;
    private EnumLifeStage prevStage;

    public LifeStageController(TameableDragonEntity dragon) {
        this.dragon = dragon;
    }

    public void tick() {
        if (this.dragon.isServer() && !this.isAdult() && ++this.ticksAlive % 100 == 0) {
            this.dragon.setTicksAlive(this.ticksAlive);
        }
        this.updateLifeStage();
        if (this.dragon.field_70173_aa % 100 == 0) {
            this.dragon.func_213323_x_();
        }
    }

    public void updateLifeStage() {
        EnumLifeStage currentStage = this.getLifeStage();
        if (this.prevStage != currentStage) {
            if (this.dragon.isServer()) {
                this.applyStageAttributeModifiers();
                this.dragon.func_70661_as().func_189566_q().func_186317_a(this.isHatchling());
            }
            this.prevStage = currentStage;
            this.dragon.func_213323_x_();
        }
    }

    public void applyStageAttributeModifiers() {
        AttributeModifier scaleModifier = new AttributeModifier(SCALE_MODIFIER_UUID, "Dragon size modifier", (double)this.getScale(), AttributeModifier.Operation.ADDITION);
        ModifiableAttributeInstance health = this.dragon.func_110148_a(Attributes.field_233818_a_);
        ModifiableAttributeInstance damage = this.dragon.func_110148_a(Attributes.field_233823_f_);
        health.func_111124_b(scaleModifier);
        health.func_233767_b_(scaleModifier);
        damage.func_111124_b(scaleModifier);
        damage.func_233767_b_(scaleModifier);
    }

    public EnumLifeStage getLifeStage() {
        return EnumLifeStage.fromTickCount(this.dragon.getTicksAlive());
    }

    public void setLifeStage(EnumLifeStage stage) {
        if (this.dragon.isServer()) {
            this.ticksAlive = stage.startTicks();
            this.dragon.setTicksAlive(this.ticksAlive);
        }
        this.updateLifeStage();
    }

    public float getScale() {
        return EnumLifeStage.scaleFromTickCount(this.dragon.getTicksAlive());
    }

    public void setTicksAlive(int ticksAlive) {
        this.ticksAlive = ticksAlive;
    }

    public boolean isHatchling() {
        return this.getLifeStage() == EnumLifeStage.HATCHLING;
    }

    public boolean isJuvenile() {
        return this.getLifeStage() == EnumLifeStage.JUVENILE;
    }

    public boolean isAdult() {
        return this.getLifeStage() == EnumLifeStage.ADULT;
    }

    public static enum EnumLifeStage {
        HATCHLING(0.33f),
        JUVENILE(0.66f),
        ADULT(1.0f);

        public static final int TICKS_PER_STAGE = 24000;
        public static final EnumLifeStage[] VALUES;
        private final float scale;

        private EnumLifeStage(float scale) {
            this.scale = scale;
        }

        public static float scaleFromTickCount(int ticksSinceCreation) {
            EnumLifeStage lifeStage = EnumLifeStage.fromTickCount(ticksSinceCreation);
            if (lifeStage == ADULT) {
                return lifeStage.scale;
            }
            return MathX.terpLinear(lifeStage.scale, lifeStage.next().scale, EnumLifeStage.progressFromTickCount(ticksSinceCreation));
        }

        public static float progressFromTickCount(int ticksSinceCreation) {
            EnumLifeStage lifeStage = EnumLifeStage.fromTickCount(ticksSinceCreation);
            int lifeStageTicks = ticksSinceCreation - lifeStage.startTicks();
            return (float)lifeStageTicks / 24000.0f;
        }

        public static EnumLifeStage fromTickCount(int ticksSinceCreation) {
            return VALUES[EnumLifeStage.clampTickCount(ticksSinceCreation) / 24000];
        }

        public static int clampTickCount(int ticksSinceCreation) {
            return MathHelper.func_76125_a((int)ticksSinceCreation, (int)0, (int)(VALUES.length * 24000));
        }

        public int startTicks() {
            return this.ordinal() * 24000;
        }

        public EnumLifeStage next() {
            return this == ADULT ? null : VALUES[this.ordinal() + 1];
        }

        static {
            VALUES = EnumLifeStage.values();
        }
    }
}

