/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.entities;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SaddleItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import wolfshotz.dml.DMLRegistry;
import wolfshotz.dml.DragonMountsLegacy;
import wolfshotz.dml.client.anim.DragonAnimator;
import wolfshotz.dml.entities.DragonEggEntity;
import wolfshotz.dml.entities.ai.DragonBodyController;
import wolfshotz.dml.entities.ai.DragonMoveController;
import wolfshotz.dml.entities.ai.LifeStageController;
import wolfshotz.dml.entities.ai.goals.DragonBabuFollowParent;
import wolfshotz.dml.entities.ai.goals.DragonBreedGoal;
import wolfshotz.dml.entities.ai.goals.DragonLandGoal;
import wolfshotz.dml.misc.DragonEggBlock;

public abstract class TameableDragonEntity
extends TameableEntity {
    public static final double BASE_SPEED_GROUND = 0.3;
    public static final double BASE_SPEED_FLYING = 0.6;
    public static final double BASE_DAMAGE = 8.0;
    public static final double BASE_HEALTH = 60.0;
    public static final double BASE_FOLLOW_RANGE = 16.0;
    public static final double BASE_FOLLOW_RANGE_FLYING = 32.0;
    public static final double ALTITUDE_FLYING_THRESHOLD = 2.0;
    public static final int REPRO_LIMIT = 2;
    public static final int BASE_KB_RESISTANCE = 1;
    public static final float BASE_WIDTH = 2.75f;
    public static final float BASE_HEIGHT = 2.75f;
    private static final DataParameter<Boolean> DATA_FLYING = EntityDataManager.func_187226_a(TameableDragonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_SADDLED = EntityDataManager.func_187226_a(TameableDragonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_BREATHING = EntityDataManager.func_187226_a(TameableDragonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DATA_TICKS_ALIVE = EntityDataManager.func_187226_a(TameableDragonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final String NBT_SADDLED = "Saddle";
    private static final String NBT_TICKS_ALIVE = "TicksAlive";
    private static final String NBT_REPRO_COUNT = "ReproCount";
    public LifeStageController lifeStageController;
    public DragonAnimator animator;
    public final List<DamageSource> damageImmunities = Lists.newArrayList();
    public int reproCount;

    public TameableDragonEntity(EntityType<? extends TameableDragonEntity> type, World world) {
        super(type, world);
        this.field_70138_W = 1.0f;
        this.field_70158_ak = true;
        this.field_70765_h = new DragonMoveController(this);
        if (this.isClient()) {
            this.animator = new DragonAnimator(this);
        }
    }

    protected BodyController func_184650_s() {
        return new DragonBodyController(this);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233823_f_, 16.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233822_e_, 0.6);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new DragonLandGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new DragonBabuFollowParent(this, 10.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.1, 10.0f, 3.5f, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new DragonBreedGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 16.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NonTamedTargetGoal((TameableEntity)this, AnimalEntity.class, false, e -> !(e instanceof TameableDragonEntity)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLYING, (Object)false);
        this.field_70180_af.func_187214_a(DATA_SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(DATA_TICKS_ALIVE, (Object)LifeStageController.EnumLifeStage.ADULT.startTicks());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a(NBT_SADDLED, this.isSaddled());
        compound.func_74768_a(NBT_TICKS_ALIVE, this.getTicksAlive());
        compound.func_74768_a(NBT_REPRO_COUNT, this.reproCount);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSaddled(compound.func_74767_n(NBT_SADDLED));
        if (compound.func_74764_b(NBT_TICKS_ALIVE)) {
            this.setTicksAlive(compound.func_74762_e(NBT_TICKS_ALIVE));
        }
        this.reproCount = compound.func_74762_e(NBT_REPRO_COUNT);
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.field_70180_af.func_187227_b(DATA_SADDLED, (Object)saddled);
    }

    public int getTicksAlive() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_TICKS_ALIVE);
    }

    public void setTicksAlive(int ticksAlive) {
        this.field_70180_af.func_187227_b(DATA_TICKS_ALIVE, (Object)ticksAlive);
        this.getLifeStageController().setTicksAlive(ticksAlive);
    }

    public void addReproCount() {
        ++this.reproCount;
    }

    public boolean canFly() {
        return !this.isHatchling();
    }

    public boolean shouldFly() {
        return this.canFly() && !this.func_70090_H() && this.getAltitude() > 2.0;
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(DATA_FLYING, (Object)flying);
    }

    public boolean isBreathing() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_BREATHING);
    }

    public void setBreathing(boolean breathing) {
        this.field_70180_af.func_187227_b(DATA_BREATHING, (Object)breathing);
    }

    public LifeStageController getLifeStageController() {
        if (this.lifeStageController == null) {
            this.lifeStageController = new LifeStageController(this);
        }
        return this.lifeStageController;
    }

    public void func_70636_d() {
        this.getLifeStageController().tick();
        if (this.isServer()) {
            boolean flying = this.shouldFly();
            if (flying != this.isFlying()) {
                this.setFlying(flying);
                this.func_110148_a(Attributes.field_233819_b_).func_111128_a(flying ? 32.0 : 16.0);
                this.field_70699_by = flying ? new FlyingPathNavigator((MobEntity)this, this.field_70170_p) : new GroundPathNavigator((MobEntity)this, this.field_70170_p);
            }
        } else {
            this.animator.tick();
            this.func_82168_bl();
        }
        super.func_70636_d();
    }

    public void func_213352_e(Vector3d vec3d) {
        if (!this.isFlying()) {
            super.func_213352_e(vec3d);
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity rider = this.getRidingPlayer();
        if (rider == null || !this.func_152114_e((LivingEntity)rider)) {
            return;
        }
        this.field_70759_as = rider.field_70759_as;
        this.field_70125_A = rider.field_70125_A / 2.0f;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isFlying() && rider.field_70703_bu) {
            this.liftOff();
        }
        double x = this.func_226277_ct_();
        double y = this.func_226278_cu_();
        double z = this.func_226281_cx_();
        if (rider.field_70702_br != 0.0f || rider.field_191988_bg != 0.0f) {
            Vector3d wp = rider.func_70040_Z();
            if (rider.field_191988_bg < 0.0f) {
                wp = wp.func_178785_b((float)Math.PI);
            } else if (rider.field_70702_br > 0.0f) {
                wp = wp.func_178785_b(1.5707964f);
            } else if (rider.field_70702_br < 0.0f) {
                wp = wp.func_178785_b(-1.5707964f);
            }
            x += wp.field_72450_a * 10.0;
            y += wp.field_72448_b * 10.0;
            z += wp.field_72449_c * 10.0;
        }
        this.func_70605_aq().func_75642_a(x, y, z, 1.0);
    }

    public double getAltitude() {
        BlockPos.Mutable pos = this.func_233580_cy_().func_239590_i_();
        while (pos.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)pos).func_185904_a().func_76220_a()) {
            pos.func_196234_d(0, -1, 0);
        }
        return this.func_226278_cu_() - (double)pos.func_177956_o();
    }

    public void liftOff() {
        if (this.canFly()) {
            this.func_70664_aZ();
        }
    }

    protected float func_175134_bD() {
        return this.canFly() ? 1.0f : super.func_175134_bD();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (this.canFly()) {
            return false;
        }
        return super.func_225503_b_(distance, damageMultiplier);
    }

    protected void func_70609_aI() {
        this.func_184226_ay();
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70177_z = this.field_70126_B;
        this.field_70759_as = this.field_70758_at;
        if (this.field_70725_aQ >= this.getMaxDeathTime()) {
            this.func_70106_y();
        }
        ++this.field_70725_aQ;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ActionResultType stackResult = stack.func_111282_a_(player, (LivingEntity)this, hand);
        if (stackResult.func_226246_a_()) {
            return stackResult;
        }
        ActionResultType SUCCESS = ActionResultType.func_233537_a_((boolean)this.isClient());
        if (this.getHealthRelative() < 1.0 && this.isFoodItem(stack)) {
            this.func_70691_i(stack.func_77973_b().func_219967_s().func_221466_a());
            this.func_184185_a(this.func_213353_d(stack), 0.7f, 1.0f);
            stack.func_190918_g(1);
            return SUCCESS;
        }
        if (this.isTamedFor(player) && !this.func_70631_g_() && !this.isSaddled() && stack.func_77973_b() instanceof SaddleItem) {
            stack.func_190918_g(1);
            this.setSaddled(true);
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187726_cu, this.func_184176_by(), 1.0f, 1.0f);
            return SUCCESS;
        }
        if (this.func_70877_b(stack) && !this.func_70909_n()) {
            stack.func_190918_g(1);
            if (this.isServer()) {
                this.tamedFor(player, this.func_70681_au().nextInt(5) == 0);
            }
            return SUCCESS;
        }
        if (this.isTamedFor(player) && player.func_225608_bj_()) {
            if (this.isServer()) {
                this.field_70699_by.func_75499_g();
                if (this.func_233685_eM_()) {
                    this.func_70624_b(null);
                }
                this.func_233687_w_(!this.func_233685_eM_());
            }
            return SUCCESS;
        }
        if (this.func_70909_n() && this.isSaddled() && !this.func_70631_g_() && !this.func_70877_b(stack)) {
            if (this.isServer()) {
                this.setRidingPlayer(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
            this.func_233686_v_(false);
            return SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    protected SoundEvent func_184639_G() {
        if (this.func_70681_au().nextInt(5) == 0) {
            return SoundEvents.field_187525_aO;
        }
        return (SoundEvent)DMLRegistry.DRAGON_BREATHE_SOUND.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187526_aP;
    }

    public SoundEvent getStepSound() {
        return (SoundEvent)DMLRegistry.DRAGON_STEP_SOUND.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)DMLRegistry.DRAGON_DEATH_SOUND.get();
    }

    public SoundEvent func_213353_d(ItemStack itemStackIn) {
        return SoundEvents.field_187537_bA;
    }

    public SoundEvent getAttackSound() {
        return SoundEvents.field_187537_bA;
    }

    public SoundEvent getWingsSound() {
        return SoundEvents.field_187524_aN;
    }

    protected void func_180429_a(BlockPos entityPos, BlockState state) {
        if (this.func_70090_H()) {
            return;
        }
        SoundType soundType = state.func_215695_r();
        if (this.field_70170_p.func_180495_p(entityPos.func_177984_a()).func_177230_c() == Blocks.field_150433_aE) {
            soundType = Blocks.field_150433_aE.getSoundType(state, (IWorldReader)this.field_70170_p, entityPos, (Entity)this);
        }
        SoundEvent stepSound = this.getStepSound();
        if (this.isHatchling()) {
            stepSound = soundType.func_185844_d();
        }
        this.func_184185_a(stepSound, soundType.func_185843_a(), -1.0f);
    }

    public int func_70627_aG() {
        return 240;
    }

    protected float func_70599_aP() {
        return this.getScale();
    }

    protected float func_70647_i() {
        return this.getScale() - 2.0f;
    }

    public float getSoundPitch(SoundEvent sound) {
        return this.func_70647_i();
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        this.playSound(soundIn, volume, pitch, false);
    }

    public void playSound(SoundEvent sound, float volume, float pitch, boolean local) {
        if (this.func_174814_R()) {
            return;
        }
        volume *= this.func_70599_aP();
        pitch *= this.getSoundPitch(sound);
        if (local) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), sound, this.func_184176_by(), volume, pitch, false);
        } else {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), sound, this.func_184176_by(), volume, pitch);
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(DragonMountsLegacy.rl(this.func_200600_R().getRegistryName().func_110623_a() + "_spawn_egg")));
    }

    public boolean isFoodItem(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s().func_221467_c();
    }

    public boolean func_70877_b(ItemStack stack) {
        return ItemTags.field_206964_G.func_230235_a_((Object)stack.func_77973_b());
    }

    public void tamedFor(PlayerEntity player, boolean successful) {
        if (successful) {
            this.func_70903_f(true);
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            this.func_184754_b(player.func_110124_au());
            if (this.field_70170_p.field_72995_K) {
                this.func_70908_e(true);
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        } else {
            if (this.field_70170_p.field_72995_K) {
                this.func_70908_e(false);
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
        }
    }

    public boolean isTamedFor(PlayerEntity player) {
        return this.func_70909_n() && this.func_152114_e((LivingEntity)player);
    }

    public void addImmunities(DamageSource ... sources) {
        this.damageImmunities.addAll(Arrays.asList(sources));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        float eyeHeight = super.func_213348_b(poseIn, sizeIn);
        if (this.func_233685_eM_()) {
            eyeHeight *= 0.8f;
        }
        return eyeHeight;
    }

    public double func_70042_X() {
        return (this.func_233685_eM_() ? 1.7f : 2.0f) * this.getScale();
    }

    public float func_213355_cm() {
        return this.getScale();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        if (this.isSaddled()) {
            this.func_199703_a((IItemProvider)Items.field_151141_av);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean attacked = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
        if (attacked) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return attacked;
    }

    public void onWingsDown(float speed) {
        if (!this.func_70090_H()) {
            float pitch = 1.0f - speed;
            float volume = 0.3f + (1.0f - speed) * 0.2f;
            this.playSound(this.getWingsSound(), volume, pitch, true);
        }
    }

    public void func_184609_a(Hand hand) {
        this.func_184185_a(this.getAttackSound(), 1.0f, 0.7f);
        super.func_184609_a(hand);
    }

    public boolean func_70097_a(DamageSource src, float par2) {
        if (this.func_180431_b(src)) {
            return false;
        }
        this.func_233687_w_(false);
        return super.func_70097_a(src, par2);
    }

    public boolean func_70878_b(AnimalEntity mate) {
        if (mate == this) {
            return false;
        }
        if (!(mate instanceof TameableDragonEntity)) {
            return false;
        }
        if (!this.canReproduce()) {
            return false;
        }
        TameableDragonEntity dragonMate = (TameableDragonEntity)mate;
        if (!dragonMate.func_70909_n()) {
            return false;
        }
        if (!dragonMate.canReproduce()) {
            return false;
        }
        return this.func_70880_s() && dragonMate.func_70880_s();
    }

    public boolean canReproduce() {
        return this.func_70909_n() && this.reproCount < 2;
    }

    public void func_234177_a_(ServerWorld world, AnimalEntity mate) {
        if (!(mate instanceof TameableDragonEntity)) {
            throw new IllegalArgumentException("The mate isn't a dragon");
        }
        DragonEggEntity egg = (DragonEggEntity)((EntityType)DMLRegistry.EGG_ENTITY.get()).func_200721_a((World)world);
        if (this.func_70681_au().nextBoolean()) {
            egg.setEggType((Block)DragonEggBlock.lookUp(this.func_200600_R()));
        } else {
            egg.setEggType((Block)DragonEggBlock.lookUp(mate.func_200600_R()));
        }
        if (this.func_145818_k_() && mate.func_145818_k_()) {
            String babyName;
            String p1Name = this.func_200201_e().getString();
            String p2Name = mate.func_200201_e().getString();
            if (p1Name.contains(" ") || p2Name.contains(" ")) {
                String[] p1Names = p1Name.split(" ");
                String[] p2Names = p2Name.split(" ");
                p1Name = DragonBreedGoal.fixChildName(p1Names[this.field_70146_Z.nextInt(p1Names.length)]);
                p2Name = DragonBreedGoal.fixChildName(p2Names[this.field_70146_Z.nextInt(p2Names.length)]);
                babyName = this.field_70146_Z.nextBoolean() ? p1Name + " " + p2Name : p2Name + " " + p1Name;
            } else {
                p1Name = this.field_70146_Z.nextBoolean() ? p1Name.substring(0, (p1Name.length() - 1) / 2) : p1Name.substring((p1Name.length() - 1) / 2);
                p2Name = this.field_70146_Z.nextBoolean() ? p2Name.substring(0, (p2Name.length() - 1) / 2) : p2Name.substring((p2Name.length() - 1) / 2);
                p2Name = DragonBreedGoal.fixChildName(p2Name);
                babyName = this.field_70146_Z.nextBoolean() ? p1Name + p2Name : p2Name + p1Name;
            }
            egg.func_200203_b((ITextComponent)new StringTextComponent(babyName));
        }
        this.addReproCount();
        ((TameableDragonEntity)mate).addReproCount();
        egg.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        world.func_217376_c((Entity)egg);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (target instanceof TameableEntity) {
            return !Objects.equals(((TameableEntity)target).func_70902_q(), owner);
        }
        return true;
    }

    public boolean func_213358_a(EntityType<?> typeIn) {
        return !this.isHatchling() && super.func_213358_a(typeIn);
    }

    public boolean func_213336_c(LivingEntity target) {
        return !this.isHatchling() && super.func_213336_c(target);
    }

    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean func_184186_bw() {
        return false;
    }

    public PlayerEntity getRidingPlayer() {
        Entity entity = this.func_184179_bs();
        if (entity instanceof PlayerEntity) {
            return (PlayerEntity)entity;
        }
        return null;
    }

    public void setRidingPlayer(PlayerEntity player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        player.func_184220_m((Entity)this);
    }

    public void func_184232_k(Entity passenger) {
        Entity riddenByEntity = this.func_184179_bs();
        if (riddenByEntity != null) {
            Vector3d pos = new Vector3d(0.0, this.func_70042_X() + riddenByEntity.func_70033_W(), 0.8 * (double)this.getScale()).func_178785_b((float)Math.toRadians(-this.field_70761_aq)).func_178787_e(this.func_213303_ch());
            passenger.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            if (this.func_184187_bx() instanceof LivingEntity) {
                LivingEntity rider = (LivingEntity)riddenByEntity;
                rider.field_70127_C = rider.field_70125_A;
                rider.field_70126_B = rider.field_70177_z;
                rider.field_70761_aq = this.field_70761_aq;
            }
        }
    }

    public boolean func_180431_b(DamageSource src) {
        Entity srcEnt = src.func_76346_g();
        if (srcEnt != null) {
            if (srcEnt == this) {
                return true;
            }
            if (this.func_184196_w(srcEnt)) {
                return true;
            }
        }
        return this.damageImmunities.contains(src);
    }

    public double getHealthRelative() {
        return (double)this.func_110143_aJ() / (double)this.func_110138_aP();
    }

    public int getDeathTime() {
        return this.field_70725_aQ;
    }

    public int getMaxDeathTime() {
        return 120;
    }

    public void func_213323_x_() {
        double posXTmp = this.func_226277_ct_();
        double posYTmp = this.func_226278_cu_();
        double posZTmp = this.func_226281_cx_();
        boolean onGroundTmp = this.field_70122_E;
        super.func_213323_x_();
        this.func_70107_b(posXTmp, posYTmp, posZTmp);
        this.field_70122_E = onGroundTmp;
    }

    public int func_70874_b() {
        return this.isAdult() ? 0 : -1;
    }

    public void func_70873_a(int age) {
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(2.75f * this.getScale(), 2.75f * this.getScale(), false);
    }

    public float getScale() {
        return this.getLifeStageController().getScale();
    }

    public boolean isHatchling() {
        return this.getLifeStageController().isHatchling();
    }

    public boolean isJuvenile() {
        return this.getLifeStageController().isJuvenile();
    }

    public boolean isAdult() {
        return this.getLifeStageController().isAdult();
    }

    public boolean func_70631_g_() {
        return !this.isAdult();
    }

    public final boolean isClient() {
        return this.field_70170_p.field_72995_K;
    }

    public final boolean isServer() {
        return !this.field_70170_p.field_72995_K;
    }
}

